/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.auditlog.OMAGAuditCode;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public abstract class AccessServiceAdmin {
    private static int defaultKarmaPointThreshold = 500;
    private static int defaultKarmaPointInterval = 0;
    protected String supportedZonesPropertyName = "SupportedZones";
    protected String defaultZonesPropertyName = "DefaultZones";
    protected String karmaPointPlateauPropertyName = "KarmaPointPlateau";
    protected String karmaPointIncrementPropertyName = "KarmaPointIncrement";

    public abstract void initialize(AccessServiceConfig var1, OMRSTopicConnector var2, OMRSRepositoryConnector var3, OMRSAuditLog var4, String var5) throws OMAGConfigurationErrorException;

    public abstract void shutdown();

    protected List<String> extractSupportedZones(Map<String, Object> accessServiceOptions, String accessServiceName, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractSupportedZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get(this.supportedZonesPropertyName);
        if (zoneListObject == null) {
            OMAGAuditCode auditCode = OMAGAuditCode.ALL_ZONES;
            auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            OMAGAuditCode auditCode = OMAGAuditCode.SUPPORTED_ZONES;
            auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, zoneList.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return zoneList;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceName, this.supportedZonesPropertyName, zoneListObject.toString(), auditLog, "extractSupportedZones", error);
            return null;
        }
    }

    protected List<String> extractDefaultZones(Map<String, Object> accessServiceOptions, String accessServiceName, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractDefaultZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get(this.defaultZonesPropertyName);
        if (zoneListObject == null) {
            OMAGAuditCode auditCode = OMAGAuditCode.DEFAULT_ZONES;
            auditLog.logRecord("extractDefaultZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, "<null>"), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            OMAGAuditCode auditCode = OMAGAuditCode.DEFAULT_ZONES;
            auditLog.logRecord("extractDefaultZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, zoneList.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return zoneList;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceName, this.defaultZonesPropertyName, zoneListObject.toString(), auditLog, "extractDefaultZones", error);
            return null;
        }
    }

    protected int extractKarmaPointIncrement(Map<String, Object> accessServiceOptions, String accessServiceName, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractKarmaPointIncrement";
        if (accessServiceOptions == null) {
            return this.useDefaultKarmaPointIncrement(accessServiceName, auditLog, "extractKarmaPointIncrement");
        }
        Object incrementObject = accessServiceOptions.get(this.karmaPointIncrementPropertyName);
        if (incrementObject == null) {
            return this.useDefaultKarmaPointIncrement(accessServiceName, auditLog, "extractKarmaPointIncrement");
        }
        try {
            int increment = Integer.parseInt(incrementObject.toString());
            OMAGAuditCode auditCode = OMAGAuditCode.KARMA_POINT_COLLECTION_INCREMENT;
            auditLog.logRecord("extractKarmaPointIncrement", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, Integer.toString(increment)), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return increment;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceName, this.karmaPointIncrementPropertyName, incrementObject.toString(), auditLog, "extractKarmaPointIncrement", error);
            return 0;
        }
    }

    private int useDefaultKarmaPointIncrement(String accessServiceName, OMRSAuditLog auditLog, String methodName) {
        OMAGAuditCode auditCode = OMAGAuditCode.NO_KARMA_POINT_COLLECTION;
        auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return defaultKarmaPointInterval;
    }

    protected int extractKarmaPointPlateau(Map<String, Object> accessServiceOptions, String accessServiceName, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractKarmaPointPlateau";
        if (accessServiceOptions == null) {
            return this.useDefaultPlateauThreshold(accessServiceName, auditLog, "extractKarmaPointPlateau");
        }
        Object plateauThresholdObject = accessServiceOptions.get(this.karmaPointPlateauPropertyName);
        if (plateauThresholdObject == null) {
            return this.useDefaultPlateauThreshold(accessServiceName, auditLog, "extractKarmaPointPlateau");
        }
        try {
            int plateauThreshold = Integer.parseInt(plateauThresholdObject.toString());
            OMAGAuditCode auditCode = OMAGAuditCode.PLATEAU_THRESHOLD;
            auditLog.logRecord("extractKarmaPointPlateau", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, Integer.toString(plateauThreshold)), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return plateauThreshold;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceName, this.karmaPointPlateauPropertyName, plateauThresholdObject.toString(), auditLog, "extractKarmaPointPlateau", error);
            return 0;
        }
    }

    private int useDefaultPlateauThreshold(String accessServiceName, OMRSAuditLog auditLog, String methodName) {
        OMAGAuditCode auditCode = OMAGAuditCode.DEFAULT_PLATEAU_THRESHOLD;
        auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, Integer.toString(defaultKarmaPointThreshold)), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return defaultKarmaPointThreshold;
    }

    private void logBadConfigProperties(String accessServiceName, String propertyName, String propertyValue, OMRSAuditLog auditLog, String methodName, Throwable error) throws OMAGConfigurationErrorException {
        OMAGAuditCode auditCode = OMAGAuditCode.BAD_CONFIG_PROPERTY;
        auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, propertyValue, propertyName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_CONFIG_PROPERTIES;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{accessServiceName, propertyValue, propertyName, error.getClass().getName(), error.getMessage()});
        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
    }

    protected void registerWithEnterpriseTopic(String accessServiceName, String serverName, OMRSTopicConnector omrsTopicConnector, OMRSTopicListener omrsTopicListener, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize OMAS";
        String methodName = "initialize";
        if (omrsTopicConnector == null) {
            OMAGAuditCode auditCode = OMAGAuditCode.NO_ENTERPRISE_TOPIC;
            auditLog.logRecord("initialize OMAS", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NO_ENTERPRISE_TOPIC;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{accessServiceName, serverName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        OMAGAuditCode auditCode = OMAGAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC;
        auditLog.logRecord("initialize OMAS", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceName, serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        omrsTopicConnector.registerListener(omrsTopicListener);
    }

    protected String getTopicName(Connection connection) {
        Endpoint topicEndpoint;
        String topicName = null;
        if (connection != null && (topicEndpoint = connection.getEndpoint()) != null) {
            topicName = topicEndpoint.getAddress();
        }
        return topicName;
    }

    protected OpenMetadataTopicConnector getInTopicConnector(Connection inTopicConnection, String accessServiceName, OMRSAuditLog parentAuditLog) throws OMAGConfigurationErrorException {
        String methodName = "getInTopicConnector";
        return this.getTopicConnector(inTopicConnection, parentAuditLog.createNewAuditLog(OMRSAuditingComponent.OMAS_IN_TOPIC), accessServiceName, "getInTopicConnector");
    }

    protected OpenMetadataTopicConnector getOutTopicConnector(Connection outTopicConnection, String accessServiceName, OMRSAuditLog parentAuditLog) throws OMAGConfigurationErrorException {
        String methodName = "getOutTopicConnector";
        return this.getTopicConnector(outTopicConnection, parentAuditLog.createNewAuditLog(OMRSAuditingComponent.OMAS_OUT_TOPIC), accessServiceName, "getOutTopicConnector");
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, OMRSAuditLog auditLog, String accessServiceName, String methodName) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(topicConnection);
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connector;
            topicConnector.setAuditLog(auditLog);
            return topicConnector;
        }
        catch (Throwable error) {
            OMAGAuditCode auditCode = OMAGAuditCode.BAD_TOPIC_CONNECTOR;
            auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(methodName, accessServiceName, error.getClass().getName(), error.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, accessServiceName, error.getClass().getName(), error.getMessage()});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

