/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import org.odpi.openmetadata.adminservices.configuration.auditlog.OMAGAuditCode;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public abstract class ViewServiceAdmin {
    protected final String remoteServerName = "remoteServerName";
    protected final String remoteServerURL = "remoteServerURL";

    public abstract void initialize(String var1, ViewServiceConfig var2, OMRSAuditLog var3, String var4, int var5) throws OMAGConfigurationErrorException;

    public abstract void shutdown();

    private void logBadConfigProperties(String viewServiceFullName, String propertyName, String propertyValue, OMRSAuditLog auditLog, String methodName, Throwable error) throws OMAGConfigurationErrorException {
        OMAGAuditCode auditCode = OMAGAuditCode.BAD_CONFIG_PROPERTY;
        auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(viewServiceFullName, propertyValue, propertyName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_CONFIG_PROPERTIES;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{viewServiceFullName, propertyValue, propertyName, error.getClass().getName(), error.getMessage()});
        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
    }

    protected void throwUnexpectedInitializationException(String actionDescription, String fullViewServiceName, Throwable error) throws OMAGConfigurationErrorException {
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION;
        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), actionDescription, errorCode.getFormattedErrorMessage(new String[]{fullViewServiceName, error.getClass().getName(), error.getMessage()}), errorCode.getSystemAction(), errorCode.getUserAction(), error);
    }
}

