/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;

public class OMAGAccessServiceRegistration {
    private static Map<String, AccessServiceRegistration> accessServiceRegistrationMap = new HashMap<String, AccessServiceRegistration>();

    public static synchronized void registerAccessService(AccessServiceRegistration registration) {
        String serviceName;
        if (registration != null && (serviceName = registration.getAccessServiceName()) != null) {
            accessServiceRegistrationMap.put(serviceName, registration);
        }
    }

    public static synchronized List<AccessServiceRegistration> getAccessServiceRegistrationList() {
        ArrayList<AccessServiceRegistration> registrationList = new ArrayList<AccessServiceRegistration>();
        for (AccessServiceRegistration accessServiceRegistration : accessServiceRegistrationMap.values()) {
            if (accessServiceRegistration == null) continue;
            registrationList.add(accessServiceRegistration);
        }
        return registrationList;
    }

    public static synchronized AccessServiceRegistration getAccessServiceRegistration(String urlMarker) {
        if (urlMarker != null) {
            for (AccessServiceRegistration accessServiceRegistration : accessServiceRegistrationMap.values()) {
                if (accessServiceRegistration == null || !urlMarker.equals(accessServiceRegistration.getAccessServiceURLMarker())) continue;
                return accessServiceRegistration;
            }
        }
        return null;
    }
}

