/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public abstract class AccessServiceAdmin {
    private static int defaultKarmaPointThreshold = 500;
    private static int defaultKarmaPointInterval = 0;
    protected String supportedZonesPropertyName = "SupportedZones";
    protected String defaultZonesPropertyName = "DefaultZones";
    protected String publishZonesPropertyName = "PublishZones";
    protected String karmaPointPlateauPropertyName = "KarmaPointPlateau";
    protected String karmaPointIncrementPropertyName = "KarmaPointIncrement";

    @Deprecated
    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        this.initialize(accessServiceConfigurationProperties, enterpriseOMRSTopicConnector, enterpriseOMRSRepositoryConnector, (AuditLog)auditLog, serverUserName);
    }

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
    }

    public abstract void shutdown();

    protected List<String> extractSupportedZones(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractSupportedZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get(this.supportedZonesPropertyName);
        if (zoneListObject == null) {
            auditLog.logMessage("extractSupportedZones", OMAGAdminAuditCode.ALL_ZONES.getMessageDefinition(new String[]{accessServiceFullName}));
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            auditLog.logMessage("extractSupportedZones", OMAGAdminAuditCode.SUPPORTED_ZONES.getMessageDefinition(new String[]{accessServiceFullName, zoneList.toString()}));
            return zoneList;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceFullName, this.supportedZonesPropertyName, zoneListObject.toString(), auditLog, "extractSupportedZones", error);
            return null;
        }
    }

    protected List<String> extractPublishZones(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractPublishZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get(this.publishZonesPropertyName);
        if (zoneListObject == null) {
            auditLog.logMessage("extractPublishZones", OMAGAdminAuditCode.PUBLISH_ZONES.getMessageDefinition(new String[]{accessServiceFullName, "<null>"}));
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            auditLog.logMessage("extractPublishZones", OMAGAdminAuditCode.PUBLISH_ZONES.getMessageDefinition(new String[]{accessServiceFullName, zoneList.toString()}));
            return zoneList;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceFullName, this.publishZonesPropertyName, zoneListObject.toString(), auditLog, "extractPublishZones", error);
            return null;
        }
    }

    protected List<String> extractDefaultZones(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractDefaultZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get(this.defaultZonesPropertyName);
        if (zoneListObject == null) {
            auditLog.logMessage("extractDefaultZones", OMAGAdminAuditCode.DEFAULT_ZONES.getMessageDefinition(new String[]{accessServiceFullName, "<null>"}));
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            auditLog.logMessage("extractDefaultZones", OMAGAdminAuditCode.DEFAULT_ZONES.getMessageDefinition(new String[]{accessServiceFullName, zoneList.toString()}));
            return zoneList;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceFullName, this.defaultZonesPropertyName, zoneListObject.toString(), auditLog, "extractDefaultZones", error);
            return null;
        }
    }

    protected int extractKarmaPointIncrement(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractKarmaPointIncrement";
        if (accessServiceOptions == null) {
            return this.useDefaultKarmaPointIncrement(accessServiceFullName, auditLog, "extractKarmaPointIncrement");
        }
        Object incrementObject = accessServiceOptions.get(this.karmaPointIncrementPropertyName);
        if (incrementObject == null) {
            return this.useDefaultKarmaPointIncrement(accessServiceFullName, auditLog, "extractKarmaPointIncrement");
        }
        try {
            int increment = Integer.parseInt(incrementObject.toString());
            auditLog.logMessage("extractKarmaPointIncrement", OMAGAdminAuditCode.KARMA_POINT_COLLECTION_INCREMENT.getMessageDefinition(new String[]{accessServiceFullName, Integer.toString(increment)}));
            return increment;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceFullName, this.karmaPointIncrementPropertyName, incrementObject.toString(), auditLog, "extractKarmaPointIncrement", error);
            return 0;
        }
    }

    private int useDefaultKarmaPointIncrement(String accessServiceFullName, AuditLog auditLog, String methodName) {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.NO_KARMA_POINT_COLLECTION.getMessageDefinition(new String[]{accessServiceFullName}));
        return defaultKarmaPointInterval;
    }

    protected int extractKarmaPointPlateau(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractKarmaPointPlateau";
        if (accessServiceOptions == null) {
            return this.useDefaultPlateauThreshold(accessServiceFullName, auditLog, "extractKarmaPointPlateau");
        }
        Object plateauThresholdObject = accessServiceOptions.get(this.karmaPointPlateauPropertyName);
        if (plateauThresholdObject == null) {
            return this.useDefaultPlateauThreshold(accessServiceFullName, auditLog, "extractKarmaPointPlateau");
        }
        try {
            int plateauThreshold = Integer.parseInt(plateauThresholdObject.toString());
            auditLog.logMessage("extractKarmaPointPlateau", OMAGAdminAuditCode.PLATEAU_THRESHOLD.getMessageDefinition(new String[]{accessServiceFullName, Integer.toString(plateauThreshold)}));
            return plateauThreshold;
        }
        catch (Throwable error) {
            this.logBadConfigProperties(accessServiceFullName, this.karmaPointPlateauPropertyName, plateauThresholdObject.toString(), auditLog, "extractKarmaPointPlateau", error);
            return 0;
        }
    }

    private int useDefaultPlateauThreshold(String accessServiceFullName, AuditLog auditLog, String methodName) {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.DEFAULT_PLATEAU_THRESHOLD.getMessageDefinition(new String[]{accessServiceFullName, Integer.toString(defaultKarmaPointThreshold)}));
        return defaultKarmaPointThreshold;
    }

    private void logBadConfigProperties(String accessServiceFullName, String propertyName, String propertyValue, AuditLog auditLog, String methodName, Throwable error) throws OMAGConfigurationErrorException {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.BAD_CONFIG_PROPERTY.getMessageDefinition(new String[]{accessServiceFullName, propertyValue, propertyName}));
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_CONFIG_PROPERTIES.getMessageDefinition(new String[]{accessServiceFullName, propertyValue, propertyName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName, error);
    }

    protected void registerWithEnterpriseTopic(String accessServiceFullName, String serverName, OMRSTopicConnector omrsTopicConnector, OMRSTopicListener omrsTopicListener, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize OMAS";
        String methodName = "initialize";
        if (omrsTopicConnector == null) {
            auditLog.logMessage("initialize OMAS", OMAGAdminAuditCode.NO_ENTERPRISE_TOPIC.getMessageDefinition(new String[]{accessServiceFullName, serverName}));
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.NO_ENTERPRISE_TOPIC.getMessageDefinition(new String[]{accessServiceFullName, serverName}), this.getClass().getName(), "initialize");
        }
        auditLog.logMessage("initialize OMAS", OMAGAdminAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC.getMessageDefinition(new String[]{accessServiceFullName, serverName}));
        omrsTopicConnector.registerListener(omrsTopicListener, accessServiceFullName);
    }

    protected String getTopicName(Connection connection) {
        Endpoint topicEndpoint;
        String topicName = null;
        if (connection != null && (topicEndpoint = connection.getEndpoint()) != null) {
            topicName = topicEndpoint.getAddress();
        }
        return topicName;
    }

    protected OpenMetadataTopicConnector getInTopicEventBusConnector(Connection inTopicConnection, String accessServiceFullName, AuditLog parentAuditLog) throws OMAGConfigurationErrorException {
        String methodName = "getInTopicConnector";
        return this.getTopicConnector(inTopicConnection, parentAuditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_IN_TOPIC), accessServiceFullName, "getInTopicConnector");
    }

    protected OpenMetadataTopicConnector getOutTopicEventBusConnector(Connection outTopicEventBusConnection, String accessServiceName, AuditLog parentAuditLog) throws OMAGConfigurationErrorException {
        String methodName = "getOutTopicConnector";
        return this.getTopicConnector(outTopicEventBusConnection, parentAuditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC), accessServiceName, "getOutTopicConnector");
    }

    protected Connection getOutTopicConnection(Connection outTopicEventBusConnection, String accessServiceFullName, String accessServiceConnectorProviderClassName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "getOutTopicConnection";
        String connectionDescription = "OMRS default cohort topic connection.";
        String eventSource = "Server Event Bus";
        ElementType elementType = VirtualConnection.getVirtualConnectionType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        String connectionName = "OutTopicConnector." + accessServiceFullName;
        VirtualConnection connection = new VirtualConnection();
        elementType = VirtualConnection.getVirtualConnectionType();
        connection.setType(elementType);
        connection.setGUID(UUID.randomUUID().toString());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("OMRS default cohort topic connection.");
        connection.setConnectorType(this.getConnectorType(accessServiceFullName, accessServiceConnectorProviderClassName, auditLog, "getOutTopicConnection"));
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        embeddedConnection.setDisplayName("Server Event Bus");
        embeddedConnection.setArguments(null);
        embeddedConnection.setEmbeddedConnection(outTopicEventBusConnection);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        embeddedConnections.add(embeddedConnection);
        connection.setEmbeddedConnections(embeddedConnections);
        return connection;
    }

    private ConnectorType getConnectorType(String accessServiceFullName, String connectorProviderClassName, AuditLog auditLog, String methodName) throws OMAGConfigurationErrorException {
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null) {
            try {
                Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
                Object potentialConnectorProvider = connectorProviderClass.newInstance();
                ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
                connectorType = connectorProvider.getConnectorType();
                if (connectorType == null) {
                    connectorType = new ConnectorType();
                    connectorType.setType(connectorType.getType());
                    connectorType.setGUID(UUID.randomUUID().toString());
                    connectorType.setQualifiedName(connectorProviderClassName);
                    connectorType.setDisplayName(connectorProviderClass.getSimpleName());
                    connectorType.setDescription("ConnectorType for " + connectorType.getDisplayName());
                    connectorType.setConnectorProviderClassName(connectorProviderClassName);
                }
            }
            catch (Exception error) {
                auditLog.logException(methodName, OMAGAdminAuditCode.BAD_TOPIC_CONNECTOR_PROVIDER.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_TOPIC_CONNECTOR_PROVIDER.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName);
            }
        }
        return connectorType;
    }

    protected void throwUnexpectedInitializationException(String actionDescription, String fullAccessServiceName, Throwable error) throws OMAGConfigurationErrorException {
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{fullAccessServiceName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), actionDescription, error);
    }

    public <T> T getTopicConnector(Connection topicConnection, Class<T> topicConnectorClass, AuditLog auditLog, String accessServiceFullName, String methodName) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(topicConnection);
            if (connector instanceof AuditLoggingComponent) {
                AuditLoggingComponent topicConnector = (AuditLoggingComponent)connector;
                topicConnector.setAuditLog(auditLog);
            }
            connector.start();
            return (T)connector;
        }
        catch (Exception error) {
            auditLog.logException(methodName, OMAGAdminAuditCode.BAD_TOPIC_CONNECTOR.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_TOPIC_CONNECTOR.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName);
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, AuditLog auditLog, String accessServiceFullName, String methodName) throws OMAGConfigurationErrorException {
        return this.getTopicConnector(topicConnection, OpenMetadataTopicConnector.class, auditLog, accessServiceFullName, methodName);
    }
}

