/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;

public abstract class ViewServiceAdmin {
    protected final String remoteServerName = "remoteServerName";
    protected final String remoteServerURL = "remoteServerURL";
    private String fullServiceName = null;

    public abstract void initialize(String var1, ViewServiceConfig var2, AuditLog var3, String var4, int var5) throws OMAGConfigurationErrorException;

    public abstract void shutdown();

    public String getFullServiceName() {
        return this.fullServiceName;
    }

    public void setFullServiceName(String fullServiceName) {
        this.fullServiceName = fullServiceName;
    }

    protected void logBadConfiguration(String viewServiceFullName, String propertyName, String propertyValue, AuditLog auditLog, String methodName) throws OMAGConfigurationErrorException {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.BAD_CONFIG_PROPERTY.getMessageDefinition(new String[]{viewServiceFullName, propertyValue, propertyName}));
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.VIEW_SERVICE_CONFIG.getMessageDefinition(new String[]{viewServiceFullName, propertyValue, propertyName}), this.getClass().getName(), methodName);
    }

    protected void logBadConfigProperties(String viewServiceFullName, String propertyName, String propertyValue, AuditLog auditLog, String methodName, Throwable error) throws OMAGConfigurationErrorException {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.BAD_CONFIG_PROPERTY.getMessageDefinition(new String[]{viewServiceFullName, propertyValue, propertyName}));
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_CONFIG_PROPERTIES.getMessageDefinition(new String[]{viewServiceFullName, propertyValue, propertyName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName, error);
    }

    protected void throwUnexpectedInitializationException(String actionDescription, String fullViewServiceName, Throwable error) throws OMAGConfigurationErrorException {
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{fullViewServiceName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), actionDescription, error);
    }
}

