/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistrationEntry;

public class OMAGAccessServiceRegistration {
    private static final Map<String, AccessServiceRegistrationEntry> accessServiceRegistrationMap = new HashMap<String, AccessServiceRegistrationEntry>();

    public static synchronized void registerAccessService(AccessServiceRegistrationEntry registration) {
        String serviceName;
        if (registration != null && (serviceName = registration.getAccessServiceName()) != null) {
            accessServiceRegistrationMap.put(serviceName, registration);
        }
    }

    public static synchronized List<AccessServiceRegistrationEntry> getAccessServiceRegistrationList() {
        ArrayList<AccessServiceRegistrationEntry> registrationList = new ArrayList<AccessServiceRegistrationEntry>();
        for (AccessServiceRegistrationEntry accessServiceRegistration : accessServiceRegistrationMap.values()) {
            if (accessServiceRegistration == null) continue;
            registrationList.add(accessServiceRegistration);
        }
        return registrationList;
    }

    public static synchronized AccessServiceRegistrationEntry getAccessServiceRegistration(String urlMarker) {
        if (urlMarker != null) {
            for (AccessServiceRegistrationEntry accessServiceRegistration : accessServiceRegistrationMap.values()) {
                if (accessServiceRegistration == null || !urlMarker.equals(accessServiceRegistration.getAccessServiceURLMarker())) continue;
                return accessServiceRegistration;
            }
        }
        return null;
    }
}

