/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistrationEntry;

public class OMAGViewServiceRegistration {
    private static final Map<String, ViewServiceRegistrationEntry> viewServiceRegistrationMap = new HashMap<String, ViewServiceRegistrationEntry>();

    public static synchronized void registerViewService(ViewServiceRegistrationEntry registration) {
        String serviceName;
        if (registration != null && (serviceName = registration.getViewServiceName()) != null) {
            viewServiceRegistrationMap.put(serviceName, registration);
        }
    }

    public static synchronized List<ViewServiceRegistrationEntry> getViewServiceRegistrationList() {
        ArrayList<ViewServiceRegistrationEntry> registrationList = new ArrayList<ViewServiceRegistrationEntry>();
        for (ViewServiceRegistrationEntry viewServiceRegistration : viewServiceRegistrationMap.values()) {
            if (viewServiceRegistration == null) continue;
            registrationList.add(viewServiceRegistration);
        }
        return registrationList;
    }

    public static synchronized ViewServiceRegistrationEntry getViewServiceRegistration(String urlMarker) {
        if (urlMarker != null) {
            for (ViewServiceRegistrationEntry viewServiceRegistration : viewServiceRegistrationMap.values()) {
                if (viewServiceRegistration == null || !urlMarker.equals(viewServiceRegistration.getViewServiceURLMarker())) continue;
                return viewServiceRegistration;
            }
        }
        return null;
    }
}

