/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementOrigin;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public abstract class AccessServiceAdmin {
    private static final int defaultKarmaPointThreshold = 500;
    private static final int defaultKarmaPointInterval = 0;
    protected final String supportedZonesPropertyName = "SupportedZones";
    protected final String defaultZonesPropertyName = "DefaultZones";
    protected final String publishZonesPropertyName = "PublishZones";
    protected final String karmaPointPlateauPropertyName = "KarmaPointPlateau";
    protected final String karmaPointIncrementPropertyName = "KarmaPointIncrement";
    protected final String supportedTypesForSearch = "SupportedTypesForSearch";
    private String fullServiceName = null;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
    }

    public String getFullServiceName() {
        return this.fullServiceName;
    }

    public void setFullServiceName(String fullServiceName) {
        this.fullServiceName = fullServiceName;
    }

    public abstract void shutdown();

    protected List<String> extractSupportedZones(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractSupportedZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get("SupportedZones");
        if (zoneListObject == null) {
            auditLog.logMessage("extractSupportedZones", OMAGAdminAuditCode.ALL_ZONES.getMessageDefinition(new String[]{accessServiceFullName}));
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            auditLog.logMessage("extractSupportedZones", OMAGAdminAuditCode.SUPPORTED_ZONES.getMessageDefinition(new String[]{accessServiceFullName, zoneList.toString()}));
            return zoneList;
        }
        catch (Exception error) {
            this.logBadConfigProperties(accessServiceFullName, "SupportedZones", zoneListObject.toString(), auditLog, "extractSupportedZones", error);
            return null;
        }
    }

    protected List<String> extractPublishZones(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractPublishZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get("PublishZones");
        if (zoneListObject == null) {
            auditLog.logMessage("extractPublishZones", OMAGAdminAuditCode.PUBLISH_ZONES.getMessageDefinition(new String[]{accessServiceFullName, "<null>"}));
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            auditLog.logMessage("extractPublishZones", OMAGAdminAuditCode.PUBLISH_ZONES.getMessageDefinition(new String[]{accessServiceFullName, zoneList.toString()}));
            return zoneList;
        }
        catch (Exception error) {
            this.logBadConfigProperties(accessServiceFullName, "PublishZones", zoneListObject.toString(), auditLog, "extractPublishZones", error);
            return null;
        }
    }

    protected List<String> extractDefaultZones(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractDefaultZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get("DefaultZones");
        if (zoneListObject == null) {
            auditLog.logMessage("extractDefaultZones", OMAGAdminAuditCode.DEFAULT_ZONES.getMessageDefinition(new String[]{accessServiceFullName, "<null>"}));
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            auditLog.logMessage("extractDefaultZones", OMAGAdminAuditCode.DEFAULT_ZONES.getMessageDefinition(new String[]{accessServiceFullName, zoneList.toString()}));
            return zoneList;
        }
        catch (Exception error) {
            this.logBadConfigProperties(accessServiceFullName, "DefaultZones", zoneListObject.toString(), auditLog, "extractDefaultZones", error);
            return null;
        }
    }

    protected int extractKarmaPointIncrement(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractKarmaPointIncrement";
        if (accessServiceOptions == null) {
            return this.useDefaultKarmaPointIncrement(accessServiceFullName, auditLog, "extractKarmaPointIncrement");
        }
        Object incrementObject = accessServiceOptions.get("KarmaPointIncrement");
        if (incrementObject == null) {
            return this.useDefaultKarmaPointIncrement(accessServiceFullName, auditLog, "extractKarmaPointIncrement");
        }
        try {
            int increment = Integer.parseInt(incrementObject.toString());
            auditLog.logMessage("extractKarmaPointIncrement", OMAGAdminAuditCode.KARMA_POINT_COLLECTION_INCREMENT.getMessageDefinition(new String[]{accessServiceFullName, Integer.toString(increment)}));
            return increment;
        }
        catch (Exception error) {
            this.logBadConfigProperties(accessServiceFullName, "KarmaPointIncrement", incrementObject.toString(), auditLog, "extractKarmaPointIncrement", error);
            return 0;
        }
    }

    protected List<String> getSupportedTypesForSearchOption(AccessServiceConfig accessServiceConfig) {
        Object supportedTypesProperty;
        if (accessServiceConfig.getAccessServiceOptions() != null && (supportedTypesProperty = accessServiceConfig.getAccessServiceOptions().get("SupportedTypesForSearch")) instanceof List) {
            return (List)supportedTypesProperty;
        }
        return null;
    }

    private int useDefaultKarmaPointIncrement(String accessServiceFullName, AuditLog auditLog, String methodName) {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.NO_KARMA_POINT_COLLECTION.getMessageDefinition(new String[]{accessServiceFullName}));
        return 0;
    }

    protected int extractKarmaPointPlateau(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractKarmaPointPlateau";
        if (accessServiceOptions == null) {
            return this.useDefaultPlateauThreshold(accessServiceFullName, auditLog, "extractKarmaPointPlateau");
        }
        Object plateauThresholdObject = accessServiceOptions.get("KarmaPointPlateau");
        if (plateauThresholdObject == null) {
            return this.useDefaultPlateauThreshold(accessServiceFullName, auditLog, "extractKarmaPointPlateau");
        }
        try {
            int plateauThreshold = Integer.parseInt(plateauThresholdObject.toString());
            auditLog.logMessage("extractKarmaPointPlateau", OMAGAdminAuditCode.PLATEAU_THRESHOLD.getMessageDefinition(new String[]{accessServiceFullName, Integer.toString(plateauThreshold)}));
            return plateauThreshold;
        }
        catch (Exception error) {
            this.logBadConfigProperties(accessServiceFullName, "KarmaPointPlateau", plateauThresholdObject.toString(), auditLog, "extractKarmaPointPlateau", error);
            return 0;
        }
    }

    private int useDefaultPlateauThreshold(String accessServiceFullName, AuditLog auditLog, String methodName) {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.DEFAULT_PLATEAU_THRESHOLD.getMessageDefinition(new String[]{accessServiceFullName, Integer.toString(500)}));
        return 500;
    }

    private void logBadConfigProperties(String accessServiceFullName, String propertyName, String propertyValue, AuditLog auditLog, String methodName, Throwable error) throws OMAGConfigurationErrorException {
        auditLog.logMessage(methodName, OMAGAdminAuditCode.BAD_CONFIG_PROPERTY.getMessageDefinition(new String[]{accessServiceFullName, propertyValue, propertyName}));
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_CONFIG_PROPERTIES.getMessageDefinition(new String[]{accessServiceFullName, propertyValue, propertyName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName, error);
    }

    protected void registerWithEnterpriseTopic(String accessServiceFullName, String serverName, OMRSTopicConnector omrsTopicConnector, OMRSTopicListener omrsTopicListener, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize OMAS";
        String methodName = "initialize";
        if (omrsTopicConnector == null) {
            auditLog.logMessage("initialize OMAS", OMAGAdminAuditCode.NO_ENTERPRISE_TOPIC.getMessageDefinition(new String[]{accessServiceFullName, serverName}));
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.NO_ENTERPRISE_TOPIC.getMessageDefinition(new String[]{accessServiceFullName, serverName}), this.getClass().getName(), "initialize");
        }
        auditLog.logMessage("initialize OMAS", OMAGAdminAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC.getMessageDefinition(new String[]{accessServiceFullName, serverName}));
        omrsTopicConnector.registerListener(omrsTopicListener, accessServiceFullName);
    }

    protected String getTopicName(Connection connection) {
        Endpoint topicEndpoint;
        String topicName = null;
        if (connection != null && (topicEndpoint = connection.getEndpoint()) != null) {
            topicName = topicEndpoint.getAddress();
        }
        return topicName;
    }

    protected OpenMetadataTopicConnector getInTopicEventBusConnector(Connection inTopicConnection, String accessServiceFullName, AuditLog parentAuditLog) throws OMAGConfigurationErrorException {
        String methodName = "getInTopicConnector";
        return this.getTopicConnector(inTopicConnection, parentAuditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_IN_TOPIC), accessServiceFullName, "getInTopicConnector");
    }

    protected OpenMetadataTopicConnector getOutTopicEventBusConnector(Connection outTopicEventBusConnection, String accessServiceName, AuditLog parentAuditLog) throws OMAGConfigurationErrorException {
        String methodName = "getOutTopicConnector";
        return this.getTopicConnector(outTopicEventBusConnection, parentAuditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC), accessServiceName, "getOutTopicConnector");
    }

    protected Connection getServerSideOutTopicConnection(Connection outTopicEventBusConnection, String accessServiceFullName, String accessServiceConnectorProviderClassName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "getOutTopicConnection";
        String connectionDescription = "OMRS default cohort topic connection.";
        String eventSource = "Server Event Bus";
        String connectionName = "OutTopicConnector." + accessServiceFullName;
        VirtualConnection connection = new VirtualConnection();
        ElementOrigin elementOrigin = new ElementOrigin();
        elementOrigin.setOriginCategory(ElementOriginCategory.CONFIGURATION);
        elementOrigin.setSourceServer("Server Event Bus");
        connection.setOrigin(elementOrigin);
        connection.setType(VirtualConnection.getVirtualConnectionType());
        connection.setGUID(UUID.randomUUID().toString());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("OMRS default cohort topic connection.");
        connection.setConnectorType(this.getConnectorType(accessServiceFullName, accessServiceConnectorProviderClassName, auditLog, "getOutTopicConnection"));
        HashMap<String, String> configurationProperties = outTopicEventBusConnection.getConfigurationProperties();
        if (configurationProperties == null) {
            configurationProperties = new HashMap<String, String>();
        }
        configurationProperties.put("eventDirection", "outOnly");
        outTopicEventBusConnection.setConfigurationProperties(configurationProperties);
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        embeddedConnection.setDisplayName("Server Event Bus");
        embeddedConnection.setArguments(null);
        embeddedConnection.setEmbeddedConnection(outTopicEventBusConnection);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        embeddedConnections.add(embeddedConnection);
        connection.setEmbeddedConnections(embeddedConnections);
        return connection;
    }

    private ConnectorType getConnectorType(String accessServiceFullName, String connectorProviderClassName, AuditLog auditLog, String methodName) throws OMAGConfigurationErrorException {
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null) {
            try {
                Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
                Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
                connectorType = connectorProvider.getConnectorType();
                if (connectorType == null) {
                    connectorType = new ConnectorType();
                    connectorType.setType(connectorType.getType());
                    connectorType.setGUID(UUID.randomUUID().toString());
                    connectorType.setQualifiedName(connectorProviderClassName);
                    connectorType.setDisplayName(connectorProviderClass.getSimpleName());
                    connectorType.setDescription("ConnectorType for " + connectorType.getDisplayName());
                    connectorType.setConnectorProviderClassName(connectorProviderClassName);
                }
            }
            catch (Exception error) {
                auditLog.logException(methodName, OMAGAdminAuditCode.BAD_TOPIC_CONNECTOR_PROVIDER.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_TOPIC_CONNECTOR_PROVIDER.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName);
            }
        }
        return connectorType;
    }

    protected void throwUnexpectedInitializationException(String actionDescription, String fullAccessServiceName, Throwable error) throws OMAGConfigurationErrorException {
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{fullAccessServiceName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), actionDescription, error);
    }

    public <T> T getTopicConnector(Connection topicConnection, Class<T> topicConnectorClass, AuditLog auditLog, String accessServiceFullName, String methodName) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker(auditLog);
            Connector connector = connectorBroker.getConnector(topicConnection);
            connector.start();
            return (T)connector;
        }
        catch (Exception error) {
            auditLog.logException(methodName, OMAGAdminAuditCode.BAD_TOPIC_CONNECTOR.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_TOPIC_CONNECTOR.getMessageDefinition(new String[]{methodName, accessServiceFullName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName);
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, AuditLog auditLog, String accessServiceFullName, String methodName) throws OMAGConfigurationErrorException {
        return this.getTopicConnector(topicConnection, OpenMetadataTopicConnector.class, auditLog, accessServiceFullName, methodName);
    }
}

