/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.samples;

import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.odpi.openmetadata.adminservices.client.MetadataServerConfigurationClient;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;

public class ConfigMetadataServerSample {
    private static final String defaultAdminPlatformURLRoot = "http://localhost:8080";
    private static final String defaultAdminUserId = "garygeeke";
    private static final String eventBusURLRoot = "localhost:9092";
    private static final String metadataServerName = "cocoMDS1";
    private static final String metadataServerPlatform = "http://localhost:8081";
    private static final String metadataServerUserId = "cocoMDS1npa";
    private static final String metadataServerPassword = "cocoMDS1passw0rd";
    private static final String metadataCollectionName = "Data Lake Catalog";
    private static final String organizationName = "Coco Pharmaceuticals";
    private static final String cohortName = "cocoCohort";
    private static final String topicRoot = "egeria";
    private static final int maxPageSize = 100;
    private static final String securityConnectorProvider = "org.odpi.openmetadata.metadatasecurity.samples.CocoPharmaServerSecurityProvider";
    private static final String[] supportedZones = new String[]{"quarantine", "clinical-trials", "research", "data-lake", "trash-can"};
    private static final String[] defaultZones = new String[]{"quarantine"};
    private MetadataServerConfigurationClient configurationClient;

    private ConfigMetadataServerSample(String adminPlatformURLRoot, String adminUserId) throws OMAGInvalidParameterException {
        System.out.println("=================================");
        System.out.println("Configure Metadata Server Sample ");
        System.out.println("=================================");
        System.out.println("Running against admin platform: " + adminPlatformURLRoot);
        System.out.println("Using admin userId: " + adminUserId);
        System.out.println("(No connection security)");
        System.out.println();
        System.out.println("Configuring server: cocoMDS1");
        this.configurationClient = new MetadataServerConfigurationClient(adminUserId, metadataServerName, adminPlatformURLRoot);
    }

    private ConfigMetadataServerSample(String adminPlatformURLRoot, String adminUserId, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        System.out.println("=================================");
        System.out.println("Configure Metadata Server Sample ");
        System.out.println("=================================");
        System.out.println("Running against admin platform: " + adminPlatformURLRoot);
        System.out.println("Using admin userId: " + adminUserId);
        System.out.println("Using connection userId: " + connectionUserId);
        System.out.println("Using connection password: " + connectionPassword);
        System.out.println();
        System.out.println("Configuring server: cocoMDS1");
        this.configurationClient = new MetadataServerConfigurationClient(adminUserId, metadataServerName, adminPlatformURLRoot, connectionUserId, connectionPassword);
    }

    private void run() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        this.configurationClient.setServerURLRoot(metadataServerPlatform);
        this.configurationClient.setMaxPageSize(100);
        this.configurationClient.setServerType(null);
        this.configurationClient.setOrganizationName(organizationName);
        this.configurationClient.setServerUserId(metadataServerUserId);
        this.configurationClient.setServerPassword(metadataServerPassword);
        Connection connection = new Connection();
        ConnectorType connectorType = new ConnectorType();
        connectorType.setConnectorProviderClassName(securityConnectorProvider);
        connection.setConnectorType(connectorType);
        this.configurationClient.setServerSecurityConnection(connection);
        HashMap configurationProperties = new HashMap();
        HashMap<String, String> kafkaProperties = new HashMap<String, String>();
        kafkaProperties.put("bootstrap.servers", eventBusURLRoot);
        configurationProperties.put("producer", kafkaProperties);
        configurationProperties.put("consumer", kafkaProperties);
        this.configurationClient.setEventBus(null, topicRoot, configurationProperties);
        this.configurationClient.setInMemLocalRepository();
        this.configurationClient.setLocalMetadataCollectionName(metadataCollectionName);
        this.configurationClient.addCohortRegistration(cohortName, null);
        HashMap<String, Object> accessServiceOptions = new HashMap<String, Object>();
        accessServiceOptions.put("SupportedZones", supportedZones);
        this.configurationClient.configureAccessService("asset-catalog", accessServiceOptions);
        this.configurationClient.configureAccessService("asset-consumer", accessServiceOptions);
        accessServiceOptions.put("DefaultZones", defaultZones);
        this.configurationClient.configureAccessService("asset-owner", accessServiceOptions);
        this.configurationClient.configureAccessService("glossary-view");
        this.configurationClient.configureAccessService("discovery-engine", accessServiceOptions);
        this.configurationClient.configureAccessService("stewardship-action", accessServiceOptions);
        this.configurationClient.configureAccessService("data-engine", accessServiceOptions);
        this.configurationClient.configureAccessService("data-platform", accessServiceOptions);
        this.configurationClient.configureAccessService("information-view", accessServiceOptions);
        accessServiceOptions = new HashMap();
        accessServiceOptions.put("KarmaPointPlateau", 500);
        this.configurationClient.configureAccessService("community-profile", accessServiceOptions);
        System.out.println();
        System.out.println("Configuration complete");
        System.out.println("  Local Metadata collection id: " + this.configurationClient.getLocalMetadataCollectionId());
        System.out.println("  Server classification:        " + this.configurationClient.getServerClassification().toString());
        System.out.println("  Cohort topic:                 " + this.configurationClient.getCohortTopicName(cohortName));
        System.out.println("  Access Service topics:        " + this.configurationClient.getAllAccessServiceTopicNames());
        System.out.println("  Full configuration:           " + this.configurationClient.getOMAGServerConfig().toString());
    }

    public static void main(String[] args) {
        BasicConfigurator.configure((Appender)new NullAppender());
        String serverURLRoot = defaultAdminPlatformURLRoot;
        String adminUserId = defaultAdminUserId;
        if (args.length > 0) {
            serverURLRoot = args[0];
        }
        if (args.length > 1) {
            adminUserId = args[1];
        }
        if (args.length > 3) {
            try {
                ConfigMetadataServerSample sample = new ConfigMetadataServerSample(serverURLRoot, adminUserId, args[2], args[3]);
                sample.run();
            }
            catch (Throwable error) {
                System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
                System.exit(-1);
            }
        } else {
            try {
                ConfigMetadataServerSample sample = new ConfigMetadataServerSample(serverURLRoot, adminUserId);
                sample.run();
            }
            catch (Throwable error) {
                System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
                System.exit(-1);
            }
        }
    }
}

