/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.adminservices.ffdc.OMAGErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGCheckedExceptionBase;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.properties.OMAGAPIResponse;
import org.odpi.openmetadata.adminservices.properties.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.properties.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.odpi.openmetadata.repositoryservices.admin.OMRSOperationalServices;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;

public class OMAGServerAdminServices {
    private static final String defaultInTopicName = "InTopic";
    private static final String defaultOutTopicName = "OutTopic";
    private OMRSOperationalServices operationalServices = null;
    private List<AccessServiceAdmin> accessServiceAdminList = new ArrayList<AccessServiceAdmin>();
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();

    public VoidResponse setServerURLRoot(String userId, String serverName, String url) {
        String methodName = "setServerURLRoot";
        VoidResponse response = new VoidResponse();
        try {
            this.validateUserId(userId, serverName, "setServerURLRoot");
            this.validateServerName(serverName, "setServerURLRoot");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setServerURLRoot");
            serverConfig.setLocalServerURL(url);
            this.configStore.saveServerConfig(serverName, "setServerURLRoot", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setServerType(String userId, String serverName, String typeName) {
        String methodName = "setServerType";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setServerType");
            this.validateUserId(userId, serverName, "setServerType");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setServerType");
            serverConfig.setLocalServerType(typeName);
            this.configStore.saveServerConfig(serverName, "setServerType", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setOrganizationName(String userId, String serverName, String name) {
        String methodName = "setOrganizationName";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setOrganizationName");
            this.validateUserId(userId, serverName, "setOrganizationName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setOrganizationName");
            serverConfig.setOrganizationName(name);
            this.configStore.saveServerConfig(serverName, "setOrganizationName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setServerUserId(String userId, String serverName, String serverUserId) {
        String methodName = "setServerUserId";
        VoidResponse response = new VoidResponse();
        try {
            this.validateUserId(userId, serverName, "setServerUserId");
            this.validateServerName(serverName, "setServerUserId");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setServerUserId");
            serverConfig.setLocalServerUserId(serverUserId);
            this.configStore.saveServerConfig(serverName, "setServerUserId", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setMaxPageSize(String userId, String serverName, int maxPageSize) {
        String methodName = "setMaxPageSize";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setMaxPageSize");
            this.validateUserId(userId, serverName, "setMaxPageSize");
            if (maxPageSize <= 0) {
                OMAGErrorCode errorCode = OMAGErrorCode.BAD_MAX_PAGE_SIZE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, Integer.toString(maxPageSize)});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setMaxPageSize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setMaxPageSize");
            serverConfig.setMaxPageSize(maxPageSize);
            this.configStore.saveServerConfig(serverName, "setMaxPageSize", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setEventBus(String userId, String serverName, String connectorProvider, String topicURLRoot, Map<String, Object> additionalProperties) {
        String methodName = "setEventBus";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setEventBus");
            this.validateUserId(userId, serverName, "setEventBus");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setEventBus");
            this.validateNewEventBusAllowed(serverName, serverConfig, "setEventBus");
            EventBusConfig eventBusConfig = new EventBusConfig();
            eventBusConfig.setConnectorProvider(connectorProvider);
            eventBusConfig.setTopicURLRoot(topicURLRoot);
            eventBusConfig.setAdditionalProperties(additionalProperties);
            serverConfig.setEventBusConfig(eventBusConfig);
            this.configStore.saveServerConfig(serverName, "setEventBus", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.captureConfigurationErrorException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse enableAccessServices(String userId, String serverName, Map<String, Object> accessServiceOptions) {
        String methodName = "enableAccessServices";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "enableAccessServices");
            this.validateUserId(userId, serverName, "enableAccessServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "enableAccessServices");
            EventBusConfig eventBusConfig = this.validateEventBusIsSet(serverName, serverConfig, "enableAccessServices");
            ArrayList<AccessServiceConfig> accessServiceConfigList = new ArrayList<AccessServiceConfig>();
            EnterpriseAccessConfig enterpriseAccessConfig = null;
            List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
            if (accessServiceRegistrationList != null && !accessServiceRegistrationList.isEmpty()) {
                for (AccessServiceRegistration registration : accessServiceRegistrationList) {
                    if (registration == null || registration.getAccessServiceOperationalStatus() != AccessServiceOperationalStatus.ENABLED) continue;
                    ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
                    AccessServiceConfig accessServiceConfig = new AccessServiceConfig(registration);
                    accessServiceConfig.setAccessServiceOptions(accessServiceOptions);
                    accessServiceConfig.setAccessServiceInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultInTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), registration.getAccessServiceInTopic(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties()));
                    accessServiceConfig.setAccessServiceOutTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultOutTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), registration.getAccessServiceOutTopic(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties()));
                    accessServiceConfigList.add(accessServiceConfig);
                }
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            if (accessServiceConfigList.isEmpty()) {
                accessServiceConfigList = null;
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.captureConfigurationErrorException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse disableAccessServices(String userId, String serverName) {
        String methodName = "disableAccessServices";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "disableAccessServices");
            this.validateUserId(userId, serverName, "disableAccessServices");
            this.setAccessServicesConfig(userId, serverName, null);
            this.setEnterpriseAccessConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setInMemLocalRepository(String userId, String serverName) {
        String methodName = "setInMemLocalRepository";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setInMemLocalRepository");
            this.validateUserId(userId, serverName, "setInMemLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setInMemLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getInMemoryLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL()));
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setGraphLocalRepository(String userId, String serverName, Map<String, Object> additionalProperties) {
        String methodName = "setGraphLocalRepository";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setGraphLocalRepository");
            this.validateUserId(userId, serverName, "setGraphLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setGraphLocalRepository");
            EventBusConfig eventBusConfig = this.validateEventBusIsSet(serverName, serverConfig, "setGraphLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getLocalGraphLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL(), additionalProperties, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties()));
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.captureConfigurationErrorException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setNoRepositoryMode(String userId, String serverName) {
        String methodName = "setNoRepositoryMode";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setNoRepositoryMode");
            this.validateUserId(userId, serverName, "setNoRepositoryMode");
            this.setLocalRepositoryConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, Connection connection) {
        String methodName = "setRepositoryProxyConnection";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setRepositoryProxyConnection");
            this.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setRepositoryProxyConnection");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            LocalRepositoryConfig localRepositoryConfig = configurationFactory.getRepositoryProxyLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL());
            localRepositoryConfig.setLocalRepositoryLocalConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, String connectorProvider, Map<String, Object> additionalProperties) {
        String methodName = "setRepositoryProxyConnection";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setRepositoryProxyConnection");
            this.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setRepositoryProxyConnection");
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.setRepositoryProxyConnection(userId, serverName, connectorConfigurationFactory.getRepositoryProxyConnection(serverName, connectorProvider, serverConfig.getLocalServerURL(), additionalProperties));
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setLocalRepositoryEventMapper(String userId, String serverName, Connection connection) {
        String methodName = "setLocalRepositoryEventMapper";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setLocalRepositoryEventMapper");
            this.validateUserId(userId, serverName, "setLocalRepositoryEventMapper");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setLocalRepositoryEventMapper");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                OMAGErrorCode errorCode = OMAGErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setLocalRepositoryEventMapper", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            localRepositoryConfig.setEventMapperConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.captureConfigurationErrorException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setLocalRepositoryEventMapper(String userId, String serverName, String connectorProvider, String eventSource, Map<String, Object> additionalProperties) {
        String methodName = "setLocalRepositoryEventMapper";
        VoidResponse response = new VoidResponse();
        try {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.validateServerName(serverName, "setLocalRepositoryEventMapper");
            this.validateUserId(userId, serverName, "setLocalRepositoryEventMapper");
            this.setLocalRepositoryEventMapper(userId, serverName, connectorConfigurationFactory.getRepositoryEventMapperConnection(serverName, connectorProvider, additionalProperties, eventSource));
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse enableCohortRegistration(String userId, String serverName, String cohortName, Map<String, Object> additionalProperties) {
        String methodName = "enableCohortRegistration";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "enableCohortRegistration");
            this.validateUserId(userId, serverName, "enableCohortRegistration");
            this.validateCohortName(cohortName, serverName, "enableCohortRegistration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "enableCohortRegistration");
            EventBusConfig eventBusConfig = this.validateEventBusIsSet(serverName, serverConfig, "enableCohortRegistration");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            CohortConfig newCohortConfig = configurationFactory.getDefaultCohortConfig(serverConfig.getLocalServerName(), cohortName, additionalProperties, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties());
            this.setCohortConfig(userId, serverName, cohortName, newCohortConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.captureConfigurationErrorException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse disableCohortRegistration(String userId, String serverName, String cohortName) {
        String methodName = "setCohortMode";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setCohortMode");
            this.validateUserId(userId, serverName, "setCohortMode");
            this.validateCohortName(cohortName, serverName, "setCohortMode");
            this.setCohortConfig(userId, serverName, cohortName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setAccessServicesConfig(String userId, String serverName, List<AccessServiceConfig> accessServicesConfig) {
        String methodName = "setAccessServicesConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setAccessServicesConfig");
            this.validateUserId(userId, serverName, "setAccessServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setAccessServicesConfig");
            serverConfig.setAccessServicesConfig(accessServicesConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServicesConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setLocalRepositoryConfig(String userId, String serverName, LocalRepositoryConfig localRepositoryConfig) {
        String methodName = "setLocalRepositoryConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setLocalRepositoryConfig");
            this.validateUserId(userId, serverName, "setLocalRepositoryConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setLocalRepositoryConfig");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            } else if (localRepositoryConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setLocalRepositoryConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setEnterpriseAccessConfig(String userId, String serverName, EnterpriseAccessConfig enterpriseAccessConfig) {
        String methodName = "setEnterpriseAccessConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setEnterpriseAccessConfig");
            this.validateUserId(userId, serverName, "setEnterpriseAccessConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setEnterpriseAccessConfig");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            } else if (enterpriseAccessConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setEnterpriseAccessConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse setCohortConfig(String userId, String serverName, String cohortName, CohortConfig cohortConfig) {
        String methodName = "setCohortConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "setCohortConfig");
            this.validateUserId(userId, serverName, "setCohortConfig");
            this.validateCohortName(cohortName, serverName, "setCohortConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setCohortConfig");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            List existingCohortConfigs = null;
            ArrayList<CohortConfig> newCohortConfigs = new ArrayList<CohortConfig>();
            if (repositoryServicesConfig != null) {
                existingCohortConfigs = repositoryServicesConfig.getCohortConfigList();
            }
            if (existingCohortConfigs != null) {
                for (CohortConfig existingCohort : existingCohortConfigs) {
                    String existingCohortName;
                    if (existingCohort == null || cohortName.equals(existingCohortName = existingCohort.getCohortName())) continue;
                    newCohortConfigs.add(existingCohort);
                }
            }
            if (cohortConfig != null) {
                newCohortConfigs.add(cohortConfig);
            }
            if (newCohortConfigs.isEmpty()) {
                newCohortConfigs = null;
            }
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            } else if (newCohortConfigs != null) {
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setCohortConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public OMAGServerConfigResponse getCurrentConfiguration(String userId, String serverName) {
        String methodName = "getCurrentConfiguration";
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            this.validateServerName(serverName, "getCurrentConfiguration");
            this.validateUserId(userId, serverName, "getCurrentConfiguration");
            response.setOMAGServerConfig(this.configStore.getServerConfig(serverName, "getCurrentConfiguration"));
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse activateWithStoredConfig(String userId, String serverName) {
        String methodName = "activateWithStoredConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "activateWithStoredConfig");
            this.validateUserId(userId, serverName, "activateWithStoredConfig");
            this.activateWithSuppliedConfig(userId, serverName, this.configStore.getServerConfig(serverName, "activateWithStoredConfig"));
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse activateWithSuppliedConfig(String userId, String serverName, OMAGServerConfig configuration) {
        VoidResponse response;
        block14: {
            String methodName = "activateWithSuppliedConfig";
            response = new VoidResponse();
            try {
                this.validateServerName(serverName, "activateWithSuppliedConfig");
                this.validateUserId(userId, serverName, "activateWithSuppliedConfig");
                if (configuration == null) {
                    OMAGErrorCode errorCode = OMAGErrorCode.NULL_SERVER_CONFIG;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                    throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                this.configStore.saveServerConfig(serverName, "activateWithSuppliedConfig", configuration);
                RepositoryServicesConfig repositoryServicesConfig = configuration.getRepositoryServicesConfig();
                if (repositoryServicesConfig == null) {
                    OMAGErrorCode errorCode = OMAGErrorCode.NULL_REPOSITORY_CONFIG;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                    throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                if (this.operationalServices != null) {
                    this.deactivateTemporarily(userId, serverName);
                }
                this.operationalServices = new OMRSOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
                this.operationalServices.initialize(repositoryServicesConfig);
                List accessServiceConfigList = configuration.getAccessServicesConfig();
                OMRSTopicConnector enterpriseTopicConnector = this.operationalServices.getEnterpriseOMRSTopicConnector();
                if (accessServiceConfigList != null) {
                    for (AccessServiceConfig accessServiceConfig : accessServiceConfigList) {
                        if (accessServiceConfig == null) continue;
                        String accessServiceAdminClassName = accessServiceConfig.getAccessServiceAdminClass();
                        if (accessServiceAdminClassName != null) {
                            try {
                                AccessServiceAdmin accessServiceAdmin = (AccessServiceAdmin)Class.forName(accessServiceAdminClassName).newInstance();
                                accessServiceAdmin.initialize(accessServiceConfig, enterpriseTopicConnector, this.operationalServices.getEnterpriseOMRSRepositoryConnector(accessServiceConfig.getAccessServiceName()), this.operationalServices.getAuditLog(accessServiceConfig.getAccessServiceId(), accessServiceConfig.getAccessServiceName(), accessServiceConfig.getAccessServiceDescription(), accessServiceConfig.getAccessServiceWiki()), configuration.getLocalServerUserId());
                                this.accessServiceAdminList.add(accessServiceAdmin);
                                continue;
                            }
                            catch (Throwable error) {
                                OMAGErrorCode errorCode = OMAGErrorCode.BAD_ACCESS_SERVICE_ADMIN_CLASS;
                                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, accessServiceAdminClassName, accessServiceConfig.getAccessServiceName()});
                                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                            }
                        }
                        OMAGErrorCode errorCode = OMAGErrorCode.NULL_ACCESS_SERVICE_ADMIN_CLASS;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, accessServiceConfig.getAccessServiceName()});
                        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    }
                }
                if (enterpriseTopicConnector == null) break block14;
                try {
                    enterpriseTopicConnector.start();
                }
                catch (Throwable error) {
                    OMAGErrorCode errorCode = OMAGErrorCode.ENTERPRISE_TOPIC_START_FAILED;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, error.getMessage()});
                    throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            }
            catch (OMAGInvalidParameterException error) {
                this.captureInvalidParameterException(response, error);
            }
            catch (OMAGConfigurationErrorException error) {
                this.captureConfigurationErrorException(response, error);
            }
            catch (OMAGNotAuthorizedException error) {
                this.captureNotAuthorizedException(response, error);
            }
        }
        return response;
    }

    public VoidResponse deactivateTemporarily(String userId, String serverName) {
        String methodName = "deactivateTemporarily";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "deactivateTemporarily");
            this.validateUserId(userId, serverName, "deactivateTemporarily");
            if (this.accessServiceAdminList != null) {
                for (AccessServiceAdmin accessServiceAdmin : this.accessServiceAdminList) {
                    if (accessServiceAdmin == null) continue;
                    accessServiceAdmin.shutdown();
                }
            }
            if (this.operationalServices != null) {
                this.operationalServices.disconnect(false);
                this.operationalServices = null;
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    public VoidResponse deactivatePermanently(String userId, String serverName) {
        String methodName = "deactivatePermanently";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "deactivatePermanently");
            this.validateUserId(userId, serverName, "deactivatePermanently");
            if (this.accessServiceAdminList != null) {
                for (AccessServiceAdmin accessServiceAdmin : this.accessServiceAdminList) {
                    if (accessServiceAdmin == null) continue;
                    accessServiceAdmin.shutdown();
                }
            }
            if (this.operationalServices != null) {
                this.operationalServices.disconnect(true);
                this.operationalServices = null;
            }
            this.configStore.saveServerConfig(serverName, "deactivatePermanently", null);
        }
        catch (OMAGInvalidParameterException error) {
            this.captureInvalidParameterException(response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.captureNotAuthorizedException(response, error);
        }
        return response;
    }

    private void validateUserId(String userId, String serverName, String methodName) throws OMAGNotAuthorizedException {
        if (userId == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_USER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateServerName(String serverName, String methodName) throws OMAGInvalidParameterException {
        if (serverName == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateNewEventBusAllowed(String serverName, OMAGServerConfig serverConfig, String methodName) throws OMAGConfigurationErrorException {
        List accessServiceConfigList = null;
        LocalRepositoryConfig localRepositoryConfig = null;
        List cohortConfigList = null;
        if (serverConfig != null) {
            accessServiceConfigList = serverConfig.getAccessServicesConfig();
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
                cohortConfigList = repositoryServicesConfig.getCohortConfigList();
                if (localRepositoryConfig != null && localRepositoryConfig.getEventMapperConnection() == null) {
                    localRepositoryConfig = null;
                }
            }
        }
        if (accessServiceConfigList != null || localRepositoryConfig != null || cohortConfigList != null) {
            OMAGErrorCode errorCode = OMAGErrorCode.TOO_LATE_TO_SET_EVENT_BUS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private EventBusConfig validateEventBusIsSet(String serverName, OMAGServerConfig serverConfig, String methodName) throws OMAGConfigurationErrorException {
        EventBusConfig eventBusConfig = null;
        if (serverConfig != null) {
            eventBusConfig = serverConfig.getEventBusConfig();
        }
        if (eventBusConfig == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NO_EVENT_BUS_SET;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return eventBusConfig;
    }

    private void validateCohortName(String cohortName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (cohortName == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_COHORT_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void captureConfigurationErrorException(OMAGAPIResponse response, OMAGConfigurationErrorException error) {
        this.captureCheckedException(response, (OMAGCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidParameterException(OMAGAPIResponse response, OMAGInvalidParameterException error) {
        this.captureCheckedException(response, (OMAGCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureNotAuthorizedException(OMAGAPIResponse response, OMAGNotAuthorizedException error) {
        this.captureCheckedException(response, (OMAGCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureCheckedException(OMAGAPIResponse response, OMAGCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }
}

