/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AdminServicesAPIResponse;
import org.odpi.openmetadata.adminservices.rest.VoidResponse;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;

public class OMAGServerAdminForAccessServices {
    private static final String defaultInTopicName = "InTopic";
    private static final String defaultOutTopicName = "OutTopic";
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();

    public VoidResponse enableAccessServices(String userId, String serverName, Map<String, Object> accessServiceOptions) {
        String methodName = "enableAccessServices";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "enableAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "enableAccessServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "enableAccessServices");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "enableAccessServices");
            ArrayList<AccessServiceConfig> accessServiceConfigList = new ArrayList<AccessServiceConfig>();
            EnterpriseAccessConfig enterpriseAccessConfig = null;
            List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
            if (accessServiceRegistrationList != null && !accessServiceRegistrationList.isEmpty()) {
                for (AccessServiceRegistration registration : accessServiceRegistrationList) {
                    if (registration == null || registration.getAccessServiceOperationalStatus() != AccessServiceOperationalStatus.ENABLED) continue;
                    ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
                    AccessServiceConfig accessServiceConfig = new AccessServiceConfig(registration);
                    accessServiceConfig.setAccessServiceOptions(accessServiceOptions);
                    accessServiceConfig.setAccessServiceInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultInTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, registration.getAccessServiceInTopic(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties()));
                    accessServiceConfig.setAccessServiceOutTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultOutTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, registration.getAccessServiceOutTopic(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties()));
                    accessServiceConfigList.add(accessServiceConfig);
                }
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            if (accessServiceConfigList.isEmpty()) {
                accessServiceConfigList = null;
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.errorHandler.captureConfigurationErrorException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse disableAccessServices(String userId, String serverName) {
        String methodName = "disableAccessServices";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "disableAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "disableAccessServices");
            this.setAccessServicesConfig(userId, serverName, null);
            this.setEnterpriseAccessConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setAccessServicesConfig(String userId, String serverName, List<AccessServiceConfig> accessServicesConfig) {
        String methodName = "setAccessServicesConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setAccessServicesConfig");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (accessServicesConfig == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for access services.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for access services.");
            }
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setAccessServicesConfig(accessServicesConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServicesConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setEnterpriseAccessConfig(String userId, String serverName, EnterpriseAccessConfig enterpriseAccessConfig) {
        String methodName = "setEnterpriseAccessConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEnterpriseAccessConfig");
            this.errorHandler.validateUserId(userId, serverName, "setEnterpriseAccessConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setEnterpriseAccessConfig");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (enterpriseAccessConfig == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for enterprise repository services (used by access services).");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for enterprise repository services (used by access services).");
            }
            serverConfig.setAuditTrail(configAuditLog);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            } else if (enterpriseAccessConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setEnterpriseAccessConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }
}

