/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AdminServicesAPIResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;

public class OMAGServerAdminServices {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();

    public VoidResponse setServerType(String userId, String serverName, String typeName) {
        String methodName = "setServerType";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setServerType");
            this.errorHandler.validateUserId(userId, serverName, "setServerType");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setServerType");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if ("".equals(typeName)) {
                typeName = null;
            }
            if (typeName == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for local server type name.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for local server type name to " + typeName + ".");
            }
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setLocalServerType(typeName);
            this.configStore.saveServerConfig(serverName, "setServerType", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setOrganizationName(String userId, String serverName, String name) {
        String methodName = "setOrganizationName";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOrganizationName");
            this.errorHandler.validateUserId(userId, serverName, "setOrganizationName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setOrganizationName");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if ("".equals(name)) {
                name = null;
            }
            if (name == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for local server's owning organization's name.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for local server's owning organization's name to " + name + ".");
            }
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setOrganizationName(name);
            this.configStore.saveServerConfig(serverName, "setOrganizationName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setServerUserId(String userId, String serverName, String serverUserId) {
        String methodName = "setServerUserId";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerUserId");
            this.errorHandler.validateServerName(serverName, "setServerUserId");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setServerUserId");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if ("".equals(serverUserId)) {
                serverUserId = null;
            }
            if (serverUserId == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for local server's userId.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for local server's userId to " + serverUserId + ".");
            }
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setLocalServerUserId(serverUserId);
            this.configStore.saveServerConfig(serverName, "setServerUserId", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setMaxPageSize(String userId, String serverName, int maxPageSize) {
        String methodName = "setMaxPageSize";
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<String> configAuditLog;
            OMAGServerConfig serverConfig;
            this.errorHandler.validateServerName(serverName, "setMaxPageSize");
            this.errorHandler.validateUserId(userId, serverName, "setMaxPageSize");
            if (maxPageSize > 0) {
                serverConfig = this.configStore.getServerConfig(serverName, "setMaxPageSize");
                configAuditLog = serverConfig.getAuditTrail();
                if (configAuditLog == null) {
                    configAuditLog = new ArrayList<String>();
                }
            } else {
                OMAGErrorCode errorCode = OMAGErrorCode.BAD_MAX_PAGE_SIZE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, Integer.toString(maxPageSize)});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setMaxPageSize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for maximum page size to " + Integer.toString(maxPageSize) + ".");
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setMaxPageSize(maxPageSize);
            this.configStore.saveServerConfig(serverName, "setMaxPageSize", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setEventBus(String userId, String serverName, String connectorProvider, String topicURLRoot, Map<String, Object> additionalProperties) {
        String methodName = "setEventBus";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEventBus");
            this.errorHandler.validateUserId(userId, serverName, "setEventBus");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setEventBus");
            EventBusConfig eventBusConfig = new EventBusConfig();
            eventBusConfig.setConnectorProvider(connectorProvider);
            eventBusConfig.setTopicURLRoot(topicURLRoot);
            eventBusConfig.setAdditionalProperties(additionalProperties);
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for default event bus.");
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setEventBusConfig(eventBusConfig);
            this.configStore.saveServerConfig(serverName, "setEventBus", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setServerURLRoot(String userId, String serverName, String url) {
        String methodName = "setServerURLRoot";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerURLRoot");
            this.errorHandler.validateServerName(serverName, "setServerURLRoot");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setServerURLRoot");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if ("".equals(url)) {
                url = null;
            }
            if (url == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for local server's URL root.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for local server's URL root to " + url + ".");
            }
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setLocalServerURL(url);
            this.configStore.saveServerConfig(serverName, "setServerURLRoot", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setDefaultAuditLog(String userId, String serverName) {
        String methodName = "setDefaultAuditLog";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setDefaultAuditLog");
            this.errorHandler.validateUserId(userId, serverName, "setDefaultAuditLog");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            ArrayList<Connection> auditLogConnections = new ArrayList<Connection>();
            auditLogConnections.add(configurationFactory.getDefaultAuditLogConnection(serverName));
            this.setAuditLogDestinations(userId, serverName, auditLogConnections);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse addStartUpOpenMetadataArchiveFile(String userId, String serverName, String fileName) {
        String methodName = "addStartUpOpenMetadataArchiveFile";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addStartUpOpenMetadataArchiveFile");
            this.errorHandler.validateUserId(userId, serverName, "addStartUpOpenMetadataArchiveFile");
            this.errorHandler.validateFileName(fileName, serverName, "addStartUpOpenMetadataArchiveFile");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            Connection newOpenMetadataArchive = configurationFactory.getOpenMetadataArchiveFileConnection(fileName);
            ArrayList<Connection> openMetadataArchiveConnections = null;
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "addStartUpOpenMetadataArchiveFile");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                openMetadataArchiveConnections = repositoryServicesConfig.getOpenMetadataArchiveConnections();
            }
            if (openMetadataArchiveConnections == null) {
                openMetadataArchiveConnections = new ArrayList<Connection>();
            }
            openMetadataArchiveConnections.add(newOpenMetadataArchive);
            this.setOpenMetadataArchives(userId, serverName, openMetadataArchiveConnections);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setInMemLocalRepository(String userId, String serverName) {
        String methodName = "setInMemLocalRepository";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setInMemLocalRepository");
            this.errorHandler.validateUserId(userId, serverName, "setInMemLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setInMemLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getInMemoryLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL()));
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setGraphLocalRepository(String userId, String serverName, Map<String, Object> additionalProperties) {
        String methodName = "setGraphLocalRepository";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setGraphLocalRepository");
            this.errorHandler.validateUserId(userId, serverName, "setGraphLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setGraphLocalRepository");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "setGraphLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getLocalGraphLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL(), additionalProperties, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties()));
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.errorHandler.captureConfigurationErrorException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setNoRepositoryMode(String userId, String serverName) {
        String methodName = "setNoRepositoryMode";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setNoRepositoryMode");
            this.errorHandler.validateUserId(userId, serverName, "setNoRepositoryMode");
            this.setLocalRepositoryConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, Connection connection) {
        String methodName = "setRepositoryProxyConnection";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyConnection");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setRepositoryProxyConnection");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            LocalRepositoryConfig localRepositoryConfig = configurationFactory.getRepositoryProxyLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL());
            localRepositoryConfig.setLocalRepositoryLocalConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, String connectorProvider, Map<String, Object> additionalProperties) {
        String methodName = "setRepositoryProxyConnection";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyConnection");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setRepositoryProxyConnection");
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.setRepositoryProxyConnection(userId, serverName, connectorConfigurationFactory.getRepositoryProxyConnection(serverName, connectorProvider, serverConfig.getLocalServerURL(), additionalProperties));
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setIBMIGCConnection(String userId, String serverName, Connection connection) {
        String methodName = "setIBMIGCConnection";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setIBMIGCConnection");
            this.errorHandler.validateUserId(userId, serverName, "setIBMIGCConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setIBMIGCConnection");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            LocalRepositoryConfig localRepositoryConfig = configurationFactory.getRepositoryIBMIGCRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL());
            localRepositoryConfig.setLocalRepositoryLocalConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setIBMIGCConnection(String userId, String serverName, Map<String, Object> additionalProperties) {
        String methodName = "setIBMIGCConnection";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setIBMIGCConnection");
            this.errorHandler.validateUserId(userId, serverName, "setIBMIGCConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setIBMIGCConnection");
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.setIBMIGCConnection(userId, serverName, connectorConfigurationFactory.getIBMIGCRepositoryConnection(serverName, serverConfig.getLocalServerURL(), additionalProperties));
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setLocalRepositoryEventMapper(String userId, String serverName, Connection connection) {
        String methodName = "setLocalRepositoryEventMapper";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryEventMapper");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryEventMapper");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setLocalRepositoryEventMapper");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                OMAGErrorCode errorCode = OMAGErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setLocalRepositoryEventMapper", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            localRepositoryConfig.setEventMapperConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.errorHandler.captureConfigurationErrorException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setLocalRepositoryEventMapper(String userId, String serverName, String connectorProvider, String eventSource, Map<String, Object> additionalProperties) {
        String methodName = "setLocalRepositoryEventMapper";
        VoidResponse response = new VoidResponse();
        try {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryEventMapper");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryEventMapper");
            this.setLocalRepositoryEventMapper(userId, serverName, connectorConfigurationFactory.getRepositoryEventMapperConnection(serverName, connectorProvider, additionalProperties, eventSource));
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setLocalMetadataCollectionName(String userId, String serverName, String localMetadataCollectionName) {
        String methodName = "setLocalMetadataCollectionName";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalMetadataCollectionName");
            this.errorHandler.validateUserId(userId, serverName, "setLocalMetadataCollectionName");
            this.errorHandler.validateMetadataCollectionName(localMetadataCollectionName, serverName, "setLocalMetadataCollectionName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setLocalMetadataCollectionName");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                OMAGErrorCode errorCode = OMAGErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setLocalMetadataCollectionName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            localRepositoryConfig.setMetadataCollectionName(localMetadataCollectionName);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.errorHandler.captureConfigurationErrorException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse enableCohortRegistration(String userId, String serverName, String cohortName, Map<String, Object> additionalProperties) {
        String methodName = "enableCohortRegistration";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "enableCohortRegistration");
            this.errorHandler.validateUserId(userId, serverName, "enableCohortRegistration");
            this.errorHandler.validateCohortName(cohortName, serverName, "enableCohortRegistration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "enableCohortRegistration");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "enableCohortRegistration");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            CohortConfig newCohortConfig = configurationFactory.getDefaultCohortConfig(serverConfig.getLocalServerName(), cohortName, additionalProperties, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties());
            this.setCohortConfig(userId, serverName, cohortName, newCohortConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.errorHandler.captureConfigurationErrorException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse disableCohortRegistration(String userId, String serverName, String cohortName) {
        String methodName = "setCohortMode";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setCohortMode");
            this.errorHandler.validateUserId(userId, serverName, "setCohortMode");
            this.errorHandler.validateCohortName(cohortName, serverName, "setCohortMode");
            this.setCohortConfig(userId, serverName, cohortName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setAuditLogDestinations(String userId, String serverName, List<Connection> auditLogDestinations) {
        String methodName = "setAuditLogDestinations";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAuditLogDestinations");
            this.errorHandler.validateUserId(userId, serverName, "setAuditLogDestinations");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setAuditLogDestinations");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (auditLogDestinations == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " setting up no audit log destinations.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated list of audit log destinations.");
            }
            serverConfig.setAuditTrail(configAuditLog);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
            } else if (auditLogDestinations != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setAuditLogDestinations", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setOpenMetadataArchives(String userId, String serverName, List<Connection> openMetadataArchives) {
        String methodName = "setOpenMetadataArchives";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOpenMetadataArchives");
            this.errorHandler.validateUserId(userId, serverName, "setOpenMetadataArchives");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setOpenMetadataArchives");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (openMetadataArchives == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " clearing open metadata archives.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated list of open metadata archives loaded at server start up.");
            }
            serverConfig.setAuditTrail(configAuditLog);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setOpenMetadataArchiveConnections(openMetadataArchives);
            } else if (openMetadataArchives != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setOpenMetadataArchiveConnections(openMetadataArchives);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setOpenMetadataArchives", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setLocalRepositoryConfig(String userId, String serverName, LocalRepositoryConfig localRepositoryConfig) {
        String methodName = "setLocalRepositoryConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryConfig");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setLocalRepositoryConfig");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (localRepositoryConfig == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " setting up a null local repository.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for the local repository.");
            }
            serverConfig.setAuditTrail(configAuditLog);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            } else if (localRepositoryConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setLocalRepositoryConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setCohortConfig(String userId, String serverName, String cohortName, CohortConfig cohortConfig) {
        String methodName = "setCohortConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setCohortConfig");
            this.errorHandler.validateUserId(userId, serverName, "setCohortConfig");
            this.errorHandler.validateCohortName(cohortName, serverName, "setCohortConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setCohortConfig");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            List existingCohortConfigs = null;
            ArrayList<CohortConfig> newCohortConfigs = new ArrayList<CohortConfig>();
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (cohortConfig == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for cohort " + cohortName + ".");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for cohort " + cohortName + ".");
            }
            serverConfig.setAuditTrail(configAuditLog);
            if (repositoryServicesConfig != null) {
                existingCohortConfigs = repositoryServicesConfig.getCohortConfigList();
            }
            if (existingCohortConfigs != null) {
                for (CohortConfig existingCohort : existingCohortConfigs) {
                    String existingCohortName;
                    if (existingCohort == null || cohortName.equals(existingCohortName = existingCohort.getCohortName())) continue;
                    newCohortConfigs.add(existingCohort);
                }
            }
            if (cohortConfig != null) {
                newCohortConfigs.add(cohortConfig);
            }
            if (newCohortConfigs.isEmpty()) {
                newCohortConfigs = null;
            }
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            } else if (newCohortConfigs != null) {
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setCohortConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setOMAGServerConfig(String userId, String serverName, OMAGServerConfig omagServerConfig) {
        String methodName = "setOMAGServerConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOMAGServerConfig");
            this.errorHandler.validateUserId(userId, serverName, "setOMAGServerConfig");
            if (omagServerConfig == null) {
                OMAGErrorCode errorCode = OMAGErrorCode.NULL_SERVER_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setOMAGServerConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setOMAGServerConfig");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            configAuditLog.add(new Date().toString() + " " + userId + " replaced configuration for server.");
            omagServerConfig.setAuditTrail(configAuditLog);
            this.configStore.saveServerConfig(serverName, "setOMAGServerConfig", omagServerConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public OMAGServerConfigResponse getStoredConfiguration(String userId, String serverName) {
        String methodName = "getStoredConfiguration";
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getStoredConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getStoredConfiguration");
            response.setOMAGServerConfig(this.configStore.getServerConfig(serverName, "getStoredConfiguration"));
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }
}

