/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.VoidResponse;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStore;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class OMAGServerAdminStoreServices {
    private static Connection configurationStoreConnection = null;

    public synchronized VoidResponse setConfigurationStoreConnection(String userId, Connection connection) {
        configurationStoreConnection = connection;
        return new VoidResponse();
    }

    public synchronized ConnectionResponse getConfigurationStoreConnection(String userId) {
        ConnectionResponse response = new ConnectionResponse();
        response.setConnection(configurationStoreConnection);
        return response;
    }

    public synchronized VoidResponse clearConfigurationStoreConnection(String userId) {
        configurationStoreConnection = null;
        return new VoidResponse();
    }

    private synchronized Connection getConnection(String serverName) {
        if (configurationStoreConnection == null) {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            return connectorConfigurationFactory.getServerConfigConnection(serverName);
        }
        return configurationStoreConnection;
    }

    private OMAGServerConfigStore getServerConfigStore(String serverName, String methodName) throws OMAGInvalidParameterException {
        Connection connection = this.getConnection(serverName);
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            return (OMAGServerConfigStore)connector;
        }
        catch (Throwable error) {
            OMAGErrorCode errorCode = OMAGErrorCode.BAD_CONFIG_FILE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, error.getMessage()});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    OMAGServerConfig getServerConfig(String serverName, String methodName) throws OMAGInvalidParameterException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        OMAGServerConfig serverConfig = null;
        if (serverConfigStore != null) {
            serverConfig = serverConfigStore.retrieveServerConfig();
        }
        if (serverConfig == null) {
            serverConfig = new OMAGServerConfig();
        }
        serverConfig.setLocalServerName(serverName);
        return serverConfig;
    }

    void saveServerConfig(String serverName, String methodName, OMAGServerConfig serverConfig) throws OMAGInvalidParameterException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        if (serverConfigStore != null) {
            if (serverConfig != null) {
                serverConfigStore.saveServerConfig(serverConfig);
            } else {
                serverConfigStore.removeServerConfig();
            }
        }
    }
}

