/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryEngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AdminServicesAPIResponse;
import org.odpi.openmetadata.adminservices.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class OMAGServerConfigDiscoveryEngine {
    static final String serviceName = "discovery engine services";
    static final String accessService = "Discovery Engine OMAS";
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();

    public VoidResponse setAccessServiceRootURL(String userId, String serverName, String accessServiceRootURL) {
        String methodName = "setAccessServiceRootURL";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServiceRootURL");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServiceRootURL");
            this.errorHandler.validateAccessServiceRootURL(accessServiceRootURL, accessService, serverName, serviceName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setAccessServiceRootURL");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if ("".equals(accessServiceRootURL)) {
                accessServiceRootURL = null;
            }
            if (accessServiceRootURL == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " access service root url.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " access service root url to " + accessServiceRootURL + ".");
            }
            serverConfig.setAuditTrail(configAuditLog);
            DiscoveryEngineConfig discoveryEngineConfig = serverConfig.getDiscoveryEngineConfig();
            if (discoveryEngineConfig == null) {
                discoveryEngineConfig = new DiscoveryEngineConfig();
            }
            discoveryEngineConfig.setAccessServiceRootURL(accessServiceRootURL);
            serverConfig.setDiscoveryEngineConfig(discoveryEngineConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServiceRootURL", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setAccessServiceServerName(String userId, String serverName, String accessServiceServerName) {
        String methodName = "setAccessServiceServerName";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServiceServerName");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServiceServerName");
            this.errorHandler.validateAccessServiceServerName(accessServiceServerName, accessService, serverName, serviceName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setAccessServiceServerName");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if ("".equals(accessServiceServerName)) {
                accessServiceServerName = null;
            }
            if (accessServiceServerName == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " access service server name.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " access service server name " + accessServiceServerName + ".");
            }
            serverConfig.setAuditTrail(configAuditLog);
            DiscoveryEngineConfig discoveryEngineConfig = serverConfig.getDiscoveryEngineConfig();
            if (discoveryEngineConfig == null) {
                discoveryEngineConfig = new DiscoveryEngineConfig();
            }
            discoveryEngineConfig.setAccessServiceRootURL(accessServiceServerName);
            serverConfig.setDiscoveryEngineConfig(discoveryEngineConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServiceServerName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse setInboundRequestConnection(String userId, String serverName, Connection connection) {
        String methodName = "setAccessServiceServerName";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServiceServerName");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServiceServerName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "setAccessServiceServerName");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (connection == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " inbound request connection.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " inbound request connection.");
            }
            serverConfig.setAuditTrail(configAuditLog);
            DiscoveryEngineConfig discoveryEngineConfig = serverConfig.getDiscoveryEngineConfig();
            if (discoveryEngineConfig == null) {
                discoveryEngineConfig = new DiscoveryEngineConfig();
            }
            discoveryEngineConfig.setInboundRequestConnection(connection);
            serverConfig.setDiscoveryEngineConfig(discoveryEngineConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServiceServerName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse deleteService(String userId, String serverName) {
        String methodName = "deleteService";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deleteService");
            this.errorHandler.validateUserId(userId, serverName, "deleteService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "deleteService");
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + ".");
            serverConfig.setAuditTrail(configAuditLog);
            serverConfig.setDiscoveryEngineConfig(null);
            this.configStore.saveServerConfig(serverName, "deleteService", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }
}

