/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGCheckedExceptionBase;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AdminServicesAPIResponse;

class OMAGServerErrorHandler {
    void validateUserId(String userId, String serverName, String methodName) throws OMAGNotAuthorizedException {
        if (userId == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_USER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateServerName(String serverName, String methodName) throws OMAGInvalidParameterException {
        if (serverName == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    EventBusConfig validateEventBusIsSet(String serverName, OMAGServerConfig serverConfig, String methodName) throws OMAGConfigurationErrorException {
        EventBusConfig eventBusConfig = null;
        if (serverConfig != null) {
            eventBusConfig = serverConfig.getEventBusConfig();
        }
        if (eventBusConfig == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NO_EVENT_BUS_SET;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return eventBusConfig;
    }

    void validateAccessServiceRootURL(String accessServiceRootURL, String accessServiceName, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (accessServiceRootURL == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_ACCESS_SERVICE_ROOT_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverService, serverName, accessServiceName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), serverService, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateAccessServiceServerName(String accessServiceServerName, String accessServiceName, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (accessServiceServerName == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_ACCESS_SERVICE_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverService, serverName, accessServiceName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), serverService, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateCohortName(String cohortName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (cohortName == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_COHORT_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateFileName(String fileName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (fileName == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_FILE_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateMetadataCollectionName(String name, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (name == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_METADATA_COLLECTION_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void captureConfigurationErrorException(AdminServicesAPIResponse response, OMAGConfigurationErrorException error) {
        this.captureCheckedException(response, (OMAGCheckedExceptionBase)error, error.getClass().getName());
    }

    void captureInvalidParameterException(AdminServicesAPIResponse response, OMAGInvalidParameterException error) {
        this.captureCheckedException(response, (OMAGCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    void captureNotAuthorizedException(AdminServicesAPIResponse response, OMAGNotAuthorizedException error) {
        this.captureCheckedException(response, (OMAGCheckedExceptionBase)error, error.getClass().getName());
    }

    private void captureCheckedException(AdminServicesAPIResponse response, OMAGCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }
}

