/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGOperationalServicesInstance;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerInstanceMap;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryEngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.StewardshipServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServersDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AdminServicesAPIResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.discoveryengine.admin.DiscoveryEngineOperationalServices;
import org.odpi.openmetadata.governanceservers.stewardshipservices.admin.StewardshipOperationalServices;
import org.odpi.openmetadata.repositoryservices.admin.OMRSOperationalServices;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.securitysyncservices.configuration.registration.SecuritySyncOperationalServices;

public class OMAGServerOperationalServices {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerInstanceMap instanceMap = new OMAGServerInstanceMap();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();

    public VoidResponse activateWithStoredConfig(String userId, String serverName) {
        String methodName = "activateWithStoredConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "activateWithStoredConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithStoredConfig");
            response = this.activateWithSuppliedConfig(userId, serverName, this.configStore.getServerConfig(serverName, "activateWithStoredConfig"));
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse activateWithSuppliedConfig(String userId, String serverName, OMAGServerConfig configuration) {
        String methodName = "activateWithSuppliedConfig";
        String REPOSITORY_SERVICES = "Repository Services";
        ArrayList<String> activatedServiceList = new ArrayList<String>();
        VoidResponse response = new VoidResponse();
        try {
            OMAGOperationalServicesInstance instance = this.validateServerName(serverName, "activateWithSuppliedConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithSuppliedConfig");
            if (configuration == null) {
                OMAGErrorCode errorCode = OMAGErrorCode.NULL_SERVER_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.validateConfigServerName(serverName, configuration.getLocalServerName(), "activateWithSuppliedConfig");
            this.configStore.saveServerConfig(serverName, "activateWithSuppliedConfig", configuration);
            instance.setOperationalConfiguration(configuration);
            this.deactivateRunningServiceInstances(instance, false);
            RepositoryServicesConfig repositoryServicesConfig = configuration.getRepositoryServicesConfig();
            List accessServiceConfigList = configuration.getAccessServicesConfig();
            DiscoveryEngineConfig discoveryEngineConfig = configuration.getDiscoveryEngineConfig();
            SecuritySyncConfig securitySyncConfig = configuration.getSecuritySyncConfig();
            StewardshipServicesConfig stewardshipServicesConfig = configuration.getStewardshipServicesConfig();
            if (repositoryServicesConfig == null && accessServiceConfigList == null && discoveryEngineConfig == null && securitySyncConfig == null && stewardshipServicesConfig == null) {
                OMAGErrorCode errorCode = OMAGErrorCode.EMPTY_CONFIGURATION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (repositoryServicesConfig == null) {
                OMAGErrorCode errorCode = OMAGErrorCode.NULL_REPOSITORY_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            OMRSOperationalServices operationalRepositoryServices = new OMRSOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
            activatedServiceList.add("Repository Services");
            instance.setOperationalRepositoryServices(operationalRepositoryServices);
            operationalRepositoryServices.initialize(repositoryServicesConfig);
            OMRSTopicConnector enterpriseTopicConnector = operationalRepositoryServices.getEnterpriseOMRSTopicConnector();
            List<AccessServiceAdmin> operationalAccessServiceAdminList = instance.getOperationalAccessServiceAdminList();
            if (accessServiceConfigList != null) {
                for (AccessServiceConfig accessServiceConfig : accessServiceConfigList) {
                    if (accessServiceConfig == null) continue;
                    String accessServiceAdminClassName = accessServiceConfig.getAccessServiceAdminClass();
                    if (accessServiceAdminClassName != null) {
                        try {
                            AccessServiceAdmin accessServiceAdmin = (AccessServiceAdmin)Class.forName(accessServiceAdminClassName).newInstance();
                            accessServiceAdmin.initialize(accessServiceConfig, enterpriseTopicConnector, operationalRepositoryServices.getEnterpriseOMRSRepositoryConnector(accessServiceConfig.getAccessServiceName()), operationalRepositoryServices.getAuditLog(accessServiceConfig.getAccessServiceId(), accessServiceConfig.getAccessServiceName(), accessServiceConfig.getAccessServiceDescription(), accessServiceConfig.getAccessServiceWiki()), configuration.getLocalServerUserId());
                            operationalAccessServiceAdminList.add(accessServiceAdmin);
                            activatedServiceList.add(accessServiceConfig.getAccessServiceName() + " OMAS");
                            continue;
                        }
                        catch (Throwable error) {
                            OMAGErrorCode errorCode = OMAGErrorCode.BAD_ACCESS_SERVICE_ADMIN_CLASS;
                            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, accessServiceAdminClassName, accessServiceConfig.getAccessServiceName()});
                            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                        }
                    }
                    OMAGErrorCode errorCode = OMAGErrorCode.NULL_ACCESS_SERVICE_ADMIN_CLASS;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, accessServiceConfig.getAccessServiceName()});
                    throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            }
            instance.setOperationalAccessServiceAdminList(operationalAccessServiceAdminList);
            this.instanceMap.setNewInstance(serverName, instance);
            if (enterpriseTopicConnector != null) {
                try {
                    enterpriseTopicConnector.start();
                }
                catch (Throwable error) {
                    OMAGErrorCode errorCode = OMAGErrorCode.ENTERPRISE_TOPIC_START_FAILED;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, error.getMessage()});
                    throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            }
            if (discoveryEngineConfig != null) {
                DiscoveryEngineOperationalServices operationalDiscoveryEngine = new DiscoveryEngineOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                instance.setOperationalDiscoveryEngine(operationalDiscoveryEngine);
                operationalDiscoveryEngine.initialize(discoveryEngineConfig, operationalRepositoryServices.getAuditLog(GovernanceServersDescription.DISCOVERY_ENGINE_SERVICES.getServiceCode(), GovernanceServersDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), GovernanceServersDescription.DISCOVERY_ENGINE_SERVICES.getServiceDescription(), GovernanceServersDescription.DISCOVERY_ENGINE_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServersDescription.DISCOVERY_ENGINE_SERVICES.getServiceName());
            }
            if (securitySyncConfig != null) {
                SecuritySyncOperationalServices operationalSecuritySync = new SecuritySyncOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
                instance.setOperationalSecuritySyncServices(operationalSecuritySync);
                operationalSecuritySync.initialize(securitySyncConfig, operationalRepositoryServices.getAuditLog(GovernanceServersDescription.SECURITY_SYNC_SERVICES.getServiceCode(), GovernanceServersDescription.SECURITY_SYNC_SERVICES.getServiceName(), GovernanceServersDescription.SECURITY_SYNC_SERVICES.getServiceDescription(), GovernanceServersDescription.SECURITY_SYNC_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServersDescription.SECURITY_SYNC_SERVICES.getServiceName());
            }
            if (stewardshipServicesConfig != null) {
                StewardshipOperationalServices operationalStewardshipServices = new StewardshipOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                instance.setOperationalStewardshipServices(operationalStewardshipServices);
                operationalStewardshipServices.initialize(stewardshipServicesConfig, operationalRepositoryServices.getAuditLog(GovernanceServersDescription.STEWARDSHIP_SERVICES.getServiceCode(), GovernanceServersDescription.STEWARDSHIP_SERVICES.getServiceName(), GovernanceServersDescription.STEWARDSHIP_SERVICES.getServiceDescription(), GovernanceServersDescription.STEWARDSHIP_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServersDescription.STEWARDSHIP_SERVICES.getServiceName());
            }
            response.setSuccessMessage(new Date().toString() + " " + serverName + " is running the following services: " + ((Object)activatedServiceList).toString());
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.errorHandler.captureConfigurationErrorException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    private void deactivateRunningServiceInstances(OMAGOperationalServicesInstance instance, boolean permanentDeactivation) {
        if (instance.getOperationalAccessServiceAdminList() != null) {
            for (AccessServiceAdmin accessServiceAdmin : instance.getOperationalAccessServiceAdminList()) {
                if (accessServiceAdmin == null) continue;
                accessServiceAdmin.shutdown();
            }
        }
        if (instance.getOperationalDiscoveryEngine() != null) {
            instance.getOperationalDiscoveryEngine().terminate(permanentDeactivation);
        }
        if (instance.getOperationalSecuritySyncServices() != null) {
            instance.getOperationalSecuritySyncServices().disconnect(permanentDeactivation);
        }
        if (instance.getOperationalStewardshipServices() != null) {
            instance.getOperationalStewardshipServices().terminate(permanentDeactivation);
        }
        if (instance.getOperationalRepositoryServices() != null) {
            instance.getOperationalRepositoryServices().disconnect(permanentDeactivation);
        }
    }

    public VoidResponse deactivateTemporarily(String userId, String serverName) {
        String methodName = "deactivateTemporarily";
        VoidResponse response = new VoidResponse();
        try {
            OMAGOperationalServicesInstance instance = this.validateServerName(serverName, "deactivateTemporarily");
            this.errorHandler.validateUserId(userId, serverName, "deactivateTemporarily");
            this.deactivateRunningServiceInstances(instance, false);
            this.instanceMap.removeInstance(serverName);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse deactivatePermanently(String userId, String serverName) {
        String methodName = "deactivatePermanently";
        VoidResponse response = new VoidResponse();
        try {
            this.validateServerName(serverName, "deactivatePermanently");
            this.errorHandler.validateUserId(userId, serverName, "deactivatePermanently");
            OMAGOperationalServicesInstance instance = this.validateServerName(serverName, "deactivatePermanently");
            this.errorHandler.validateUserId(userId, serverName, "deactivatePermanently");
            this.deactivateRunningServiceInstances(instance, true);
            this.instanceMap.removeInstance(serverName);
            this.configStore.saveServerConfig(serverName, "deactivatePermanently", null);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public OMAGServerConfigResponse getActiveConfiguration(String userId, String serverName) {
        String methodName = "getActiveConfiguration";
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            OMAGOperationalServicesInstance instance = this.validateServerName(serverName, "getActiveConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getActiveConfiguration");
            response.setOMAGServerConfig(instance.getOperationalConfiguration());
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse addOpenMetadataArchiveFile(String userId, String serverName, String fileName) {
        String methodName = "addOpenMetadataArchiveFile";
        VoidResponse response = new VoidResponse();
        try {
            OMAGOperationalServicesInstance instance = this.validateServerName(serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateUserId(userId, serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateFileName(fileName, serverName, "addOpenMetadataArchiveFile");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            Connection newOpenMetadataArchive = configurationFactory.getOpenMetadataArchiveFileConnection(fileName);
            OMRSOperationalServices repositoryServicesInstance = instance.getOperationalRepositoryServices();
            repositoryServicesInstance.addOpenMetadataArchive(newOpenMetadataArchive);
        }
        catch (OMAGInvalidParameterException error) {
            this.errorHandler.captureInvalidParameterException((AdminServicesAPIResponse)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.errorHandler.captureNotAuthorizedException((AdminServicesAPIResponse)response, error);
        }
        return response;
    }

    private OMAGOperationalServicesInstance validateServerName(String serverName, String methodName) throws OMAGInvalidParameterException {
        if (serverName == null) {
            OMAGErrorCode errorCode = OMAGErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        OMAGOperationalServicesInstance instance = this.instanceMap.getInstance(serverName);
        if (instance == null) {
            instance = new OMAGOperationalServicesInstance();
        }
        return instance;
    }

    private void validateConfigServerName(String serverName, String configServerName, String methodName) throws OMAGConfigurationErrorException {
        if (!serverName.equals(configServerName)) {
            OMAGErrorCode errorCode = OMAGErrorCode.INCOMPATIBLE_SERVER_NAMES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, configServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

