/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.rest.VoidResponse;

public class OMAGServerSecuritySyncService {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private static final String defaultOutTopicName = "OutTopic";
    private static final String defaultInTopicName = "open-metadata.access-services.GovernanceEngine.outTopic";
    private static final String outputTopic = "open-metadata.security-sync.";
    private static final String defaultOutTopic = ".outTopic";

    public VoidResponse setSecuritySyncConfig(String userId, String serverName, SecuritySyncConfig securitySyncConfig) {
        String methodName = "setSecuritySyncConfig";
        VoidResponse response = new VoidResponse();
        try {
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, methodName);
            ArrayList<String> configAuditLog = serverConfig.getAuditTrail();
            if (configAuditLog == null) {
                configAuditLog = new ArrayList<String>();
            }
            if (securitySyncConfig == null) {
                configAuditLog.add(new Date().toString() + " " + userId + " removed configuration for security sync services.");
            } else {
                configAuditLog.add(new Date().toString() + " " + userId + " updated configuration for security sync services.");
            }
            serverConfig.setAuditTrail(configAuditLog);
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            EventBusConfig eventBusConfig = serverConfig.getEventBusConfig();
            securitySyncConfig.setSecuritySyncInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultInTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, securitySyncConfig.getSecuritySyncInTopicName(), UUID.randomUUID().toString(), eventBusConfig.getAdditionalProperties()));
            securitySyncConfig.setSecuritySyncOutTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultOutTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, this.getOutputTopicName(securitySyncConfig.getSecurityServerType()), serverConfig.getLocalServerId(), eventBusConfig.getAdditionalProperties()));
            serverConfig.setSecuritySyncConfig(securitySyncConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException oMAGInvalidParameterException) {
            // empty catch block
        }
        return response;
    }

    private String getOutputTopicName(String securityServerType) {
        return outputTopic + securityServerType + defaultOutTopic;
    }

    public VoidResponse enableSecuritySyncService(String userId, String serverName) {
        String methodName = "enableSecuritySyncService";
        VoidResponse response = new VoidResponse();
        try {
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(serverName, "enableSecuritySyncService");
            SecuritySyncConfig securitySyncConfig = serverConfig.getSecuritySyncConfig();
            this.setSecuritySyncConfig(userId, serverName, securitySyncConfig);
        }
        catch (OMAGInvalidParameterException e) {
            e.printStackTrace();
        }
        return response;
    }
}

