/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.ConformanceSuiteConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.PlatformConformanceWorkbenchConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryConformanceWorkbenchConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGConformanceSuiteConfigServices {
    private static final String serviceName = "Open Metadata Conformance Suite";
    private static final int maxPageSize = 50;
    private static final Logger log = LoggerFactory.getLogger(OMAGConformanceSuiteConfigServices.class);
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse enableRepositoryConformanceSuiteWorkbench(String userId, String serverName, RepositoryConformanceWorkbenchConfig repositoryConformanceWorkbenchConfig) {
        String methodName = "enableRepositoryConformanceSuiteWorkbench";
        log.debug("Calling method: enableRepositoryConformanceSuiteWorkbench");
        VoidResponse response = this.enableAllConformanceSuiteWorkbenches(userId, serverName, repositoryConformanceWorkbenchConfig, null);
        log.debug("Returning from method: enableRepositoryConformanceSuiteWorkbench with response: " + response.toString());
        return response;
    }

    public VoidResponse enablePlatformConformanceSuiteWorkbench(String userId, String serverName, URLRequestBody requestBody) {
        String methodName = "enablePlatformConformanceSuiteWorkbench";
        log.debug("Calling method: enablePlatformConformanceSuiteWorkbench");
        VoidResponse response = this.enableAllConformanceSuiteWorkbenches(userId, serverName, null, requestBody.getUrlRoot());
        log.debug("Returning from method: enablePlatformConformanceSuiteWorkbench with response: " + response.toString());
        return response;
    }

    private VoidResponse enableAllConformanceSuiteWorkbenches(String userId, String serverName, RepositoryConformanceWorkbenchConfig repositoryConformanceWorkbenchConfig, String tutPlatformRootURL) {
        String methodName = "enableAllConformanceSuiteWorkbenches";
        log.debug("Calling method: enableAllConformanceSuiteWorkbenches");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "enableAllConformanceSuiteWorkbenches");
            this.errorHandler.validateUserId(userId, serverName, "enableAllConformanceSuiteWorkbenches");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableAllConformanceSuiteWorkbenches");
            ConformanceSuiteConfig conformanceSuiteConfig = serverConfig.getConformanceSuiteConfig();
            List<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " begins adding configuration for " + serviceName + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "enableAllConformanceSuiteWorkbenches", serverConfig);
            if (conformanceSuiteConfig == null) {
                conformanceSuiteConfig = new ConformanceSuiteConfig();
            }
            if (conformanceSuiteConfig.getPlatformWorkbenchConfig() == null && conformanceSuiteConfig.getRepositoryWorkbenchConfig() == null) {
                OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();
                adminAPI.setMaxPageSize(userId, serverName, 50);
                adminAPI.setServerType(userId, serverName, serviceName);
                adminAPI.setInMemLocalRepository(userId, serverName);
                serverConfig = this.configStore.getServerConfig(userId, serverName, "enableAllConformanceSuiteWorkbenches");
                RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                EnterpriseAccessConfig enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
                serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
                this.configStore.saveServerConfig(serverName, "enableAllConformanceSuiteWorkbenches", serverConfig);
            }
            serverConfig = this.configStore.getServerConfig(userId, serverName, "enableAllConformanceSuiteWorkbenches");
            configAuditTrail = serverConfig.getAuditTrail();
            if (repositoryConformanceWorkbenchConfig != null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " enable repository workbench to test " + repositoryConformanceWorkbenchConfig.getTutRepositoryServerName() + ".");
                conformanceSuiteConfig.setRepositoryWorkbenchConfig(repositoryConformanceWorkbenchConfig);
            }
            if (tutPlatformRootURL != null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " enable platform workbench to test " + tutPlatformRootURL + ".");
                PlatformConformanceWorkbenchConfig platformWorkbenchConfig = new PlatformConformanceWorkbenchConfig();
                platformWorkbenchConfig.setTutPlatformURLRoot(tutPlatformRootURL);
                conformanceSuiteConfig.setPlatformWorkbenchConfig(platformWorkbenchConfig);
            }
            serverConfig.setConformanceSuiteConfig(conformanceSuiteConfig);
            configAuditTrail.add(new Date().toString() + " " + userId + " finished adding configuration for " + serviceName + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "enableAllConformanceSuiteWorkbenches", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "enableAllConformanceSuiteWorkbenches", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: enableAllConformanceSuiteWorkbenches with response: " + response.toString());
        return response;
    }

    public VoidResponse disableRepositoryConformanceSuiteServices(String userId, String serverName) {
        String methodName = "disableRepositoryConformanceSuiteServices";
        log.debug("Calling method: disableRepositoryConformanceSuiteServices");
        VoidResponse response = new VoidResponse();
        try {
            RepositoryConformanceWorkbenchConfig repositoryConformanceWorkbenchConfig;
            this.errorHandler.validateServerName(serverName, "disableRepositoryConformanceSuiteServices");
            this.errorHandler.validateUserId(userId, serverName, "disableRepositoryConformanceSuiteServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "disableRepositoryConformanceSuiteServices");
            ConformanceSuiteConfig conformanceSuiteConfig = serverConfig.getConformanceSuiteConfig();
            if (conformanceSuiteConfig != null && (repositoryConformanceWorkbenchConfig = conformanceSuiteConfig.getRepositoryWorkbenchConfig()) != null) {
                ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<String>();
                }
                configAuditTrail.add(new Date().toString() + " " + userId + " removed repository workbench configuration for " + serviceName + ".");
                serverConfig.setAuditTrail(configAuditTrail);
                conformanceSuiteConfig.setRepositoryWorkbenchConfig(null);
                serverConfig.setConformanceSuiteConfig(conformanceSuiteConfig);
                this.configStore.saveServerConfig(serverName, "disableRepositoryConformanceSuiteServices", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "disableRepositoryConformanceSuiteServices", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: disableRepositoryConformanceSuiteServices with response: " + response.toString());
        return response;
    }

    public VoidResponse disablePlatformConformanceSuiteServices(String userId, String serverName) {
        String methodName = "disablePlatformConformanceSuiteServices";
        log.debug("Calling method: disablePlatformConformanceSuiteServices");
        VoidResponse response = new VoidResponse();
        try {
            PlatformConformanceWorkbenchConfig platformConformanceWorkbenchConfig;
            this.errorHandler.validateServerName(serverName, "disablePlatformConformanceSuiteServices");
            this.errorHandler.validateUserId(userId, serverName, "disablePlatformConformanceSuiteServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "disablePlatformConformanceSuiteServices");
            ConformanceSuiteConfig conformanceSuiteConfig = serverConfig.getConformanceSuiteConfig();
            if (conformanceSuiteConfig != null && (platformConformanceWorkbenchConfig = conformanceSuiteConfig.getPlatformWorkbenchConfig()) != null) {
                ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<String>();
                }
                configAuditTrail.add(new Date().toString() + " " + userId + " removed platform workbench configuration for " + serviceName + ".");
                serverConfig.setAuditTrail(configAuditTrail);
                conformanceSuiteConfig.setPlatformWorkbenchConfig(null);
                serverConfig.setConformanceSuiteConfig(conformanceSuiteConfig);
                this.configStore.saveServerConfig(serverName, "disablePlatformConformanceSuiteServices", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "disablePlatformConformanceSuiteServices", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: disablePlatformConformanceSuiteServices with response: " + response.toString());
        return response;
    }

    public VoidResponse disableAllConformanceSuiteWorkbenches(String userId, String serverName) {
        String methodName = "disableAllConformanceSuiteWorkbenches";
        log.debug("Calling method: disableAllConformanceSuiteWorkbenches");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "disableAllConformanceSuiteWorkbenches");
            this.errorHandler.validateUserId(userId, serverName, "disableAllConformanceSuiteWorkbenches");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "disableAllConformanceSuiteWorkbenches");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setConformanceSuiteConfig(null);
            serverConfig.setRepositoryServicesConfig(null);
            serverConfig.setLocalServerType(null);
            this.configStore.saveServerConfig(serverName, "disableAllConformanceSuiteWorkbenches", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "disableAllConformanceSuiteWorkbenches", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: disableAllConformanceSuiteWorkbenches with response: " + response.toString());
        return response;
    }
}

