/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

public class OMAGServerAdminForOpenLineage {
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private static final String defaultALOutTopicName = "omas.open-metadata.access-services.AssetLineage.outTopic";
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse enableOpenLineageService(String userId, String serverName) {
        String methodName = "enableOpenLineageService";
        VoidResponse response = new VoidResponse();
        try {
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableOpenLineageService");
            OpenLineageConfig openLineageConfig = serverConfig.getOpenLineageConfig();
            this.setOpenLineageConfig(userId, serverName, openLineageConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "enableOpenLineageService", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse setOpenLineageConfig(String userId, String serverName, OpenLineageConfig openLineageConfig) {
        String methodName = "setOpenLineageConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            openLineageConfig.setOpenLineageBufferGraphConnection(connectorConfigurationFactory.getOpenLineageServerConfiguration(serverName, openLineageConfig.getOpenLineageProviderBuffer(), serverConfig.getLocalServerURL(), openLineageConfig.getBufferGraphConfig()));
            openLineageConfig.setOpenLineageMainGraphConnection(connectorConfigurationFactory.getOpenLineageServerConfiguration(serverName, openLineageConfig.getOpenLineageProviderMain(), serverConfig.getLocalServerURL(), openLineageConfig.getMainGraphConfig()));
            EventBusConfig eventBusConfig = serverConfig.getEventBusConfig();
            openLineageConfig.setInTopicConnection(connectorConfigurationFactory.getDefaultEventBusConnection(defaultALOutTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server", openLineageConfig.getInTopicName(), UUID.randomUUID().toString(), eventBusConfig.getConfigurationProperties()));
            serverConfig.setOpenLineageConfig(openLineageConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (openLineageConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for open lineage services.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for open lineage services.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }
}

