/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

public class OMAGServerConfigDiscoveryServer {
    private static final String serviceName = GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName();
    private static final String accessService = AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceName();
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setAccessServiceRootURL(String userId, String serverName, String accessServiceRootURL) {
        String methodName = "setAccessServiceRootURL";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServiceRootURL");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServiceRootURL");
            this.errorHandler.validateAccessServiceRootURL(accessServiceRootURL, accessService, serverName, serviceName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAccessServiceRootURL");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(accessServiceRootURL)) {
                accessServiceRootURL = null;
            }
            if (accessServiceRootURL == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " access service root url.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " access service root url to " + accessServiceRootURL + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            DiscoveryServerConfig discoveryServerConfig = serverConfig.getDiscoveryServerConfig();
            if (discoveryServerConfig == null) {
                discoveryServerConfig = new DiscoveryServerConfig();
            }
            discoveryServerConfig.setAccessServiceRootURL(accessServiceRootURL);
            serverConfig.setDiscoveryServerConfig(discoveryServerConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServiceRootURL", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setAccessServiceRootURL", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse setAccessServiceServerName(String userId, String serverName, String accessServiceServerName) {
        String methodName = "setAccessServiceServerName";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServiceServerName");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServiceServerName");
            this.errorHandler.validateAccessServiceServerName(accessServiceServerName, accessService, serverName, serviceName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAccessServiceServerName");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(accessServiceServerName)) {
                accessServiceServerName = null;
            }
            if (accessServiceServerName == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " access service server name.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " access service server name " + accessServiceServerName + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            DiscoveryServerConfig discoveryServerConfig = serverConfig.getDiscoveryServerConfig();
            if (discoveryServerConfig == null) {
                discoveryServerConfig = new DiscoveryServerConfig();
            }
            discoveryServerConfig.setAccessServiceRootURL(accessServiceServerName);
            serverConfig.setDiscoveryServerConfig(discoveryServerConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServiceServerName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setAccessServiceServerName", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse setDiscoveryEngines(String userId, String serverName, List<String> discoveryEngineGUIDs) {
        String methodName = "setAccessServiceServerName";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServiceServerName");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServiceServerName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAccessServiceServerName");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (discoveryEngineGUIDs == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " inbound request discoveryEngineGUIDs.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " inbound request discoveryEngineGUIDs.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            DiscoveryServerConfig discoveryServerConfig = serverConfig.getDiscoveryServerConfig();
            if (discoveryServerConfig == null) {
                discoveryServerConfig = new DiscoveryServerConfig();
            }
            discoveryServerConfig.setDiscoveryEngineGUIDs(discoveryEngineGUIDs);
            serverConfig.setDiscoveryServerConfig(discoveryServerConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServiceServerName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setAccessServiceServerName", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse deleteService(String userId, String serverName) {
        String methodName = "deleteService";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deleteService");
            this.errorHandler.validateUserId(userId, serverName, "deleteService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "deleteService");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setDiscoveryServerConfig(null);
            this.configStore.saveServerConfig(serverName, "deleteService", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "deleteService", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

