/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

class OMAGServerErrorHandler {
    void validateUserId(String userId, String serverName, String methodName) throws OMAGNotAuthorizedException {
        if (userId == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_USER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateServerName(String serverName, String methodName) throws OMAGInvalidParameterException {
        if (serverName == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateConfigServerName(String serverName, String configServerName, String methodName) throws OMAGConfigurationErrorException {
        if (!serverName.equals(configServerName)) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.INCOMPATIBLE_SERVER_NAMES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, configServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    EventBusConfig validateEventBusIsSet(String serverName, OMAGServerConfig serverConfig, String methodName) throws OMAGConfigurationErrorException {
        EventBusConfig eventBusConfig = null;
        if (serverConfig != null) {
            eventBusConfig = serverConfig.getEventBusConfig();
        }
        if (eventBusConfig == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NO_EVENT_BUS_SET;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return eventBusConfig;
    }

    void validateAccessServiceIsRegistered(AccessServiceRegistration registration, String serviceURLMarker, String serverName, String methodName) throws OMAGConfigurationErrorException {
        if (registration == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.ACCESS_SERVICE_NOT_RECOGNIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, serviceURLMarker});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (registration.getAccessServiceOperationalStatus() != AccessServiceOperationalStatus.ENABLED) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.ACCESS_SERVICE_NOT_ENABLED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, serviceURLMarker});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateAccessServiceRootURL(String accessServiceRootURL, String accessServiceName, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (accessServiceRootURL == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_ACCESS_SERVICE_ROOT_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverService, serverName, accessServiceName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), serverService, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateAccessServiceServerName(String accessServiceServerName, String accessServiceName, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (accessServiceServerName == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_ACCESS_SERVICE_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverService, serverName, accessServiceName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), serverService, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateCohortName(String cohortName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (cohortName == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_COHORT_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateFileName(String fileName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (fileName == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_FILE_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateMetadataCollectionName(String name, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (name == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_METADATA_COLLECTION_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateConnection(Connection connection, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (connection == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateConnection(Connection connection, String methodName) throws OMAGInvalidParameterException {
        if (connection == null) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_PLATFORM_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

