/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

public class OMAGServerSecuritySyncService {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private static final String defaultOutTopicName = "OutTopic";
    private static final String defaultInTopicName = "open-metadata.access-services.GovernanceEngine.outTopic";
    private static final String outputTopic = "open-metadata.security-sync.";
    private static final String defaultOutTopic = ".outTopic";

    public VoidResponse setSecuritySyncConfig(String userId, String serverName, SecuritySyncConfig securitySyncConfig) {
        String methodName = "setSecuritySyncConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (securitySyncConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for Security Sync Service.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for Security Sync Service.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            EventBusConfig eventBusConfig = serverConfig.getEventBusConfig();
            if (securitySyncConfig != null && securitySyncConfig.getSecuritySyncInTopicName() != null) {
                securitySyncConfig.setSecuritySyncInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultInTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, securitySyncConfig.getSecuritySyncInTopicName(), UUID.randomUUID().toString(), eventBusConfig.getConfigurationProperties()));
            }
            if (securitySyncConfig != null && securitySyncConfig.getSecuritySyncServerType() != null) {
                securitySyncConfig.setSecuritySyncOutTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultOutTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, this.getOutputTopicName(securitySyncConfig.getSecuritySyncOutTopicName()), serverConfig.getLocalServerId(), eventBusConfig.getConfigurationProperties()));
            }
            if (securitySyncConfig != null && securitySyncConfig.getSecurityServerURL() != null && securitySyncConfig.getSecuritySyncServerAuthorization() != null) {
                HashMap<String, String> additionalProperties = new HashMap<String, String>();
                additionalProperties.put("securityServerAuthorization", securitySyncConfig.getSecuritySyncServerAuthorization());
                additionalProperties.put("securitySyncTagServiceName", securitySyncConfig.getSecuritySyncTagServiceName());
                additionalProperties.put("securitySyncServerType", securitySyncConfig.getSecuritySyncServerType());
                securitySyncConfig.setSecuritySyncServerConnection(connectorConfigurationFactory.getSecuritySyncServerConnection(serverName, securitySyncConfig.getSecurityServerURL(), additionalProperties));
            }
            serverConfig.setSecuritySyncConfig(securitySyncConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }

    private String getOutputTopicName(String securityServerType) {
        if (securityServerType != null) {
            return outputTopic + securityServerType + defaultOutTopic;
        }
        return "open-metadata.security-sync.SecuritySyncServer.outTopic";
    }

    public VoidResponse enableSecuritySyncService(String userId, String serverName) {
        String methodName = "enableSecuritySyncService";
        VoidResponse response = new VoidResponse();
        try {
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableSecuritySyncService");
            SecuritySyncConfig securitySyncConfig = serverConfig.getSecuritySyncConfig();
            this.setSecuritySyncConfig(userId, serverName, securitySyncConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "enableSecuritySyncService", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

