/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.ConfigurationManagementClient;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminServices {
    private static final Logger log = LoggerFactory.getLogger(OMAGServerAdminServices.class);
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setServerType(String userId, String serverName, String typeName) {
        String methodName = "setServerType";
        log.debug("Calling method: setServerType");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setServerType");
            this.errorHandler.validateUserId(userId, serverName, "setServerType");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerType");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(typeName)) {
                typeName = null;
            }
            if (typeName == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server type name.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server type name to " + typeName + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerType(typeName);
            this.configStore.saveServerConfig(serverName, "setServerType", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setServerType", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setServerType with response: " + response.toString());
        return response;
    }

    public VoidResponse setOrganizationName(String userId, String serverName, String name) {
        String methodName = "setOrganizationName";
        log.debug("Calling method: setOrganizationName");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOrganizationName");
            this.errorHandler.validateUserId(userId, serverName, "setOrganizationName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setOrganizationName");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(name)) {
                name = null;
            }
            if (name == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server's owning organization's name.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server's owning organization's name to " + name + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setOrganizationName(name);
            this.configStore.saveServerConfig(serverName, "setOrganizationName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setOrganizationName", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setOrganizationName with response: " + response.toString());
        return response;
    }

    public VoidResponse setServerUserId(String userId, String serverName, String serverUserId) {
        String methodName = "setServerUserId";
        log.debug("Calling method: setServerUserId");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerUserId");
            this.errorHandler.validateServerName(serverName, "setServerUserId");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerUserId");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(serverUserId)) {
                serverUserId = null;
            }
            if (serverUserId == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server's userId.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server's userId to " + serverUserId + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerUserId(serverUserId);
            this.configStore.saveServerConfig(serverName, "setServerUserId", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setServerUserId", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setServerUserId with response: " + response.toString());
        return response;
    }

    public VoidResponse setServerPassword(String userId, String serverName, String serverPassword) {
        String methodName = "setServerPassword";
        log.debug("Calling method: setServerPassword");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerPassword");
            this.errorHandler.validateServerName(serverName, "setServerPassword");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerPassword");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(serverPassword)) {
                serverPassword = null;
            }
            if (serverPassword == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server's password.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server's password to " + serverPassword + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerPassword(serverPassword);
            this.configStore.saveServerConfig(serverName, "setServerPassword", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setServerPassword", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setServerPassword with response: " + response.toString());
        return response;
    }

    public VoidResponse setMaxPageSize(String userId, String serverName, int maxPageSize) {
        String methodName = "setMaxPageSize";
        log.debug("Calling method: setMaxPageSize");
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<String> configAuditTrail;
            OMAGServerConfig serverConfig;
            this.errorHandler.validateServerName(serverName, "setMaxPageSize");
            this.errorHandler.validateUserId(userId, serverName, "setMaxPageSize");
            if (maxPageSize > 0) {
                serverConfig = this.configStore.getServerConfig(userId, serverName, "setMaxPageSize");
                configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<String>();
                }
            } else {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_MAX_PAGE_SIZE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, Integer.toString(maxPageSize)});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setMaxPageSize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for maximum page size to " + maxPageSize + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setMaxPageSize(maxPageSize);
            this.configStore.saveServerConfig(serverName, "setMaxPageSize", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setMaxPageSize", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setMaxPageSize with response: " + response.toString());
        return response;
    }

    public VoidResponse setEventBus(String userId, String serverName, String connectorProvider, String topicURLRoot, Map<String, Object> configurationProperties) {
        String methodName = "setEventBus";
        log.debug("Calling method: setEventBus");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEventBus");
            this.errorHandler.validateUserId(userId, serverName, "setEventBus");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setEventBus");
            EventBusConfig eventBusConfig = new EventBusConfig();
            eventBusConfig.setConnectorProvider(connectorProvider);
            eventBusConfig.setTopicURLRoot(topicURLRoot);
            eventBusConfig.setConfigurationProperties(configurationProperties);
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for default event bus.");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setEventBusConfig(eventBusConfig);
            this.configStore.saveServerConfig(serverName, "setEventBus", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setEventBus", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setEventBus with response: " + response.toString());
        return response;
    }

    public VoidResponse setServerURLRoot(String userId, String serverName, String url) {
        String methodName = "setServerURLRoot";
        log.debug("Calling method: setServerURLRoot");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerURLRoot");
            this.errorHandler.validateServerName(serverName, "setServerURLRoot");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerURLRoot");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(url)) {
                url = null;
            }
            if (url == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server's URL root.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server's URL root to " + url + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerURL(url);
            this.configStore.saveServerConfig(serverName, "setServerURLRoot", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setServerURLRoot", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setServerURLRoot with response: " + response.toString());
        return response;
    }

    public VoidResponse setDefaultAuditLog(String userId, String serverName) {
        String methodName = "setDefaultAuditLog";
        log.debug("Calling method: setDefaultAuditLog");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setDefaultAuditLog");
            this.errorHandler.validateUserId(userId, serverName, "setDefaultAuditLog");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getDefaultAuditLogConnection(serverName));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setDefaultAuditLog", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setDefaultAuditLog with response: " + response.toString());
        return response;
    }

    public VoidResponse addConsoleAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addConsoleAuditLogDestination";
        log.debug("Calling method: addConsoleAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addConsoleAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addConsoleAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getConsoleAuditLogConnection(serverName, supportedSeverities));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "addConsoleAuditLogDestination", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: addConsoleAuditLogDestination with response: " + response.toString());
        return response;
    }

    public VoidResponse addSLF4JAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addSLF4JAuditLogDestination";
        log.debug("Calling method: addSLF4JAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addSLF4JAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addSLF4JAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getSLF4JAuditLogConnection(serverName, supportedSeverities));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "addSLF4JAuditLogDestination", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: addSLF4JAuditLogDestination with response: " + response.toString());
        return response;
    }

    public VoidResponse addFileAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addFileAuditLogDestination";
        log.debug("Calling method: addFileAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addFileAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addFileAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getFileBasedAuditLogConnection(serverName, supportedSeverities));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "addFileAuditLogDestination", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: addFileAuditLogDestination with response: " + response.toString());
        return response;
    }

    public VoidResponse addEventTopicAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addEventTopicAuditLogDestination";
        log.debug("Calling method: addEventTopicAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addEventTopicAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addEventTopicAuditLogDestination");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addEventTopicAuditLogDestination");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "addEventTopicAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getEventTopicAuditLogConnection(serverName, supportedSeverities, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getConfigurationProperties()));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "addEventTopicAuditLogDestination", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: addEventTopicAuditLogDestination with response: " + response.toString());
        return response;
    }

    public VoidResponse addStartUpOpenMetadataArchiveFile(String userId, String serverName, String fileName) {
        String methodName = "addStartUpOpenMetadataArchiveFile";
        log.debug("Calling method: addStartUpOpenMetadataArchiveFile");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addStartUpOpenMetadataArchiveFile");
            this.errorHandler.validateUserId(userId, serverName, "addStartUpOpenMetadataArchiveFile");
            this.errorHandler.validateFileName(fileName, serverName, "addStartUpOpenMetadataArchiveFile");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            Connection newOpenMetadataArchive = configurationFactory.getOpenMetadataArchiveFileConnection(fileName);
            ArrayList<Connection> openMetadataArchiveConnections = null;
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addStartUpOpenMetadataArchiveFile");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                openMetadataArchiveConnections = repositoryServicesConfig.getOpenMetadataArchiveConnections();
            }
            if (openMetadataArchiveConnections == null) {
                openMetadataArchiveConnections = new ArrayList<Connection>();
            }
            openMetadataArchiveConnections.add(newOpenMetadataArchive);
            this.setOpenMetadataArchives(userId, serverName, openMetadataArchiveConnections);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "addStartUpOpenMetadataArchiveFile", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: addStartUpOpenMetadataArchiveFile with response: " + response.toString());
        return response;
    }

    public VoidResponse setInMemLocalRepository(String userId, String serverName) {
        String methodName = "setInMemLocalRepository";
        log.debug("Calling method: setInMemLocalRepository");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setInMemLocalRepository");
            this.errorHandler.validateUserId(userId, serverName, "setInMemLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setInMemLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getInMemoryLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL()));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setInMemLocalRepository", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setInMemLocalRepository with response: " + response.toString());
        return response;
    }

    public VoidResponse setGraphLocalRepository(String userId, String serverName) {
        String methodName = "setGraphLocalRepository";
        log.debug("Calling method: setGraphLocalRepository");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setGraphLocalRepository");
            this.errorHandler.validateUserId(userId, serverName, "setGraphLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setGraphLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getLocalGraphLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL()));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setGraphLocalRepository", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setGraphLocalRepository with response: " + response.toString());
        return response;
    }

    public VoidResponse setNoRepositoryMode(String userId, String serverName) {
        String methodName = "setNoRepositoryMode";
        log.debug("Calling method: setNoRepositoryMode");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setNoRepositoryMode");
            this.errorHandler.validateUserId(userId, serverName, "setNoRepositoryMode");
            this.setLocalRepositoryConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setNoRepositoryMode", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setNoRepositoryMode with response: " + response.toString());
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, Connection connection) {
        String methodName = "setRepositoryProxyConnection";
        log.debug("Calling method: setRepositoryProxyConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyConnection");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setRepositoryProxyConnection");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            LocalRepositoryConfig localRepositoryConfig = configurationFactory.getRepositoryProxyLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL());
            localRepositoryConfig.setLocalRepositoryLocalConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setRepositoryProxyConnection", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setRepositoryProxyConnection with response: " + response.toString());
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, String connectorProvider, Map<String, Object> additionalProperties) {
        String methodName = "setRepositoryProxyConnection";
        log.debug("Calling method: setRepositoryProxyConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyConnection");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setRepositoryProxyConnection");
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.setRepositoryProxyConnection(userId, serverName, connectorConfigurationFactory.getRepositoryProxyConnection(serverName, connectorProvider, serverConfig.getLocalServerURL(), additionalProperties));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setRepositoryProxyConnection", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setRepositoryProxyConnection with response: " + response.toString());
        return response;
    }

    public VoidResponse setLocalRepositoryEventMapper(String userId, String serverName, Connection connection) {
        String methodName = "setLocalRepositoryEventMapper";
        log.debug("Calling method: setLocalRepositoryEventMapper");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryEventMapper");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryEventMapper");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalRepositoryEventMapper");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setLocalRepositoryEventMapper", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            localRepositoryConfig.setEventMapperConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setLocalRepositoryEventMapper", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setLocalRepositoryEventMapper with response: " + response.toString());
        return response;
    }

    public VoidResponse setLocalRepositoryEventMapper(String userId, String serverName, String connectorProvider, String eventSource, Map<String, Object> additionalProperties) {
        String methodName = "setLocalRepositoryEventMapper";
        log.debug("Calling method: setLocalRepositoryEventMapper");
        VoidResponse response = new VoidResponse();
        try {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryEventMapper");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryEventMapper");
            this.setLocalRepositoryEventMapper(userId, serverName, connectorConfigurationFactory.getRepositoryEventMapperConnection(serverName, connectorProvider, additionalProperties, eventSource));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setLocalRepositoryEventMapper", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setLocalRepositoryEventMapper with response: " + response.toString());
        return response;
    }

    public GUIDResponse getLocalMetadataCollectionId(String userId, String serverName) {
        String methodName = "getLocalMetadataCollectionId";
        log.debug("Calling method: getLocalMetadataCollectionId");
        GUIDResponse response = new GUIDResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getLocalMetadataCollectionId");
            this.errorHandler.validateUserId(userId, serverName, "getLocalMetadataCollectionId");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getLocalMetadataCollectionId");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getLocalMetadataCollectionId", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            response.setGUID(localRepositoryConfig.getMetadataCollectionId());
            return response;
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "getLocalMetadataCollectionId", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: getLocalMetadataCollectionId with response: " + response.toString());
        return response;
    }

    public VoidResponse setLocalMetadataCollectionName(String userId, String serverName, String localMetadataCollectionName) {
        String methodName = "setLocalMetadataCollectionName";
        log.debug("Calling method: setLocalMetadataCollectionName");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalMetadataCollectionName");
            this.errorHandler.validateUserId(userId, serverName, "setLocalMetadataCollectionName");
            this.errorHandler.validateMetadataCollectionName(localMetadataCollectionName, serverName, "setLocalMetadataCollectionName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalMetadataCollectionName");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setLocalMetadataCollectionName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            localRepositoryConfig.setMetadataCollectionName(localMetadataCollectionName);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setLocalMetadataCollectionName", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setLocalMetadataCollectionName with response: " + response.toString());
        return response;
    }

    public VoidResponse enableCohortRegistration(String userId, String serverName, String cohortName, Map<String, Object> configurationProperties) {
        String methodName = "enableCohortRegistration";
        log.debug("Calling method: enableCohortRegistration");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "enableCohortRegistration");
            this.errorHandler.validateUserId(userId, serverName, "enableCohortRegistration");
            this.errorHandler.validateCohortName(cohortName, serverName, "enableCohortRegistration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableCohortRegistration");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "enableCohortRegistration");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            CohortConfig newCohortConfig = configurationFactory.getDefaultCohortConfig(serverConfig.getLocalServerName(), cohortName, configurationProperties, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getConfigurationProperties());
            this.setCohortConfig(userId, serverName, cohortName, newCohortConfig);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "enableCohortRegistration", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: enableCohortRegistration with response: " + response.toString());
        return response;
    }

    public VoidResponse disableCohortRegistration(String userId, String serverName, String cohortName) {
        String methodName = "setCohortMode";
        log.debug("Calling method: setCohortMode");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setCohortMode");
            this.errorHandler.validateUserId(userId, serverName, "setCohortMode");
            this.errorHandler.validateCohortName(cohortName, serverName, "setCohortMode");
            this.setCohortConfig(userId, serverName, cohortName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setCohortMode", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setCohortMode with response: " + response.toString());
        return response;
    }

    public VoidResponse setAuditLogDestinations(String userId, String serverName, List<Connection> auditLogDestinations) {
        String methodName = "setAuditLogDestinations";
        log.debug("Calling method: setAuditLogDestinations");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAuditLogDestinations");
            this.errorHandler.validateUserId(userId, serverName, "setAuditLogDestinations");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAuditLogDestinations");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (auditLogDestinations == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " setting up no audit log destinations.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated list of audit log destinations.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
            } else if (auditLogDestinations != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setAuditLogDestinations", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setAuditLogDestinations", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setAuditLogDestinations with response: " + response.toString());
        return response;
    }

    public VoidResponse addAuditLogDestination(String userId, String serverName, Connection auditLogDestination) {
        String methodName = "setAuditLogDestinations";
        log.debug("Calling method: setAuditLogDestinations");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAuditLogDestinations");
            this.errorHandler.validateUserId(userId, serverName, "setAuditLogDestinations");
            if (auditLogDestination != null) {
                ArrayList<Connection> auditLogDestinations;
                RepositoryServicesConfig repositoryServicesConfig;
                OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAuditLogDestinations");
                ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<String>();
                }
                if ((repositoryServicesConfig = serverConfig.getRepositoryServicesConfig()) == null) {
                    OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                    repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                }
                if ((auditLogDestinations = repositoryServicesConfig.getAuditLogConnections()) == null) {
                    auditLogDestinations = new ArrayList<Connection>();
                    configAuditTrail.add(new Date().toString() + " " + userId + " created first audit log destination.");
                } else {
                    configAuditTrail.add(new Date().toString() + " " + userId + " added to list of audit log destinations.");
                }
                auditLogDestinations.add(auditLogDestination);
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
                serverConfig.setAuditTrail(configAuditTrail);
                serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
                this.configStore.saveServerConfig(serverName, "setAuditLogDestinations", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setAuditLogDestinations", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setAuditLogDestinations with response: " + response.toString());
        return response;
    }

    public VoidResponse clearAuditLogDestinations(String userId, String serverName) {
        return this.setAuditLogDestinations(userId, serverName, null);
    }

    public VoidResponse setOpenMetadataArchives(String userId, String serverName, List<Connection> openMetadataArchives) {
        String methodName = "setOpenMetadataArchives";
        log.debug("Calling method: setOpenMetadataArchives");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOpenMetadataArchives");
            this.errorHandler.validateUserId(userId, serverName, "setOpenMetadataArchives");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setOpenMetadataArchives");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (openMetadataArchives == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " clearing open metadata archives.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated list of open metadata archives loaded at server start up.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setOpenMetadataArchiveConnections(openMetadataArchives);
            } else if (openMetadataArchives != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setOpenMetadataArchiveConnections(openMetadataArchives);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setOpenMetadataArchives", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setOpenMetadataArchives", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setOpenMetadataArchives with response: " + response.toString());
        return response;
    }

    public VoidResponse setLocalRepositoryConfig(String userId, String serverName, LocalRepositoryConfig localRepositoryConfig) {
        String methodName = "setLocalRepositoryConfig";
        log.debug("Calling method: setLocalRepositoryConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryConfig");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalRepositoryConfig");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (localRepositoryConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " setting up a null local repository.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for the local repository.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                String existingMetadataCollectionId;
                LocalRepositoryConfig existingLocalRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
                if (localRepositoryConfig != null && existingLocalRepositoryConfig != null && (existingMetadataCollectionId = existingLocalRepositoryConfig.getMetadataCollectionId()) != null) {
                    configAuditTrail.add(new Date().toString() + " " + userId + " preserving local metadata collection id " + existingMetadataCollectionId + ".");
                    localRepositoryConfig.setMetadataCollectionId(existingMetadataCollectionId);
                }
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            } else if (localRepositoryConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setLocalRepositoryConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setLocalRepositoryConfig", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setLocalRepositoryConfig with response: " + response.toString());
        return response;
    }

    public VoidResponse setCohortConfig(String userId, String serverName, String cohortName, CohortConfig cohortConfig) {
        String methodName = "setCohortConfig";
        log.debug("Calling method: setCohortConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setCohortConfig");
            this.errorHandler.validateUserId(userId, serverName, "setCohortConfig");
            this.errorHandler.validateCohortName(cohortName, serverName, "setCohortConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setCohortConfig");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            List existingCohortConfigs = null;
            ArrayList<CohortConfig> newCohortConfigs = new ArrayList<CohortConfig>();
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (cohortConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for cohort " + cohortName + ".");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for cohort " + cohortName + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            if (repositoryServicesConfig != null) {
                existingCohortConfigs = repositoryServicesConfig.getCohortConfigList();
            }
            if (existingCohortConfigs != null) {
                for (CohortConfig existingCohort : existingCohortConfigs) {
                    String existingCohortName;
                    if (existingCohort == null || cohortName.equals(existingCohortName = existingCohort.getCohortName())) continue;
                    newCohortConfigs.add(existingCohort);
                }
            }
            if (cohortConfig != null) {
                newCohortConfigs.add(cohortConfig);
            }
            if (newCohortConfigs.isEmpty()) {
                newCohortConfigs = null;
            }
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            } else if (newCohortConfigs != null) {
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setCohortConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setCohortConfig", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setCohortConfig with response: " + response.toString());
        return response;
    }

    public VoidResponse setOMAGServerConfig(String userId, String serverName, OMAGServerConfig omagServerConfig) {
        String methodName = "setOMAGServerConfig";
        log.debug("Calling method: setOMAGServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOMAGServerConfig");
            this.errorHandler.validateUserId(userId, serverName, "setOMAGServerConfig");
            if (omagServerConfig == null) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_SERVER_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setOMAGServerConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            ArrayList<String> configAuditTrail = omagServerConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " deployed configuration for server.");
            omagServerConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "setOMAGServerConfig", omagServerConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setOMAGServerConfig", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setOMAGServerConfig with response: " + response.toString());
        return response;
    }

    public VoidResponse deployOMAGServerConfig(String userId, String serverName, URLRequestBody destinationPlatform) {
        String methodName = "deployOMAGServerConfig";
        log.debug("Calling method: deployOMAGServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deployOMAGServerConfig");
            this.errorHandler.validateUserId(userId, serverName, "deployOMAGServerConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "deployOMAGServerConfig");
            String serverURLRoot = serverConfig.getLocalServerURL();
            if (destinationPlatform != null && destinationPlatform.getUrlRoot() != null) {
                serverURLRoot = destinationPlatform.getUrlRoot();
            }
            ConfigurationManagementClient client = new ConfigurationManagementClient(serverName, serverURLRoot);
            client.setOMAGServerConfig(userId, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "deployOMAGServerConfig", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: deployOMAGServerConfig with response: " + response.toString());
        return response;
    }

    public OMAGServerConfigResponse getStoredConfiguration(String userId, String serverName) {
        String methodName = "getStoredConfiguration";
        log.debug("Calling method: getStoredConfiguration");
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getStoredConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getStoredConfiguration");
            response.setOMAGServerConfig(this.configStore.getServerConfig(userId, serverName, "getStoredConfiguration"));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "getStoredConfiguration", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: getStoredConfiguration with response: " + response.toString());
        return response;
    }
}

