/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGOperationalServicesInstance;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.OMAGServerOperationalInstanceHandler;
import org.odpi.openmetadata.adminservices.auditlog.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ConformanceSuiteConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataPlatformServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecurityOfficerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.StewardshipServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.VirtualizationConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.admin.OCFMetadataOperationalServices;
import org.odpi.openmetadata.conformance.server.ConformanceSuiteOperationalServices;
import org.odpi.openmetadata.dataplatformservices.admin.DataPlatformOperationalServices;
import org.odpi.openmetadata.discoveryserver.server.DiscoveryServerOperationalServices;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.dataengineproxy.admin.DataEngineProxyOperationalServices;
import org.odpi.openmetadata.governanceservers.openlineage.admin.OpenLineageServerOperationalServices;
import org.odpi.openmetadata.governanceservers.stewardshipservices.admin.StewardshipOperationalServices;
import org.odpi.openmetadata.governanceservers.virtualizationservices.admin.VirtualizationOperationalServices;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.admin.OMRSOperationalServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.securityofficerservices.registration.SecurityOfficerOperationalServices;
import org.odpi.openmetadata.securitysyncservices.registration.SecuritySyncOperationalServices;

public class OMAGServerOperationalServices {
    private OMAGServerOperationalInstanceHandler instanceHandler = new OMAGServerOperationalInstanceHandler(CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public SuccessMessageResponse activateServerListWithStoredConfig(String userId, List<String> serverNames) {
        String startUpMessage = null;
        SuccessMessageResponse response = new SuccessMessageResponse();
        response.setRelatedHTTPCode(200);
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                response = this.activateWithStoredConfig(userId, serverName.trim());
                if (response.getRelatedHTTPCode() == 200) {
                    String serverStartUpMessage = "OMAG Server '" + serverName + "' successful start , with message: " + response.getSuccessMessage() + System.lineSeparator();
                    if (startUpMessage == null) {
                        startUpMessage = serverStartUpMessage;
                        continue;
                    }
                    startUpMessage = startUpMessage + serverStartUpMessage;
                    continue;
                }
                break;
            }
        } else {
            String noAutoStartServers = "No OMAG servers listed in startup configuration";
            startUpMessage = "No OMAG servers listed in startup configuration";
        }
        if (response.getRelatedHTTPCode() == 200) {
            response.setSuccessMessage(startUpMessage);
        }
        return response;
    }

    public SuccessMessageResponse activateWithStoredConfig(String userId, String serverName) {
        String methodName = "activateWithStoredConfig";
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithStoredConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithStoredConfig");
            response = this.activateWithSuppliedConfig(userId, serverName, this.configStore.getServerConfig(userId, serverName, "activateWithStoredConfig"));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "activateWithStoredConfig", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public SuccessMessageResponse activateWithSuppliedConfig(String userId, String serverName, OMAGServerConfig configuration) {
        String methodName = "activateWithSuppliedConfig";
        ArrayList<String> activatedServiceList = new ArrayList<String>();
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithSuppliedConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithSuppliedConfig");
            if (configuration == null) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_SERVER_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            int maxPageSize = configuration.getMaxPageSize();
            RepositoryServicesConfig repositoryServicesConfig = configuration.getRepositoryServicesConfig();
            List accessServiceConfigList = configuration.getAccessServicesConfig();
            ConformanceSuiteConfig conformanceSuiteConfig = configuration.getConformanceSuiteConfig();
            DiscoveryServerConfig discoveryServerConfig = configuration.getDiscoveryServerConfig();
            OpenLineageServerConfig openLineageServerConfig = configuration.getOpenLineageServerConfig();
            SecuritySyncConfig securitySyncConfig = configuration.getSecuritySyncConfig();
            SecurityOfficerConfig securityOfficerConfig = configuration.getSecurityOfficerConfig();
            StewardshipServicesConfig stewardshipServicesConfig = configuration.getStewardshipServicesConfig();
            VirtualizationConfig virtualizationConfig = configuration.getVirtualizationConfig();
            DataEngineProxyConfig dataEngineProxyConfig = configuration.getDataEngineProxyConfig();
            DataPlatformServicesConfig dataPlatformServicesConfig = configuration.getDataPlatformServicesConfig();
            if (repositoryServicesConfig == null && accessServiceConfigList == null && conformanceSuiteConfig == null && discoveryServerConfig == null && openLineageServerConfig == null && securitySyncConfig == null && securityOfficerConfig == null && stewardshipServicesConfig == null && virtualizationConfig == null && dataEngineProxyConfig == null && dataPlatformServicesConfig == null) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.EMPTY_CONFIGURATION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (repositoryServicesConfig == null) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_REPOSITORY_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.errorHandler.validateConfigServerName(serverName, configuration.getLocalServerName(), "activateWithSuppliedConfig");
            this.configStore.saveServerConfig(serverName, "activateWithSuppliedConfig", configuration);
            if (this.instanceHandler.isServerActive(userId, serverName)) {
                this.deactivateTemporarily(userId, serverName);
            }
            OMAGOperationalServicesInstance instance = new OMAGOperationalServicesInstance(serverName, CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName(), maxPageSize);
            instance.setOperationalConfiguration(configuration);
            OMRSOperationalServices operationalRepositoryServices = new OMRSOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
            activatedServiceList.add(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName());
            instance.setOperationalRepositoryServices(operationalRepositoryServices);
            operationalRepositoryServices.initialize(repositoryServicesConfig);
            OpenMetadataServerSecurityVerifier securityVerifier = this.platformInstanceMap.startUpServerInstance(configuration.getLocalServerUserId(), serverName, operationalRepositoryServices.getAuditLog(CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceCode(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceName(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDescription(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceWiki()), configuration.getServerSecurityConnection());
            operationalRepositoryServices.setSecurityVerifier(securityVerifier);
            OMRSRepositoryConnector enterpriseRepositoryConnector = operationalRepositoryServices.getEnterpriseOMRSRepositoryConnector(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName());
            if (enterpriseRepositoryConnector != null) {
                OCFMetadataOperationalServices operationalOCFMetadataServices = new OCFMetadataOperationalServices(configuration.getLocalServerName(), enterpriseRepositoryConnector, operationalRepositoryServices.getAuditLog(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceCode(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceDescription(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceWiki()), configuration.getLocalServerUserId(), maxPageSize);
                instance.setOperationalOCFMetadataServices(operationalOCFMetadataServices);
                activatedServiceList.add(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName());
            }
            OMRSTopicConnector enterpriseTopicConnector = operationalRepositoryServices.getEnterpriseOMRSTopicConnector();
            List<AccessServiceAdmin> operationalAccessServiceAdminList = instance.getOperationalAccessServiceAdminList();
            if (accessServiceConfigList != null) {
                for (AccessServiceConfig accessServiceConfig : accessServiceConfigList) {
                    if (accessServiceConfig == null || accessServiceConfig.getAccessServiceId() == AccessServiceDescription.CONNECTED_ASSET_OMAS.getAccessServiceCode()) continue;
                    String accessServiceAdminClassName = accessServiceConfig.getAccessServiceAdminClass();
                    if (accessServiceAdminClassName != null) {
                        OMRSAuditLog auditLog = operationalRepositoryServices.getAuditLog(accessServiceConfig.getAccessServiceId(), accessServiceConfig.getAccessServiceName(), accessServiceConfig.getAccessServiceDescription(), accessServiceConfig.getAccessServiceWiki());
                        try {
                            AccessServiceAdmin accessServiceAdmin = (AccessServiceAdmin)Class.forName(accessServiceAdminClassName).newInstance();
                            accessServiceAdmin.initialize(accessServiceConfig, enterpriseTopicConnector, operationalRepositoryServices.getEnterpriseOMRSRepositoryConnector(accessServiceConfig.getAccessServiceName()), auditLog, configuration.getLocalServerUserId());
                            operationalAccessServiceAdminList.add(accessServiceAdmin);
                            activatedServiceList.add(accessServiceConfig.getAccessServiceName() + " OMAS");
                            continue;
                        }
                        catch (OMAGConfigurationErrorException error) {
                            OMAGAdminAuditCode auditCode = OMAGAdminAuditCode.SERVICE_INSTANCE_FAILURE;
                            auditLog.logException("activateWithSuppliedConfig", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceConfig.getAccessServiceName(), error.getMessage()), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)error);
                            throw error;
                        }
                        catch (Throwable error) {
                            OMAGAdminAuditCode auditCode = OMAGAdminAuditCode.SERVICE_INSTANCE_FAILURE;
                            auditLog.logException("activateWithSuppliedConfig", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage(), accessServiceConfig.getAccessServiceName(), error.getMessage()), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), error);
                            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_ACCESS_SERVICE_ADMIN_CLASS;
                            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, accessServiceAdminClassName, accessServiceConfig.getAccessServiceName()});
                            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
                        }
                    }
                    OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_ACCESS_SERVICE_ADMIN_CLASS;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, accessServiceConfig.getAccessServiceName()});
                    throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            }
            instance.setOperationalAccessServiceAdminList(operationalAccessServiceAdminList);
            if (conformanceSuiteConfig != null) {
                ConformanceSuiteOperationalServices operationalConformanceSuiteServices = new ConformanceSuiteOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
                instance.setOperationalConformanceSuiteServices(operationalConformanceSuiteServices);
                operationalConformanceSuiteServices.initialize(conformanceSuiteConfig, enterpriseTopicConnector, operationalRepositoryServices.getEnterpriseConnectorManager(), operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceCode(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceDescription(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName());
            }
            if (enterpriseTopicConnector != null) {
                try {
                    enterpriseTopicConnector.start();
                }
                catch (Throwable error) {
                    OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.ENTERPRISE_TOPIC_START_FAILED;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, error.getMessage()});
                    throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            }
            if (discoveryServerConfig != null) {
                DiscoveryServerOperationalServices operationalDiscoveryServer = new DiscoveryServerOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
                instance.setOperationalDiscoveryServer(operationalDiscoveryServer);
                operationalDiscoveryServer.initialize(discoveryServerConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceCode(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceDescription(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName());
            }
            if (openLineageServerConfig != null) {
                OpenLineageServerOperationalServices operationalOpenLineageServer = new OpenLineageServerOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
                instance.setOpenLineageOperationalServices(operationalOpenLineageServer);
                operationalOpenLineageServer.initialize(openLineageServerConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceCode(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceDescription(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName());
            }
            if (securitySyncConfig != null) {
                SecuritySyncOperationalServices operationalSecuritySync = new SecuritySyncOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
                instance.setOperationalSecuritySyncServices(operationalSecuritySync);
                operationalSecuritySync.initialize(securitySyncConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceCode(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceDescription(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName());
            }
            if (securityOfficerConfig != null) {
                SecurityOfficerOperationalServices operationalSecurityOfficer = new SecurityOfficerOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
                instance.setOperationalSecurityOfficerService(operationalSecurityOfficer);
                operationalSecurityOfficer.initialize(securityOfficerConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceCode(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceDescription(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName());
            }
            if (virtualizationConfig != null) {
                VirtualizationOperationalServices operationalVirtualizationServices = new VirtualizationOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerURL());
                instance.setOperationalVirtualizationServices(operationalVirtualizationServices);
                operationalVirtualizationServices.initialize(virtualizationConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceCode(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceDescription(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName());
            }
            if (dataEngineProxyConfig != null) {
                DataEngineProxyOperationalServices operationalDataEngineProxyServices = new DataEngineProxyOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword());
                instance.setOperationalDataEngineProxyServices(operationalDataEngineProxyServices);
                operationalDataEngineProxyServices.initialize(dataEngineProxyConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceCode(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceDescription(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName());
            }
            if (stewardshipServicesConfig != null) {
                StewardshipOperationalServices operationalStewardshipServices = new StewardshipOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                instance.setOperationalStewardshipServices(operationalStewardshipServices);
                operationalStewardshipServices.initialize(stewardshipServicesConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceCode(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceDescription(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName());
            }
            if (dataPlatformServicesConfig != null) {
                DataPlatformOperationalServices dataPlatformOperationalServices = new DataPlatformOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerType(), configuration.getLocalServerURL());
                instance.setOperationalDataPlatformServices(dataPlatformOperationalServices);
                dataPlatformOperationalServices.initialize(dataPlatformServicesConfig, operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceCode(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceDescription(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceWiki()));
                activatedServiceList.add(GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName());
            }
            String successMessage = new Date().toString() + " " + serverName + " is running the following services: " + ((Object)activatedServiceList).toString();
            response.setSuccessMessage(successMessage);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "activateWithSuppliedConfig", (FFDCResponseBase)response, error);
        }
        return response;
    }

    private void deactivateRunningServiceInstances(String userId, String serverName, String methodName, OMAGOperationalServicesInstance instance, boolean permanentDeactivation) throws InvalidParameterException, PropertyServerException {
        if (instance.getOperationalAccessServiceAdminList() != null) {
            for (AccessServiceAdmin accessServiceAdmin : instance.getOperationalAccessServiceAdminList()) {
                if (accessServiceAdmin == null) continue;
                accessServiceAdmin.shutdown();
            }
        }
        if (instance.getOperationalOCFMetadataServices() != null) {
            instance.getOperationalOCFMetadataServices().shutdown();
        }
        if (instance.getOperationalDiscoveryServer() != null) {
            instance.getOperationalDiscoveryServer().terminate();
        }
        if (instance.getOpenLineageOperationalServices() != null) {
            instance.getOpenLineageOperationalServices().disconnect(permanentDeactivation);
        }
        if (instance.getOperationalSecuritySyncServices() != null) {
            instance.getOperationalSecuritySyncServices().disconnect();
        }
        if (instance.getOperationalSecurityOfficerService() != null) {
            instance.getOperationalSecurityOfficerService().disconnect();
        }
        if (instance.getOperationalVirtualizationServices() != null) {
            instance.getOperationalVirtualizationServices().disconnect(permanentDeactivation);
        }
        if (instance.getOperationalStewardshipServices() != null) {
            instance.getOperationalStewardshipServices().terminate(permanentDeactivation);
        }
        if (instance.getOperationalDataPlatformServices() != null) {
            instance.getOperationalDataPlatformServices().disconnect(permanentDeactivation);
        }
        if (instance.getOperationalConformanceSuiteServices() != null) {
            instance.getOperationalConformanceSuiteServices().terminate(permanentDeactivation);
        }
        if (instance.getOperationalRepositoryServices() != null) {
            instance.getOperationalRepositoryServices().disconnect(permanentDeactivation);
        }
        this.instanceHandler.removeServerServiceInstance(serverName);
        this.platformInstanceMap.shutdownServerInstance(userId, serverName, methodName);
    }

    public void deactivateTemporarilyServerList(String userId, List<String> serverNames) {
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                this.deactivateTemporarily(userId, serverName);
            }
        }
    }

    public VoidResponse deactivateTemporarily(String userId, String serverName) {
        String methodName = "deactivateTemporarily";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deactivateTemporarily");
            this.errorHandler.validateUserId(userId, serverName, "deactivateTemporarily");
            this.deactivateRunningServiceInstances(userId, serverName, "deactivateTemporarily", this.instanceHandler.getServerServiceInstance(userId, serverName, "deactivateTemporarily"), false);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "deactivateTemporarily", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse deactivatePermanently(String userId, String serverName) {
        String methodName = "deactivatePermanently";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deactivatePermanently");
            this.errorHandler.validateUserId(userId, serverName, "deactivatePermanently");
            this.deactivateRunningServiceInstances(userId, serverName, "deactivatePermanently", this.instanceHandler.getServerServiceInstance(userId, serverName, "deactivatePermanently"), true);
            this.configStore.saveServerConfig(serverName, "deactivatePermanently", null);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "deactivatePermanently", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public OMAGServerConfigResponse getActiveConfiguration(String userId, String serverName) {
        String methodName = "getActiveConfiguration";
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "getActiveConfiguration");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "getActiveConfiguration");
            response.setOMAGServerConfig(instance.getOperationalConfiguration());
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "getActiveConfiguration", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse addOpenMetadataArchiveFile(String userId, String serverName, String fileName) {
        String methodName = "addOpenMetadataArchiveFile";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateUserId(userId, serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateFileName(fileName, serverName, "addOpenMetadataArchiveFile");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            Connection newOpenMetadataArchive = configurationFactory.getOpenMetadataArchiveFileConnection(fileName);
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "addOpenMetadataArchiveFile");
            OMRSOperationalServices repositoryServicesInstance = instance.getOperationalRepositoryServices();
            repositoryServicesInstance.addOpenMetadataArchive(newOpenMetadataArchive, fileName);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "addOpenMetadataArchiveFile", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

