/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForAccessServices {
    private static final Logger log = LoggerFactory.getLogger(OMAGServerAdminForAccessServices.class);
    private static final String defaultInTopicName = "InTopic";
    private static final String defaultOutTopicName = "OutTopic";
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public RegisteredOMAGServicesResponse getConfiguredAccessServices(String userId, String serverName) {
        String methodName = "getConfiguredAccessServices";
        log.debug("Calling method: getConfiguredAccessServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getConfiguredAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "getConfiguredAccessServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getConfiguredAccessServices");
            List accessServiceConfigList = serverConfig.getAccessServicesConfig();
            if (accessServiceConfigList != null && !accessServiceConfigList.isEmpty()) {
                for (AccessServiceConfig accessServiceConfig : accessServiceConfigList) {
                    if (accessServiceConfig == null || accessServiceConfig.getAccessServiceOperationalStatus() != AccessServiceOperationalStatus.ENABLED) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceName(accessServiceConfig.getAccessServiceName());
                    service.setServiceDescription(accessServiceConfig.getAccessServiceDescription());
                    service.setServiceURLMarker(accessServiceConfig.getAccessServiceURLMarker());
                    service.setServiceWiki(accessServiceConfig.getAccessServiceWiki());
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "getConfiguredAccessServices", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: getConfiguredAccessServices with response: " + response.toString());
        return response;
    }

    public VoidResponse configureAccessService(String userId, String serverName, String serviceURLMarker, Map<String, Object> accessServiceOptions) {
        String methodName = "configureAccessService";
        log.debug("Calling method: configureAccessService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAccessService");
            this.errorHandler.validateUserId(userId, serverName, "configureAccessService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureAccessService");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "configureAccessService");
            List<AccessServiceConfig> accessServiceConfigList = serverConfig.getAccessServicesConfig();
            EnterpriseAccessConfig enterpriseAccessConfig = this.getEnterpriseAccessConfig(serverConfig);
            AccessServiceRegistration accessServiceRegistration = OMAGAccessServiceRegistration.getAccessServiceRegistration((String)serviceURLMarker);
            this.errorHandler.validateAccessServiceIsRegistered(accessServiceRegistration, serviceURLMarker, serverName, "configureAccessService");
            accessServiceConfigList = this.updateAccessServiceConfig(this.createAccessServiceConfig(accessServiceRegistration, accessServiceOptions, eventBusConfig, serverName, serverConfig.getLocalServerId()), accessServiceConfigList);
            if (enterpriseAccessConfig == null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "configureAccessService", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: configureAccessService with response: " + response.toString());
        return response;
    }

    public VoidResponse enableAccessServices(String userId, String serverName, Map<String, Object> accessServiceOptions) {
        String methodName = "enableAccessServices";
        log.debug("Calling method: enableAccessServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "enableAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "enableAccessServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableAccessServices");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "enableAccessServices");
            ArrayList<AccessServiceConfig> accessServiceConfigList = new ArrayList<AccessServiceConfig>();
            EnterpriseAccessConfig enterpriseAccessConfig = null;
            List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
            if (accessServiceRegistrationList != null && !accessServiceRegistrationList.isEmpty()) {
                for (AccessServiceRegistration registration : accessServiceRegistrationList) {
                    if (registration == null || registration.getAccessServiceOperationalStatus() != AccessServiceOperationalStatus.ENABLED) continue;
                    accessServiceConfigList.add(this.createAccessServiceConfig(registration, accessServiceOptions, eventBusConfig, serverName, serverConfig.getLocalServerId()));
                }
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            if (accessServiceConfigList.isEmpty()) {
                accessServiceConfigList = null;
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "enableAccessServices", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: enableAccessServices with response: " + response.toString());
        return response;
    }

    private AccessServiceConfig createAccessServiceConfig(AccessServiceRegistration registration, Map<String, Object> accessServiceOptions, EventBusConfig eventBusConfig, String serverName, String localServerId) {
        ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
        AccessServiceConfig accessServiceConfig = new AccessServiceConfig(registration);
        accessServiceConfig.setAccessServiceOptions(accessServiceOptions);
        accessServiceConfig.setAccessServiceInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultInTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, registration.getAccessServiceInTopic(), localServerId, eventBusConfig.getConfigurationProperties()));
        accessServiceConfig.setAccessServiceOutTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultOutTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, registration.getAccessServiceOutTopic(), localServerId, eventBusConfig.getConfigurationProperties()));
        return accessServiceConfig;
    }

    private List<AccessServiceConfig> updateAccessServiceConfig(AccessServiceConfig accessServiceConfig, List<AccessServiceConfig> currentList) {
        if (accessServiceConfig == null) {
            return currentList;
        }
        ArrayList<AccessServiceConfig> newList = new ArrayList<AccessServiceConfig>();
        if (currentList != null) {
            for (AccessServiceConfig existingConfig : currentList) {
                if (existingConfig == null || accessServiceConfig.getAccessServiceId() == existingConfig.getAccessServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(accessServiceConfig);
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    public VoidResponse disableAccessServices(String userId, String serverName) {
        String methodName = "disableAccessServices";
        log.debug("Calling method: disableAccessServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "disableAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "disableAccessServices");
            this.setAccessServicesConfig(userId, serverName, null);
            this.setEnterpriseAccessConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "disableAccessServices", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: disableAccessServices with response: " + response.toString());
        return response;
    }

    public VoidResponse setAccessServicesConfig(String userId, String serverName, List<AccessServiceConfig> accessServicesConfig) {
        String methodName = "setAccessServicesConfig";
        log.debug("Calling method: setAccessServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAccessServicesConfig");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (accessServicesConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for access services.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for access services.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setAccessServicesConfig(accessServicesConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServicesConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setAccessServicesConfig", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setAccessServicesConfig with response: " + response.toString());
        return response;
    }

    private EnterpriseAccessConfig getEnterpriseAccessConfig(OMAGServerConfig serverConfig) {
        RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
        if (repositoryServicesConfig != null) {
            return repositoryServicesConfig.getEnterpriseAccessConfig();
        }
        return null;
    }

    public VoidResponse setEnterpriseAccessConfig(String userId, String serverName, EnterpriseAccessConfig enterpriseAccessConfig) {
        String methodName = "setEnterpriseAccessConfig";
        log.debug("Calling method: setEnterpriseAccessConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEnterpriseAccessConfig");
            this.errorHandler.validateUserId(userId, serverName, "setEnterpriseAccessConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setEnterpriseAccessConfig");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (enterpriseAccessConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for enterprise repository services (used by access services).");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for enterprise repository services (used by access services).");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            } else if (enterpriseAccessConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig(serverConfig.getLocalServerName());
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setEnterpriseAccessConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setEnterpriseAccessConfig", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setEnterpriseAccessConfig with response: " + response.toString());
        return response;
    }
}

