/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStore;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminStoreServices {
    private static Connection configurationStoreConnection = null;
    private static final Logger log = LoggerFactory.getLogger(OMAGServerAdminStoreServices.class);
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();

    public synchronized VoidResponse setConfigurationStoreConnection(String userId, Connection connection) {
        String methodName = "setConfigurationStoreConnection";
        log.debug("Calling method: setConfigurationStoreConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            this.errorHandler.validateConnection(connection, "setConfigurationStoreConnection");
            configurationStoreConnection = connection;
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException("setConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setConfigurationStoreConnection with response: " + response.toString());
        return response;
    }

    public synchronized ConnectionResponse getConfigurationStoreConnection(String userId) {
        String methodName = "getConfigurationStoreConnection";
        log.debug("Calling method: getConfigurationStoreConnection");
        ConnectionResponse response = new ConnectionResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            response.setConnection(configurationStoreConnection);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException("getConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: getConfigurationStoreConnection with response: " + response.toString());
        return response;
    }

    public synchronized VoidResponse clearConfigurationStoreConnection(String userId) {
        String methodName = "clearConfigurationStoreConnection";
        log.debug("Calling method: clearConfigurationStoreConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            configurationStoreConnection = null;
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException("clearConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: clearConfigurationStoreConnection with response: " + response.toString());
        return response;
    }

    private synchronized Connection getConnection(String serverName) {
        if (configurationStoreConnection == null) {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            return connectorConfigurationFactory.getServerConfigConnection(serverName);
        }
        return configurationStoreConnection;
    }

    private OMAGServerConfigStore getServerConfigStore(String serverName, String methodName) throws OMAGInvalidParameterException {
        Connection connection = this.getConnection(serverName);
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            return (OMAGServerConfigStore)connector;
        }
        catch (Throwable error) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_CONFIG_FILE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, error.getMessage()});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    OMAGServerConfig getServerConfig(String userId, String serverName, String methodName) throws OMAGInvalidParameterException, OMAGNotAuthorizedException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        OMAGServerConfig serverConfig = null;
        if (serverConfigStore != null) {
            serverConfig = serverConfigStore.retrieveServerConfig();
        }
        if (serverConfig == null) {
            try {
                OpenMetadataPlatformSecurityVerifier.validateUserForNewServer((String)userId);
            }
            catch (UserNotAuthorizedException error) {
                throw new OMAGNotAuthorizedException(error);
            }
            serverConfig = new OMAGServerConfig();
            serverConfig.setVersionId("V2.0");
        } else {
            String versionId = serverConfig.getVersionId();
            boolean isCompatibleVersion = false;
            if (versionId == null) {
                versionId = "V1.0";
            }
            for (String compatibleVersion : OMAGServerConfig.COMPATIBLE_VERSIONS) {
                if (!compatibleVersion.equals(versionId)) continue;
                isCompatibleVersion = true;
            }
            if (!isCompatibleVersion) {
                OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.INCOMPATIBLE_CONFIG_FILE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, versionId, OMAGServerConfig.COMPATIBLE_VERSIONS.toString()});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            try {
                OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
                securityVerifier.registerSecurityValidator(serverConfig.getLocalServerUserId(), serverName, null, serverConfig.getServerSecurityConnection());
                securityVerifier.validateUserAsServerAdmin(userId);
            }
            catch (InvalidParameterException error) {
                throw new OMAGInvalidParameterException(error);
            }
            catch (UserNotAuthorizedException error) {
                throw new OMAGNotAuthorizedException(error);
            }
        }
        serverConfig.setLocalServerName(serverName);
        return serverConfig;
    }

    void saveServerConfig(String serverName, String methodName, OMAGServerConfig serverConfig) throws OMAGInvalidParameterException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        if (serverConfigStore != null) {
            if (serverConfig != null) {
                serverConfigStore.saveServerConfig(serverConfig);
            } else {
                serverConfigStore.removeServerConfig();
            }
        }
    }
}

