/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class OMAGServerExceptionHandler
extends RESTExceptionHandler {
    public void captureRuntimeException(String serverName, String methodName, FFDCResponseBase response, Throwable runtimeException) {
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.UNEXPECTED_EXCEPTION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, runtimeException.getClass().getName(), runtimeException.getMessage()});
        OMAGConfigurationErrorException error = new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), runtimeException);
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    public void captureRuntimeException(String methodName, FFDCResponseBase response, Throwable runtimeException) {
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.UNEXPECTED_PLATFORM_EXCEPTION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, runtimeException.getClass().getName(), runtimeException.getMessage()});
        OMAGConfigurationErrorException error = new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), runtimeException);
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    public void captureConfigurationErrorException(FFDCResponseBase response, OMAGConfigurationErrorException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    void captureInvalidParameterException(FFDCResponseBase response, OMAGInvalidParameterException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    public void captureNotAuthorizedException(FFDCResponseBase response, OMAGNotAuthorizedException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    void captureNotAuthorizedException(FFDCResponseBase response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }
}

