/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.VirtualizationConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGServerVirtualizationService {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private static final String defaultOutTopicName = "OutTopic";
    private static final String defaultInTopicName = "InTopic";
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public VoidResponse setVirtualizerConfig(String userId, String serverName, VirtualizationConfig virtualizationConfig) {
        String methodName = "setVirtualizationConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            EventBusConfig eventBusConfig = serverConfig.getEventBusConfig();
            virtualizationConfig.setVirtualizerInboundTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultOutTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, virtualizationConfig.getVirtualizerInboundTopicName(), UUID.randomUUID().toString(), eventBusConfig.getConfigurationProperties()));
            virtualizationConfig.setVirtualizerOutboundTopic(connectorConfigurationFactory.getDefaultEventBusConnection(defaultInTopicName, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, virtualizationConfig.getVirtualizerOutboundTopicName(), UUID.randomUUID().toString(), eventBusConfig.getConfigurationProperties()));
            virtualizationConfig.setVirtualizationSolutionConnection(connectorConfigurationFactory.getVirtualizationSolutionConnection(serverName, virtualizationConfig.getVirtualizationProvider(), virtualizationConfig.getVirtualizationSolutionConfig()));
            serverConfig.setVirtualizationConfig(virtualizationConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse enableVirtualizationService(String userId, String serverName) {
        String methodName = "enableVirtualizationService";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "enableVirtualizationService");
            this.errorHandler.validateUserId(userId, serverName, "enableVirtualizationService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableVirtualizationService");
            VirtualizationConfig virtualizationConfig = serverConfig.getVirtualizationConfig();
            this.setVirtualizerConfig(userId, serverName, virtualizationConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "enableVirtualizationService", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

