/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecurityOfficerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

public class OMAGServerSecurityOfficerService {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private static final String defaultOutTopicName = "OutTopic";
    private static final String defaultInTopicName = "open-metadata.access-services.SecurityOfficer.outTopic";
    private static final String outputTopic = "open-metadata.security-officer-server.";
    private static final String defaultOutTopic = ".outTopic";

    public VoidResponse setSecurityOfficerConfig(String userId, String serverName, SecurityOfficerConfig securityOfficerConfig) {
        String methodName = "setSecurityOfficerConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (securityOfficerConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for Security Officer Service.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for Security Officer Service.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            EventBusConfig eventBusConfig = serverConfig.getEventBusConfig();
            if (securityOfficerConfig != null && securityOfficerConfig.getSecurityOfficerServerInTopicName() != null) {
                securityOfficerConfig.setSecurityOfficerServerInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, securityOfficerConfig.getSecurityOfficerServerInTopicName(), UUID.randomUUID().toString(), eventBusConfig.getConfigurationProperties()));
            }
            if (securityOfficerConfig != null) {
                securityOfficerConfig.setSecurityOfficerServerOutTopic(connectorConfigurationFactory.getDefaultEventBusConnection(eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, this.getOutputTopicName(securityOfficerConfig.getSecurityOfficerServerOutTopicName()), serverConfig.getLocalServerId(), eventBusConfig.getConfigurationProperties()));
            }
            serverConfig.setSecurityOfficerConfig(securityOfficerConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }

    private String getOutputTopicName(String securityServerType) {
        if (securityServerType != null) {
            return outputTopic + securityServerType + defaultOutTopic;
        }
        return "open-metadata.security-officer-server.SecurityOfficerServer.outTopic";
    }

    public VoidResponse enableSecurityOfficerService(String userId, String serverName) {
        String methodName = "enableSecurityOfficerService";
        VoidResponse response = new VoidResponse();
        try {
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableSecurityOfficerService");
            SecurityOfficerConfig securityOfficerConfig = serverConfig.getSecurityOfficerConfig();
            this.setSecurityOfficerConfig(userId, serverName, securityOfficerConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "enableSecurityOfficerService", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

