/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.classifier;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.ConformanceSuiteConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataPlatformServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryEngineServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryMode;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecurityOfficerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.StewardshipEngineServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.VirtualizationConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;

public class ServerTypeClassifier {
    private static final String ACCESS_SERVICES_NAME = "Open Metadata Access Services (OMAS)";
    private static final String VIEW_SERVICES_NAME = "Open Metadata View Services (OMVS)";
    private OMAGServerConfig configurationDocument;
    private String serverName;

    public ServerTypeClassifier(String serverName, OMAGServerConfig configurationDocument) {
        this.configurationDocument = configurationDocument;
        this.serverName = serverName;
    }

    public ServerTypeClassification getServerType() throws OMAGInvalidParameterException, OMAGConfigurationErrorException {
        LocalRepositoryMode localRepositoryMode;
        String methodName = "getServerType";
        ServerTypeClassification serverTypeClassification = null;
        this.validateConfigurationDocumentNotNull(this.serverName, this.configurationDocument, "getServerType");
        RepositoryServicesConfig repositoryServicesConfig = this.configurationDocument.getRepositoryServicesConfig();
        List accessServiceConfigList = this.configurationDocument.getAccessServicesConfig();
        List viewServiceConfigList = this.configurationDocument.getViewServicesConfig();
        ConformanceSuiteConfig conformanceSuiteConfig = this.configurationDocument.getConformanceSuiteConfig();
        DiscoveryEngineServicesConfig discoveryEngineServicesConfig = this.configurationDocument.getDiscoveryEngineServicesConfig();
        OpenLineageServerConfig openLineageServerConfig = this.configurationDocument.getOpenLineageServerConfig();
        SecuritySyncConfig securitySyncConfig = this.configurationDocument.getSecuritySyncConfig();
        SecurityOfficerConfig securityOfficerConfig = this.configurationDocument.getSecurityOfficerConfig();
        StewardshipEngineServicesConfig stewardshipEngineServicesConfig = this.configurationDocument.getStewardshipEngineServicesConfig();
        VirtualizationConfig virtualizationConfig = this.configurationDocument.getVirtualizationConfig();
        DataEngineProxyConfig dataEngineProxyConfig = this.configurationDocument.getDataEngineProxyConfig();
        DataPlatformServicesConfig dataPlatformServicesConfig = this.configurationDocument.getDataPlatformServicesConfig();
        if (repositoryServicesConfig == null && accessServiceConfigList == null && viewServiceConfigList == null && conformanceSuiteConfig == null && discoveryEngineServicesConfig == null && openLineageServerConfig == null && securitySyncConfig == null && securityOfficerConfig == null && stewardshipEngineServicesConfig == null && virtualizationConfig == null && dataEngineProxyConfig == null && dataPlatformServicesConfig == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.EMPTY_CONFIGURATION.getMessageDefinition(new String[]{this.serverName}), this.getClass().getName(), "getServerType");
        }
        if (repositoryServicesConfig == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.NULL_REPOSITORY_CONFIG.getMessageDefinition(new String[]{this.serverName}), this.getClass().getName(), "getServerType");
        }
        if (accessServiceConfigList != null) {
            localRepositoryMode = this.detectLocalRepository(repositoryServicesConfig);
            serverTypeClassification = localRepositoryMode == LocalRepositoryMode.OPEN_METADATA_NATIVE ? ServerTypeClassification.METADATA_SERVER : (localRepositoryMode == LocalRepositoryMode.REPOSITORY_PROXY ? ServerTypeClassification.METADATA_SERVER : ServerTypeClassification.METADATA_ACCESS_POINT);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
        }
        if (conformanceSuiteConfig != null) {
            serverTypeClassification = ServerTypeClassification.CONFORMANCE_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (dataEngineProxyConfig != null) {
            serverTypeClassification = ServerTypeClassification.DATA_ENGINE_PROXY;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (dataPlatformServicesConfig != null) {
            serverTypeClassification = ServerTypeClassification.DATA_PLATFORM_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (discoveryEngineServicesConfig != null) {
            serverTypeClassification = ServerTypeClassification.DISCOVERY_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (openLineageServerConfig != null) {
            serverTypeClassification = ServerTypeClassification.OPEN_LINEAGE_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (securitySyncConfig != null) {
            serverTypeClassification = ServerTypeClassification.SECURITY_SYNC_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (securityOfficerConfig != null) {
            serverTypeClassification = ServerTypeClassification.SECURITY_OFFICER_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (stewardshipEngineServicesConfig != null) {
            serverTypeClassification = ServerTypeClassification.STEWARDSHIP_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (virtualizationConfig != null) {
            serverTypeClassification = ServerTypeClassification.VIRTUALIZER_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
        }
        if (viewServiceConfigList != null) {
            serverTypeClassification = ServerTypeClassification.VIEW_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_PLATFORM_SERVICES.getServiceName(), dataPlatformServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), discoveryEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_SYNC_SERVICES.getServiceName(), securitySyncConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.SECURITY_OFFICER_SERVICES.getServiceName(), securityOfficerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName(), stewardshipEngineServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.VIRTUALIZATION_SERVICES.getServiceName(), virtualizationConfig);
        }
        if (serverTypeClassification == null) {
            localRepositoryMode = this.detectLocalRepository(repositoryServicesConfig);
            serverTypeClassification = localRepositoryMode == LocalRepositoryMode.METADATA_CACHE ? ServerTypeClassification.METADATA_ACCESS_POINT : (localRepositoryMode == LocalRepositoryMode.OPEN_METADATA_NATIVE ? ServerTypeClassification.METADATA_SERVER : ServerTypeClassification.REPOSITORY_PROXY);
        }
        this.validateServerClassificationNotNull(this.serverName, serverTypeClassification, "getServerType");
        return serverTypeClassification;
    }

    private void validateConfigurationDocumentNotNull(String serverName, OMAGServerConfig configurationDocument, String methodName) throws OMAGInvalidParameterException {
        if (configurationDocument == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_SERVER_CONFIG.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    private void validateServerClassificationNotNull(String serverName, ServerTypeClassification serverTypeClassification, String methodName) throws OMAGInvalidParameterException {
        if (serverTypeClassification == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.UNCLASSIFIABLE_SERVER.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    private LocalRepositoryMode detectLocalRepository(RepositoryServicesConfig repositoryServicesConfig) {
        LocalRepositoryConfig localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
        if (localRepositoryConfig == null) {
            return LocalRepositoryMode.NO_REPOSITORY;
        }
        LocalRepositoryMode localRepositoryMode = localRepositoryConfig.getLocalRepositoryMode();
        if (localRepositoryMode == null) {
            return LocalRepositoryMode.UNCLASSIFIED;
        }
        return localRepositoryMode;
    }

    private void validateSubsystemNotConfigured(String serverName, String serverTypeName, String subsystemName, Object subsystemConfig) throws OMAGConfigurationErrorException {
        String methodName = "validateSubsystemNotConfigured";
        if (subsystemConfig != null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.INCOMPATIBLE_SUBSYSTEMS.getMessageDefinition(new String[]{serverName, serverTypeName, subsystemName}), this.getClass().getName(), "validateSubsystemNotConfigured");
        }
    }
}

