/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.StewardshipEngineServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.StewardshipEngineServicesConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.slf4j.LoggerFactory;

public class OMAGServerConfigStewardshipEngineServices {
    private static final String serviceName = GovernanceServicesDescription.STEWARDSHIP_SERVICES.getServiceName();
    private static final String accessService = AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceName();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerConfigStewardshipEngineServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setClientConfig(String userId, String serverName, OMAGServerClientConfig clientConfig) {
        String methodName = "setClientConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setClientConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setClientConfig");
            this.errorHandler.validateUserId(userId, serverName, "setClientConfig");
            String accessServiceRootURL = null;
            String accessServiceServerName = null;
            if (clientConfig != null) {
                accessServiceRootURL = clientConfig.getOMAGServerPlatformRootURL();
                accessServiceServerName = clientConfig.getOMAGServerName();
            }
            this.errorHandler.validateAccessServiceRootURL(accessServiceRootURL, accessService, serverName, serviceName);
            this.errorHandler.validateAccessServiceServerName(accessServiceServerName, accessService, serverName, serviceName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setClientConfig");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (accessServiceRootURL == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " access service root url.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " access service root url to " + accessServiceRootURL + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            StewardshipEngineServicesConfig stewardshipEngineServicesConfig = serverConfig.getStewardshipEngineServicesConfig();
            if (stewardshipEngineServicesConfig == null) {
                stewardshipEngineServicesConfig = new StewardshipEngineServicesConfig();
            }
            stewardshipEngineServicesConfig.setOMAGServerPlatformRootURL(accessServiceRootURL);
            stewardshipEngineServicesConfig.setOMAGServerName(accessServiceServerName);
            serverConfig.setStewardshipEngineServicesConfig(stewardshipEngineServicesConfig);
            this.configStore.saveServerConfig(serverName, "setClientConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setClientConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setStewardshipEngines(String userId, String serverName, List<String> stewardshipEngineNames) {
        String methodName = "setStewardshipEngines";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setStewardshipEngines");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setStewardshipEngines");
            this.errorHandler.validateUserId(userId, serverName, "setStewardshipEngines");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setStewardshipEngines");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (stewardshipEngineNames == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " inbound request stewardshipEngineNames.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " inbound request stewardshipEngineNames.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            StewardshipEngineServicesConfig stewardshipEngineServicesConfig = serverConfig.getStewardshipEngineServicesConfig();
            if (stewardshipEngineServicesConfig == null) {
                stewardshipEngineServicesConfig = new StewardshipEngineServicesConfig();
            }
            stewardshipEngineServicesConfig.setStewardshipEngineNames(stewardshipEngineNames);
            serverConfig.setStewardshipEngineServicesConfig(stewardshipEngineServicesConfig);
            this.configStore.saveServerConfig(serverName, "setStewardshipEngines", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setStewardshipEngines", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setStewardshipEngineServicesConfig(String userId, String serverName, StewardshipEngineServicesConfig servicesConfig) {
        String methodName = "addService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addService");
        VoidResponse response = new VoidResponse();
        try {
            this.setClientConfig(userId, serverName, (OMAGServerClientConfig)servicesConfig);
            this.setStewardshipEngines(userId, serverName, servicesConfig.getStewardshipEngineNames());
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StewardshipEngineServicesConfigResponse getStewardshipEngineServicesConfig(String userId, String serverName) {
        String methodName = "addService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addService");
        StewardshipEngineServicesConfigResponse response = new StewardshipEngineServicesConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addService");
            this.errorHandler.validateUserId(userId, serverName, "addService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addService");
            if (serverConfig != null) {
                response.setConfig(serverConfig.getStewardshipEngineServicesConfig());
            }
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearStewardshipEngineServicesConfig(String userId, String serverName) {
        String methodName = "deleteService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deleteService");
            this.errorHandler.validateUserId(userId, serverName, "deleteService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "deleteService");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setStewardshipEngineServicesConfig(null);
            this.configStore.saveServerConfig(serverName, "deleteService", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "deleteService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

