/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.DataPlatformServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGServerDataPlatformService {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private static final String defaultDataPlatformInTopicName = "omas.dataplatform.inTopic";
    private static final String defaultInTopicName = "InTopic";
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public VoidResponse setDataPlatformServiceConfig(String userId, String serverName, DataPlatformServicesConfig dataPlatformServicesConfig) {
        String methodName = "setDataPlatformServiceConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            EventBusConfig eventBusConfig = serverConfig.getEventBusConfig();
            if (dataPlatformServicesConfig.getDataPlatformOmasInTopicName() == null) {
                dataPlatformServicesConfig.setDataPlatformOmasInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, defaultDataPlatformInTopicName, UUID.randomUUID().toString(), eventBusConfig.getConfigurationProperties()));
                dataPlatformServicesConfig.setDataPlatformOmasInTopicName(dataPlatformServicesConfig.getDataPlatformOmasInTopic().getEndpoint().getAddress());
            } else {
                dataPlatformServicesConfig.setDataPlatformOmasInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, dataPlatformServicesConfig.getDataPlatformOmasInTopicName(), UUID.randomUUID().toString(), eventBusConfig.getConfigurationProperties()));
            }
            serverConfig.setDataPlatformServicesConfig(dataPlatformServicesConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse enableDataPlatformService(String userId, String serverName) {
        String methodName = "enableDataPlatformService";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "enableDataPlatformService");
            this.errorHandler.validateUserId(userId, serverName, "enableDataPlatformService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "enableDataPlatformService");
            DataPlatformServicesConfig dataPlatformServicesConfig = serverConfig.getDataPlatformServicesConfig();
            this.setDataPlatformServiceConfig(userId, serverName, dataPlatformServicesConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "enableDataPlatformService", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

