/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.OMAGViewServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SolutionViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistration;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForViewServices {
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForViewServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public RegisteredOMAGServicesResponse getConfiguredViewServices(String userId, String serverName) {
        String methodName = "getConfiguredViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfiguredViewServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getConfiguredViewServices");
            this.errorHandler.validateUserId(userId, serverName, "getConfiguredViewServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getConfiguredViewServices");
            List viewServiceConfigList = serverConfig.getViewServicesConfig();
            if (viewServiceConfigList != null && !viewServiceConfigList.isEmpty()) {
                ArrayList<RegisteredOMAGService> services = new ArrayList<RegisteredOMAGService>();
                for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                    if (viewServiceConfig == null || viewServiceConfig.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceName(viewServiceConfig.getViewServiceFullName());
                    service.setServiceDescription(viewServiceConfig.getViewServiceDescription());
                    service.setServiceURLMarker(viewServiceConfig.getViewServiceURLMarker());
                    service.setServiceWiki(viewServiceConfig.getViewServiceWiki());
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getConfiguredViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ViewServicesResponse getViewServices(String userId, String serverName) {
        String methodName = "getConfiguredViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfiguredViewServices");
        ViewServicesResponse response = new ViewServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getConfiguredViewServices");
            this.errorHandler.validateUserId(userId, serverName, "getConfiguredViewServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getConfiguredViewServices");
            List viewServiceConfigList = serverConfig.getViewServicesConfig();
            if (viewServiceConfigList != null && !viewServiceConfigList.isEmpty()) {
                ArrayList<ViewServiceConfig> services = new ArrayList<ViewServiceConfig>();
                for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                    if (viewServiceConfig == null || viewServiceConfig.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    services.add(viewServiceConfig);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getConfiguredViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureViewService(String userId, String serverName, String serviceURLMarker, ViewServiceConfig requestedViewServiceConfig) {
        String methodName = "configureViewService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureViewService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureViewService");
            this.errorHandler.validateUserId(userId, serverName, "configureViewService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureViewService");
            List<ViewServiceConfig> viewServiceConfigList = serverConfig.getViewServicesConfig();
            ViewServiceRegistration viewServiceRegistration = OMAGViewServiceRegistration.getViewServiceRegistration((String)serviceURLMarker);
            this.errorHandler.validateViewServiceIsRegistered(viewServiceRegistration, serviceURLMarker, serverName, "configureViewService");
            ViewServiceConfig viewServiceConfig = this.createViewServiceConfig(viewServiceRegistration, requestedViewServiceConfig);
            viewServiceConfigList = this.updateViewServiceConfig(viewServiceConfig, viewServiceConfigList);
            this.setViewServicesConfig(userId, serverName, viewServiceConfigList);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureViewService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAllViewServices(String userId, String serverName, ViewServiceConfig requestedViewServiceConfig) {
        String methodName = "configureViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureViewServices");
        VoidResponse response = new VoidResponse();
        OMAGServerConfig serverConfig = null;
        try {
            serverConfig = this.configStore.getServerConfig(userId, serverName, "configureViewServices");
            ArrayList<ViewServiceConfig> viewServiceConfigList = new ArrayList<ViewServiceConfig>();
            List viewServiceRegistrationList = OMAGViewServiceRegistration.getViewServiceRegistrationList();
            if (viewServiceRegistrationList != null && !viewServiceRegistrationList.isEmpty()) {
                for (ViewServiceRegistration registration : viewServiceRegistrationList) {
                    if (registration == null || registration.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    viewServiceConfigList.add(this.createViewServiceConfig(registration, requestedViewServiceConfig));
                }
            }
            if (viewServiceConfigList.isEmpty()) {
                viewServiceConfigList = null;
            }
            this.setViewServicesConfig(userId, serverName, viewServiceConfigList);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private ViewServiceConfig createViewServiceConfig(ViewServiceRegistration registration, ViewServiceConfig requestedViewServiceConfig) {
        IntegrationViewServiceConfig viewServiceConfig = null;
        if (requestedViewServiceConfig instanceof IntegrationViewServiceConfig) {
            IntegrationViewServiceConfig requestedIntegrationViewServiceConfig = (IntegrationViewServiceConfig)requestedViewServiceConfig;
            IntegrationViewServiceConfig createdViewServiceConfig = new IntegrationViewServiceConfig(registration);
            createdViewServiceConfig.setResourceEndpoints(requestedIntegrationViewServiceConfig.getResourceEndpoints());
            viewServiceConfig = createdViewServiceConfig;
        } else if (requestedViewServiceConfig instanceof SolutionViewServiceConfig) {
            SolutionViewServiceConfig requestedSolutionViewServiceConfig = (SolutionViewServiceConfig)requestedViewServiceConfig;
            SolutionViewServiceConfig createdViewServiceConfig = new SolutionViewServiceConfig(registration);
            createdViewServiceConfig.setOMAGServerPlatformRootURL(requestedSolutionViewServiceConfig.getOMAGServerPlatformRootURL());
            createdViewServiceConfig.setOMAGServerName(requestedSolutionViewServiceConfig.getOMAGServerName());
            viewServiceConfig = createdViewServiceConfig;
        } else {
            ViewServiceConfig createdViewServiceConfig = new ViewServiceConfig(registration);
            createdViewServiceConfig.setOMAGServerPlatformRootURL(requestedViewServiceConfig.getOMAGServerPlatformRootURL());
            createdViewServiceConfig.setOMAGServerName(requestedViewServiceConfig.getOMAGServerName());
            viewServiceConfig = createdViewServiceConfig;
        }
        Map viewOptions = requestedViewServiceConfig.getViewServiceOptions();
        viewServiceConfig.setViewServiceOptions(viewOptions);
        return viewServiceConfig;
    }

    private List<ViewServiceConfig> updateViewServiceConfig(ViewServiceConfig viewServiceConfig, List<ViewServiceConfig> currentList) {
        if (viewServiceConfig == null) {
            return currentList;
        }
        ArrayList<ViewServiceConfig> newList = new ArrayList<ViewServiceConfig>();
        if (currentList != null) {
            for (ViewServiceConfig existingConfig : currentList) {
                if (existingConfig == null || viewServiceConfig.getViewServiceId() == existingConfig.getViewServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(viewServiceConfig);
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    public VoidResponse clearAllViewServices(String userId, String serverName) {
        String methodName = "disableViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "disableViewServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "disableViewServices");
            this.errorHandler.validateUserId(userId, serverName, "disableViewServices");
            this.setViewServicesConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "disableViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setViewServicesConfig(String userId, String serverName, List<ViewServiceConfig> viewServicesConfig) {
        String methodName = "setViewServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setViewServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setViewServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "setViewServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setViewServicesConfig");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (viewServicesConfig == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for view services.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for view services.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setViewServicesConfig(viewServicesConfig);
            this.configStore.saveServerConfig(serverName, "setViewServicesConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setViewServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

