/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.PlatformSecurityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminSecurityServices {
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminSecurityServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();

    public synchronized VoidResponse setPlatformSecurityConnection(String userId, PlatformSecurityRequestBody requestBody) {
        String methodName = "setPlatformSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "setPlatformSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            if (requestBody == null) {
                this.exceptionHandler.handleNoRequestBody(userId, "setPlatformSecurityConnection", "<null>");
            } else {
                this.errorHandler.validateConnection(requestBody.getPlatformSecurityConnection(), "setPlatformSecurityConnection");
                OpenMetadataPlatformSecurityVerifier.setPlatformSecurityConnection((String)userId, (String)requestBody.getUrlRoot(), (Connection)requestBody.getPlatformSecurityConnection());
            }
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException("setPlatformSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized ConnectionResponse getPlatformSecurityConnection(String userId) {
        String methodName = "getPlatformSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "getPlatformSecurityConnection");
        ConnectionResponse response = new ConnectionResponse();
        try {
            response.setConnection(OpenMetadataPlatformSecurityVerifier.getPlatformSecurityConnection((String)userId));
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException("getPlatformSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearPlatformSecurityConnection(String userId) {
        String methodName = "clearPlatformSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "clearPlatformSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.clearPlatformSecurityConnection((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearPlatformSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse setServerSecurityConnection(String userId, String serverName, Connection connection) {
        String methodName = "setServerSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setServerSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setServerSecurityConnection");
            this.errorHandler.validateUserId(userId, serverName, "setServerSecurityConnection");
            this.errorHandler.validateConnection(connection, serverName, "setServerSecurityConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerSecurityConnection");
            serverConfig.setServerSecurityConnection(connection);
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " added configuration for an Open Metadata Server Security Connector");
            serverConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "setServerSecurityConnection", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException("setServerSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized ConnectionResponse getServerSecurityConnection(String userId, String serverName) {
        String methodName = "getServerSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerSecurityConnection");
        ConnectionResponse response = new ConnectionResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getServerSecurityConnection");
            this.errorHandler.validateUserId(userId, serverName, "getServerSecurityConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getServerSecurityConnection");
            response.setConnection(serverConfig.getServerSecurityConnection());
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException("getServerSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearServerSecurityConnection(String userId, String serverName) {
        String methodName = "clearServerSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearServerSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearServerSecurityConnection");
            this.errorHandler.validateUserId(userId, serverName, "clearServerSecurityConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearServerSecurityConnection");
            serverConfig.setServerSecurityConnection(null);
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for an Open Metadata Server Security Connector");
            serverConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "clearServerSecurityConnection", serverConfig);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearServerSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

