/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

public class OMAGServerDataEngineProxyService {
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setDataEngineProxyConfig(String userId, String serverName, DataEngineProxyConfig dataEngineProxyConfig) {
        String methodName = "setDataEngineProxyConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setDataEngineProxyConfig");
            this.errorHandler.validateUserId(userId, serverName, "setDataEngineProxyConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setDataEngineProxyConfig");
            serverConfig.setDataEngineProxyConfig(dataEngineProxyConfig);
            this.configStore.saveServerConfig(serverName, "setDataEngineProxyConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setDataEngineProxyConfig", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse deleteDataEngineProxy(String userId, String serverName) {
        String methodName = "deleteDataEngineProxy";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deleteDataEngineProxy");
            this.errorHandler.validateUserId(userId, serverName, "deleteDataEngineProxy");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "deleteDataEngineProxy");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serverName + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setDataEngineProxyConfig(null);
            this.configStore.saveServerConfig(serverName, "deleteDataEngineProxy", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "deleteDataEngineProxy", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

