/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryEngineServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.DiscoveryEngineServicesConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.slf4j.LoggerFactory;

public class OMAGServerConfigDiscoveryEngineServices {
    private static final String serviceName = GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName();
    private static final String accessService = AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceName();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerConfigDiscoveryEngineServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setClientConfig(String userId, String serverName, OMAGServerClientConfig clientConfig) {
        String methodName = "setClientConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setClientConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setClientConfig");
            this.errorHandler.validateUserId(userId, serverName, "setClientConfig");
            String accessServiceRootURL = null;
            String accessServiceServerName = null;
            if (clientConfig != null) {
                accessServiceRootURL = clientConfig.getOMAGServerPlatformRootURL();
                accessServiceServerName = clientConfig.getOMAGServerName();
            }
            this.errorHandler.validateAccessServiceRootURL(accessServiceRootURL, accessService, serverName, serviceName);
            this.errorHandler.validateAccessServiceServerName(accessServiceServerName, accessService, serverName, serviceName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setClientConfig");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (accessServiceRootURL == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " access service root url.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " access service root url to " + accessServiceRootURL + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            DiscoveryEngineServicesConfig discoveryEngineServicesConfig = serverConfig.getDiscoveryEngineServicesConfig();
            if (discoveryEngineServicesConfig == null) {
                discoveryEngineServicesConfig = new DiscoveryEngineServicesConfig();
            }
            discoveryEngineServicesConfig.setOMAGServerPlatformRootURL(accessServiceRootURL);
            discoveryEngineServicesConfig.setOMAGServerName(accessServiceServerName);
            serverConfig.setDiscoveryEngineServicesConfig(discoveryEngineServicesConfig);
            this.configStore.saveServerConfig(serverName, "setClientConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setClientConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setDiscoveryEngines(String userId, String serverName, List<String> discoveryEngineNames) {
        String methodName = "setDiscoveryEngines";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setDiscoveryEngines");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setDiscoveryEngines");
            this.errorHandler.validateUserId(userId, serverName, "setDiscoveryEngines");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setDiscoveryEngines");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if (discoveryEngineNames == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + " inbound request discoveryEngineNames.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for " + serviceName + " inbound request discoveryEngineNames.");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            DiscoveryEngineServicesConfig discoveryEngineServicesConfig = serverConfig.getDiscoveryEngineServicesConfig();
            if (discoveryEngineServicesConfig == null) {
                discoveryEngineServicesConfig = new DiscoveryEngineServicesConfig();
            }
            discoveryEngineServicesConfig.setDiscoveryEngineNames(discoveryEngineNames);
            serverConfig.setDiscoveryEngineServicesConfig(discoveryEngineServicesConfig);
            this.configStore.saveServerConfig(serverName, "setDiscoveryEngines", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setDiscoveryEngines", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setDiscoveryEngineServicesConfig(String userId, String serverName, DiscoveryEngineServicesConfig servicesConfig) {
        String methodName = "setDiscoveryEngineServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setDiscoveryEngineServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.setClientConfig(userId, serverName, (OMAGServerClientConfig)servicesConfig);
            this.setDiscoveryEngines(userId, serverName, servicesConfig.getDiscoveryEngineNames());
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setDiscoveryEngineServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryEngineServicesConfigResponse getDiscoveryEngineServicesConfig(String userId, String serverName) {
        String methodName = "getDiscoveryEngineServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryEngineServicesConfig");
        DiscoveryEngineServicesConfigResponse response = new DiscoveryEngineServicesConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getDiscoveryEngineServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "getDiscoveryEngineServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getDiscoveryEngineServicesConfig");
            if (serverConfig != null) {
                response.setConfig(serverConfig.getDiscoveryEngineServicesConfig());
            }
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getDiscoveryEngineServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearDiscoveryEngineServicesConfig(String userId, String serverName) {
        String methodName = "clearDiscoveryEngineServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearDiscoveryEngineServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearDiscoveryEngineServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "clearDiscoveryEngineServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearDiscoveryEngineServicesConfig");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for " + serviceName + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setDiscoveryEngineServicesConfig(null);
            this.configStore.saveServerConfig(serverName, "clearDiscoveryEngineServicesConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearDiscoveryEngineServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

