/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.classifier.ServerTypeClassifier;
import org.odpi.openmetadata.adminservices.client.ConfigurationManagementClient;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortTopicStructure;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryMode;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.properties.DedicatedTopicList;
import org.odpi.openmetadata.adminservices.rest.CohortConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ConnectionListResponse;
import org.odpi.openmetadata.adminservices.rest.DedicatedTopicListResponse;
import org.odpi.openmetadata.adminservices.rest.EventBusConfigResponse;
import org.odpi.openmetadata.adminservices.rest.LocalRepositoryConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigsResponse;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationResponse;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationSummary;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminServices {
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public ServerTypeClassificationResponse getServerTypeClassification(String userId, String serverName) {
        String methodName = "getServerTypeClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerTypeClassification");
        ServerTypeClassificationResponse response = new ServerTypeClassificationResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getServerTypeClassification");
            this.errorHandler.validateUserId(userId, serverName, "getServerTypeClassification");
            ServerTypeClassifier classifier = new ServerTypeClassifier(serverName, this.configStore.getServerConfig(userId, serverName, "getServerTypeClassification"));
            ServerTypeClassificationSummary summary = new ServerTypeClassificationSummary(classifier.getServerType());
            response.setServerTypeClassification(summary);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getServerTypeClassification", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setServerType(String userId, String serverName, String typeName) {
        String methodName = "setServerType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setServerType");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setServerType");
            this.errorHandler.validateUserId(userId, serverName, "setServerType");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerType");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (typeName != null && typeName.length() == 0) {
                typeName = null;
            }
            if (typeName == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for local server type name.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for local server type name to " + typeName + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerType(typeName);
            this.configStore.saveServerConfig(serverName, "setServerType", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setServerType", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setOrganizationName(String userId, String serverName, String name) {
        String methodName = "setOrganizationName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setOrganizationName");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOrganizationName");
            this.errorHandler.validateUserId(userId, serverName, "setOrganizationName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setOrganizationName");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (name != null && name.length() == 0) {
                name = null;
            }
            if (name == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for local server's owning organization's name.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for local server's owning organization's name to " + name + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setOrganizationName(name);
            this.configStore.saveServerConfig(serverName, "setOrganizationName", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setOrganizationName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setServerUserId(String userId, String serverName, String serverUserId) {
        String methodName = "setServerUserId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setServerUserId");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerUserId");
            this.errorHandler.validateServerName(serverName, "setServerUserId");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerUserId");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (serverUserId != null && serverUserId.length() == 0) {
                serverUserId = null;
            }
            if (serverUserId == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for local server's userId.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for local server's userId to " + serverUserId + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerUserId(serverUserId);
            this.configStore.saveServerConfig(serverName, "setServerUserId", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setServerUserId", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setServerPassword(String userId, String serverName, String serverPassword) {
        String methodName = "setServerPassword";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setServerPassword");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerPassword");
            this.errorHandler.validateServerName(serverName, "setServerPassword");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerPassword");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (serverPassword != null && serverPassword.length() == 0) {
                serverPassword = null;
            }
            if (serverPassword == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for local server's password.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for local server's password to " + serverPassword + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerPassword(serverPassword);
            this.configStore.saveServerConfig(serverName, "setServerPassword", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setServerPassword", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setMaxPageSize(String userId, String serverName, int maxPageSize) {
        String methodName = "setMaxPageSize";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setMaxPageSize");
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<CallSite> configAuditTrail;
            OMAGServerConfig serverConfig;
            this.errorHandler.validateServerName(serverName, "setMaxPageSize");
            this.errorHandler.validateUserId(userId, serverName, "setMaxPageSize");
            if (maxPageSize >= 0) {
                serverConfig = this.configStore.getServerConfig(userId, serverName, "setMaxPageSize");
                configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<CallSite>();
                }
            } else {
                throw new OMAGInvalidParameterException(OMAGAdminErrorCode.BAD_MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName, Integer.toString(maxPageSize)}), this.getClass().getName(), "setMaxPageSize");
            }
            configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for maximum page size to " + maxPageSize + ".")));
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setMaxPageSize(maxPageSize);
            this.configStore.saveServerConfig(serverName, "setMaxPageSize", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setMaxPageSize", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setEventBus(String userId, String serverName, String connectorProvider, String topicURLRoot, Map<String, Object> configurationProperties) {
        String methodName = "setEventBus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEventBus");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEventBus");
            this.errorHandler.validateUserId(userId, serverName, "setEventBus");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setEventBus");
            EventBusConfig eventBusConfig = new EventBusConfig();
            if (connectorProvider != null && connectorProvider.length() == 0) {
                eventBusConfig.setConnectorProvider(null);
            } else {
                eventBusConfig.setConnectorProvider(connectorProvider);
            }
            if (topicURLRoot != null && topicURLRoot.length() == 0) {
                eventBusConfig.setTopicURLRoot(null);
            } else {
                eventBusConfig.setTopicURLRoot(topicURLRoot);
            }
            if (configurationProperties == null || configurationProperties.isEmpty()) {
                eventBusConfig.setConfigurationProperties(configurationProperties);
            } else {
                eventBusConfig.setConfigurationProperties(configurationProperties);
            }
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for default event bus.")));
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setEventBusConfig(eventBusConfig);
            this.configStore.saveServerConfig(serverName, "setEventBus", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setEventBus", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EventBusConfigResponse getEventBus(String userId, String serverName) {
        String methodName = "getEventBus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEventBus");
        EventBusConfigResponse response = new EventBusConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getEventBus");
            this.errorHandler.validateUserId(userId, serverName, "getEventBus");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getEventBus");
            if (this.configStore != null) {
                response.setConfig(serverConfig.getEventBusConfig());
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getEventBus", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteEventBus(String userId, String serverName) {
        String methodName = "deleteEventBus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteEventBus");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deleteEventBus");
            this.errorHandler.validateUserId(userId, serverName, "deleteEventBus");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "deleteEventBus");
            if (this.configStore != null) {
                ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<CallSite>();
                }
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " deleted configuration for default event bus.")));
                serverConfig.setAuditTrail(configAuditTrail);
                serverConfig.setEventBusConfig(null);
                this.configStore.saveServerConfig(serverName, "deleteEventBus", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "deleteEventBus", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    @Deprecated
    public VoidResponse setServerURLRoot(String userId, String serverName, String url) {
        String methodName = "setServerURLRoot";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setServerURLRoot");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerURLRoot");
            this.errorHandler.validateServerName(serverName, "setServerURLRoot");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerURLRoot");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (url != null && url.length() == 0) {
                url = null;
            }
            if (url == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for local server's URL root.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for local server's URL root to " + url + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerURL(url);
            this.configStore.saveServerConfig(serverName, "setServerURLRoot", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setServerURLRoot", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setServerRootURL(String userId, String serverName, URLRequestBody requestBody) {
        String methodName = "setServerURLRoot";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setServerURLRoot");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setServerURLRoot");
            this.errorHandler.validateServerName(serverName, "setServerURLRoot");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerURLRoot");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            String urlRoot = null;
            if (requestBody != null) {
                urlRoot = requestBody.getUrlRoot();
            }
            if (urlRoot == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for local server's URL root.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for local server's URL root to " + urlRoot + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerURL(urlRoot);
            this.configStore.saveServerConfig(serverName, "setServerURLRoot", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setServerURLRoot", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setDefaultAuditLog(String userId, String serverName, NullRequestBody requestBody) {
        String methodName = "setDefaultAuditLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setDefaultAuditLog");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setDefaultAuditLog");
            this.errorHandler.validateUserId(userId, serverName, "setDefaultAuditLog");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setDefaultAuditLog");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " set up default audit log destinations.")));
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig == null) {
                OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = omrsConfigurationFactory.getDefaultRepositoryServicesConfig();
            } else {
                ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
                Connection defaultAuditLogDestination = configurationFactory.getDefaultAuditLogConnection();
                ArrayList<Connection> auditLogDestinations = new ArrayList<Connection>();
                auditLogDestinations.add(defaultAuditLogDestination);
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setDefaultAuditLog", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setDefaultAuditLog", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addConsoleAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addConsoleAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addConsoleAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addConsoleAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addConsoleAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getConsoleAuditLogConnection(supportedSeverities));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addConsoleAuditLogDestination", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSLF4JAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addSLF4JAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSLF4JAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addSLF4JAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addSLF4JAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getSLF4JAuditLogConnection(supportedSeverities));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addSLF4JAuditLogDestination", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addFileAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addFileAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addFileAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addFileAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addFileAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getFileBasedAuditLogConnection(serverName, supportedSeverities));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addFileAuditLogDestination", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addEventTopicAuditLogDestination(String userId, String serverName, List<String> supportedSeverities) {
        String methodName = "addEventTopicAuditLogDestination";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addEventTopicAuditLogDestination");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addEventTopicAuditLogDestination");
            this.errorHandler.validateUserId(userId, serverName, "addEventTopicAuditLogDestination");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addEventTopicAuditLogDestination");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "addEventTopicAuditLogDestination");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            this.addAuditLogDestination(userId, serverName, configurationFactory.getEventTopicAuditLogConnection(serverName, supportedSeverities, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getConfigurationProperties()));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addEventTopicAuditLogDestination", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addStartUpOpenMetadataArchiveFile(String userId, String serverName, String fileName) {
        String methodName = "addStartUpOpenMetadataArchiveFile";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addStartUpOpenMetadataArchiveFile");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addStartUpOpenMetadataArchiveFile");
            this.errorHandler.validateUserId(userId, serverName, "addStartUpOpenMetadataArchiveFile");
            this.errorHandler.validateFileName(fileName, serverName, "addStartUpOpenMetadataArchiveFile");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            Connection newOpenMetadataArchive = configurationFactory.getOpenMetadataArchiveFileConnection(fileName);
            ArrayList<Connection> openMetadataArchiveConnections = null;
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addStartUpOpenMetadataArchiveFile");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                openMetadataArchiveConnections = repositoryServicesConfig.getOpenMetadataArchiveConnections();
            }
            if (openMetadataArchiveConnections == null) {
                openMetadataArchiveConnections = new ArrayList<Connection>();
            }
            openMetadataArchiveConnections.add(newOpenMetadataArchive);
            this.setOpenMetadataArchives(userId, serverName, openMetadataArchiveConnections);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addStartUpOpenMetadataArchiveFile", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setInMemLocalRepository(String userId, String serverName, NullRequestBody requestBody) {
        String methodName = "setInMemLocalRepository";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setInMemLocalRepository");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setInMemLocalRepository");
            this.errorHandler.validateUserId(userId, serverName, "setInMemLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setInMemLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getInMemoryLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL()));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setInMemLocalRepository", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGraphLocalRepository(String userId, String serverName, Map<String, Object> storageProperties) {
        String methodName = "setGraphLocalRepository";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGraphLocalRepository");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setGraphLocalRepository");
            this.errorHandler.validateUserId(userId, serverName, "setGraphLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setGraphLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getLocalGraphLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL(), storageProperties));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setGraphLocalRepository", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setReadOnlyLocalRepository(String userId, String serverName) {
        String methodName = "setReadOnlyLocalRepository";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setReadOnlyLocalRepository");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setReadOnlyLocalRepository");
            this.errorHandler.validateUserId(userId, serverName, "setReadOnlyLocalRepository");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setReadOnlyLocalRepository");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            this.setLocalRepositoryConfig(userId, serverName, configurationFactory.getReadOnlyLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL()));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setReadOnlyLocalRepository", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setNoRepositoryMode(String userId, String serverName) {
        return this.clearLocalRepositoryConfig(userId, serverName);
    }

    public VoidResponse setPluginRepositoryConnection(String userId, String serverName, Connection connection) {
        String methodName = "setPluginRepositoryConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setPluginRepositoryConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setPluginRepositoryConnection");
            this.errorHandler.validateUserId(userId, serverName, "setPluginRepositoryConnection");
            this.errorHandler.validateServerConnection(connection, serverName, "setPluginRepositoryConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setPluginRepositoryConnection");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            LocalRepositoryConfig localRepositoryConfig = configurationFactory.getPluginRepositoryLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL());
            localRepositoryConfig.setLocalRepositoryLocalConnection(connection);
            localRepositoryConfig.setEventMapperConnection(null);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setPluginRepositoryConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setPluginRepositoryConnection(String userId, String serverName, String connectorProvider, Map<String, Object> additionalProperties) {
        String methodName = "setPluginRepositoryConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setPluginRepositoryConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setPluginRepositoryConnection");
            this.errorHandler.validateUserId(userId, serverName, "setPluginRepositoryConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setPluginRepositoryConnection");
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.setPluginRepositoryConnection(userId, serverName, connectorConfigurationFactory.getRepositoryConnection(connectorProvider, serverConfig.getLocalServerURL(), additionalProperties));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setPluginRepositoryConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, Connection connection) {
        String methodName = "setRepositoryProxyConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setRepositoryProxyConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyConnection");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            this.errorHandler.validateServerConnection(connection, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setRepositoryProxyConnection");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            LocalRepositoryConfig localRepositoryConfig = configurationFactory.getRepositoryProxyLocalRepositoryConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerURL());
            localRepositoryConfig.setLocalRepositoryLocalConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setRepositoryProxyConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRepositoryProxyConnection(String userId, String serverName, String connectorProvider, Map<String, Object> additionalProperties) {
        String methodName = "setRepositoryProxyConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setRepositoryProxyConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyConnection");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setRepositoryProxyConnection");
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.setRepositoryProxyConnection(userId, serverName, connectorConfigurationFactory.getRepositoryConnection(connectorProvider, serverConfig.getLocalServerURL(), additionalProperties));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setRepositoryProxyConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRepositoryProxyEventMapper(String userId, String serverName, Connection connection) {
        String methodName = "setRepositoryProxyEventMapper";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setRepositoryProxyEventMapper");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyEventMapper");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyEventMapper");
            this.errorHandler.validateServerConnection(connection, serverName, "setRepositoryProxyEventMapper");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setRepositoryProxyEventMapper");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), "setRepositoryProxyEventMapper");
            }
            if (localRepositoryConfig.getLocalRepositoryMode() != LocalRepositoryMode.REPOSITORY_PROXY) {
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.LOCAL_REPOSITORY_MODE_NOT_PROXY.getMessageDefinition(new String[]{serverName, localRepositoryConfig.getLocalRepositoryMode().getName()}), this.getClass().getName(), "setRepositoryProxyEventMapper");
            }
            localRepositoryConfig.setEventMapperConnection(connection);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setRepositoryProxyEventMapper", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRepositoryProxyEventMapper(String userId, String serverName, String connectorProvider, String eventSource, Map<String, Object> additionalProperties) {
        String methodName = "setRepositoryProxyEventMapper";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setRepositoryProxyEventMapper");
        VoidResponse response = new VoidResponse();
        try {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            this.errorHandler.validateServerName(serverName, "setRepositoryProxyEventMapper");
            this.errorHandler.validateUserId(userId, serverName, "setRepositoryProxyEventMapper");
            this.setRepositoryProxyEventMapper(userId, serverName, connectorConfigurationFactory.getRepositoryEventMapperConnection(connectorProvider, additionalProperties, eventSource));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setRepositoryProxyEventMapper", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getLocalMetadataCollectionId(String userId, String serverName) {
        String methodName = "getLocalMetadataCollectionId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocalMetadataCollectionId");
        GUIDResponse response = new GUIDResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getLocalMetadataCollectionId");
            this.errorHandler.validateUserId(userId, serverName, "getLocalMetadataCollectionId");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getLocalMetadataCollectionId");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                throw new OMAGInvalidParameterException(OMAGAdminErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), "getLocalMetadataCollectionId");
            }
            response.setGUID(localRepositoryConfig.getMetadataCollectionId());
            return response;
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getLocalMetadataCollectionId", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setLocalMetadataCollectionName(String userId, String serverName, String localMetadataCollectionName) {
        String methodName = "setLocalMetadataCollectionName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocalMetadataCollectionName");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalMetadataCollectionName");
            this.errorHandler.validateUserId(userId, serverName, "setLocalMetadataCollectionName");
            this.errorHandler.validateMetadataCollectionName(localMetadataCollectionName, serverName, "setLocalMetadataCollectionName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalMetadataCollectionName");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            LocalRepositoryConfig localRepositoryConfig = null;
            if (repositoryServicesConfig != null) {
                localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
            }
            if (localRepositoryConfig == null) {
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.LOCAL_REPOSITORY_MODE_NOT_SET.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), "setLocalMetadataCollectionName");
            }
            localRepositoryConfig.setMetadataCollectionName(localMetadataCollectionName);
            this.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setLocalMetadataCollectionName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addCohortRegistration(String userId, String serverName, String cohortName, CohortTopicStructure cohortTopicStructure, Map<String, Object> configurationProperties) {
        String methodName = "addCohortRegistration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCohortRegistration");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addCohortRegistration");
            this.errorHandler.validateUserId(userId, serverName, "addCohortRegistration");
            this.errorHandler.validateCohortName(cohortName, serverName, "addCohortRegistration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addCohortRegistration");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "addCohortRegistration");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            CohortConfig newCohortConfig = configurationFactory.getDefaultCohortConfig(serverConfig.getLocalServerName(), cohortName, cohortTopicStructure, configurationProperties, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getConfigurationProperties());
            this.setCohortConfig(userId, serverName, cohortName, newCohortConfig);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addCohortRegistration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StringResponse getCohortTopicName(String userId, String serverName, String cohortName) {
        String methodName = "getCohortTopicName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCohortTopicName");
        StringResponse response = new StringResponse();
        try {
            CohortConfig currentCohortDetails;
            this.errorHandler.validateServerName(serverName, "getCohortTopicName");
            this.errorHandler.validateUserId(userId, serverName, "getCohortTopicName");
            this.errorHandler.validateCohortName(cohortName, serverName, "getCohortTopicName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getCohortTopicName");
            if (serverConfig != null && (currentCohortDetails = this.errorHandler.validateCohortIsSet(serverName, serverConfig, cohortName, "getCohortTopicName")) != null) {
                response.setResultString(this.getCohortTopicName(currentCohortDetails.getCohortOMRSTopicConnection()));
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getCohortTopicName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DedicatedTopicListResponse getDedicatedCohortTopicNames(String userId, String serverName, String cohortName) {
        String methodName = "getDedicatedCohortTopicNames";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDedicatedCohortTopicNames");
        DedicatedTopicListResponse response = new DedicatedTopicListResponse();
        try {
            CohortConfig currentCohortDetails;
            this.errorHandler.validateServerName(serverName, "getDedicatedCohortTopicNames");
            this.errorHandler.validateUserId(userId, serverName, "getDedicatedCohortTopicNames");
            this.errorHandler.validateCohortName(cohortName, serverName, "getDedicatedCohortTopicNames");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getDedicatedCohortTopicNames");
            if (serverConfig != null && (currentCohortDetails = this.errorHandler.validateCohortIsSet(serverName, serverConfig, cohortName, "getDedicatedCohortTopicNames")) != null) {
                DedicatedTopicList topicNames = new DedicatedTopicList();
                topicNames.setRegistrationTopicName(this.getCohortTopicName(currentCohortDetails.getCohortOMRSRegistrationTopicConnection()));
                topicNames.setTypesTopicName(this.getCohortTopicName(currentCohortDetails.getCohortOMRSTypesTopicConnection()));
                topicNames.setInstancesTopicName(this.getCohortTopicName(currentCohortDetails.getCohortOMRSInstancesTopicConnection()));
                response.setDedicatedTopicList(topicNames);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getDedicatedCohortTopicNames", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String getCohortTopicName(Connection eventTopicConnection) {
        Endpoint endpoint;
        Connection connection;
        VirtualConnection virtualConnection;
        List embeddedConnections;
        if (eventTopicConnection instanceof VirtualConnection && (embeddedConnections = (virtualConnection = (VirtualConnection)eventTopicConnection).getEmbeddedConnections()) != null && embeddedConnections.size() == 1 && (connection = ((EmbeddedConnection)embeddedConnections.get(0)).getEmbeddedConnection()) != null && (endpoint = connection.getEndpoint()) != null) {
            return endpoint.getAddress();
        }
        return null;
    }

    public VoidResponse overrideCohortTopicName(String userId, String serverName, String cohortName, String topicName) {
        String methodName = "overrideCohortTopicName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "overrideCohortTopicName");
        VoidResponse response = new VoidResponse();
        try {
            CohortConfig currentCohortDetails;
            this.errorHandler.validateServerName(serverName, "overrideCohortTopicName");
            this.errorHandler.validateUserId(userId, serverName, "overrideCohortTopicName");
            this.errorHandler.validateCohortName(cohortName, serverName, "overrideCohortTopicName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "overrideCohortTopicName");
            if (serverConfig != null && (currentCohortDetails = this.errorHandler.validateCohortIsSet(serverName, serverConfig, cohortName, "overrideCohortTopicName")) != null) {
                Connection eventTopicConnection = this.overrideCohortTopicName(currentCohortDetails.getCohortOMRSTopicConnection(), topicName);
                if (eventTopicConnection != null) {
                    currentCohortDetails.setCohortOMRSTopicConnection(eventTopicConnection);
                    this.setCohortConfig(userId, serverName, cohortName, currentCohortDetails);
                } else {
                    this.errorHandler.logNoCohortTopicChange(cohortName, serverName, "overrideCohortTopicName");
                }
            }
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "overrideCohortTopicName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse overrideRegistrationCohortTopicName(String userId, String serverName, String cohortName, String topicName) {
        String methodName = "overrideRegistrationCohortTopicName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "overrideRegistrationCohortTopicName");
        VoidResponse response = new VoidResponse();
        try {
            CohortConfig currentCohortDetails;
            this.errorHandler.validateServerName(serverName, "overrideRegistrationCohortTopicName");
            this.errorHandler.validateUserId(userId, serverName, "overrideRegistrationCohortTopicName");
            this.errorHandler.validateCohortName(cohortName, serverName, "overrideRegistrationCohortTopicName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "overrideRegistrationCohortTopicName");
            if (serverConfig != null && (currentCohortDetails = this.errorHandler.validateCohortIsSet(serverName, serverConfig, cohortName, "overrideRegistrationCohortTopicName")) != null) {
                Connection eventTopicConnection = this.overrideCohortTopicName(currentCohortDetails.getCohortOMRSRegistrationTopicConnection(), topicName);
                if (eventTopicConnection != null) {
                    currentCohortDetails.setCohortOMRSRegistrationTopicConnection(eventTopicConnection);
                    this.setCohortConfig(userId, serverName, cohortName, currentCohortDetails);
                } else {
                    this.errorHandler.logNoCohortTopicChange(cohortName, serverName, "overrideRegistrationCohortTopicName");
                }
            }
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "overrideRegistrationCohortTopicName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse overrideTypesCohortTopicName(String userId, String serverName, String cohortName, String topicName) {
        String methodName = "overrideTypesCohortTopicName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "overrideTypesCohortTopicName");
        VoidResponse response = new VoidResponse();
        try {
            CohortConfig currentCohortDetails;
            this.errorHandler.validateServerName(serverName, "overrideTypesCohortTopicName");
            this.errorHandler.validateUserId(userId, serverName, "overrideTypesCohortTopicName");
            this.errorHandler.validateCohortName(cohortName, serverName, "overrideTypesCohortTopicName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "overrideTypesCohortTopicName");
            if (serverConfig != null && (currentCohortDetails = this.errorHandler.validateCohortIsSet(serverName, serverConfig, cohortName, "overrideTypesCohortTopicName")) != null) {
                Connection eventTopicConnection = this.overrideCohortTopicName(currentCohortDetails.getCohortOMRSTypesTopicConnection(), topicName);
                if (eventTopicConnection != null) {
                    currentCohortDetails.setCohortOMRSTypesTopicConnection(eventTopicConnection);
                    this.setCohortConfig(userId, serverName, cohortName, currentCohortDetails);
                } else {
                    this.errorHandler.logNoCohortTopicChange(cohortName, serverName, "overrideTypesCohortTopicName");
                }
            }
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "overrideTypesCohortTopicName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse overrideInstancesCohortTopicName(String userId, String serverName, String cohortName, String topicName) {
        String methodName = "overrideInstancesCohortTopicName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "overrideInstancesCohortTopicName");
        VoidResponse response = new VoidResponse();
        try {
            CohortConfig currentCohortDetails;
            this.errorHandler.validateServerName(serverName, "overrideInstancesCohortTopicName");
            this.errorHandler.validateUserId(userId, serverName, "overrideInstancesCohortTopicName");
            this.errorHandler.validateCohortName(cohortName, serverName, "overrideInstancesCohortTopicName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "overrideInstancesCohortTopicName");
            if (serverConfig != null && (currentCohortDetails = this.errorHandler.validateCohortIsSet(serverName, serverConfig, cohortName, "overrideInstancesCohortTopicName")) != null) {
                Connection eventTopicConnection = this.overrideCohortTopicName(currentCohortDetails.getCohortOMRSInstancesTopicConnection(), topicName);
                if (eventTopicConnection != null) {
                    currentCohortDetails.setCohortOMRSInstancesTopicConnection(eventTopicConnection);
                    this.setCohortConfig(userId, serverName, cohortName, currentCohortDetails);
                } else {
                    this.errorHandler.logNoCohortTopicChange(cohortName, serverName, "overrideInstancesCohortTopicName");
                }
            }
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "overrideInstancesCohortTopicName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private Connection overrideCohortTopicName(Connection eventTopicConnection, String topicName) {
        Endpoint endpoint;
        EmbeddedConnection embeddedConnection;
        Connection connection;
        VirtualConnection virtualConnection;
        ArrayList<EmbeddedConnection> embeddedConnections;
        if (eventTopicConnection instanceof VirtualConnection && (embeddedConnections = (virtualConnection = (VirtualConnection)eventTopicConnection).getEmbeddedConnections()) != null && embeddedConnections.size() == 1 && (connection = (embeddedConnection = (EmbeddedConnection)embeddedConnections.get(0)).getEmbeddedConnection()) != null && (endpoint = connection.getEndpoint()) != null) {
            endpoint.setAddress(topicName);
            connection.setEndpoint(endpoint);
            embeddedConnection.setEmbeddedConnection(connection);
            embeddedConnections = new ArrayList<EmbeddedConnection>();
            embeddedConnections.add(embeddedConnection);
            virtualConnection.setEmbeddedConnections(embeddedConnections);
            return virtualConnection;
        }
        return null;
    }

    public VoidResponse addAuditLogDestination(String userId, String serverName, Connection auditLogDestination) {
        String methodName = "setAuditLogDestinations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setAuditLogDestinations");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAuditLogDestinations");
            this.errorHandler.validateUserId(userId, serverName, "setAuditLogDestinations");
            this.errorHandler.validateServerConnection(auditLogDestination, serverName, "setAuditLogDestinations");
            if (auditLogDestination != null) {
                ArrayList<Connection> auditLogDestinations;
                RepositoryServicesConfig repositoryServicesConfig;
                OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAuditLogDestinations");
                ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<CallSite>();
                }
                if ((repositoryServicesConfig = serverConfig.getRepositoryServicesConfig()) == null) {
                    OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                    repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig();
                }
                if ((auditLogDestinations = repositoryServicesConfig.getAuditLogConnections()) == null) {
                    auditLogDestinations = new ArrayList<Connection>();
                    configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " created first audit log destination.")));
                } else {
                    configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " added to list of audit log destinations.")));
                }
                auditLogDestinations.add(auditLogDestination);
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
                serverConfig.setAuditTrail(configAuditTrail);
                serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
                this.configStore.saveServerConfig(serverName, "setAuditLogDestinations", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setAuditLogDestinations", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setAuditLogDestinations(String userId, String serverName, List<Connection> auditLogDestinations) {
        String methodName = "setAuditLogDestinations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setAuditLogDestinations");
        VoidResponse response = new VoidResponse();
        try {
            OMAGServerConfig serverConfig;
            ArrayList<CallSite> configAuditTrail;
            this.errorHandler.validateServerName(serverName, "setAuditLogDestinations");
            this.errorHandler.validateUserId(userId, serverName, "setAuditLogDestinations");
            if (auditLogDestinations != null) {
                for (Connection connection : auditLogDestinations) {
                    this.errorHandler.validateServerConnection(connection, serverName, "setAuditLogDestinations");
                }
            }
            if ((configAuditTrail = (serverConfig = this.configStore.getServerConfig(userId, serverName, "setAuditLogDestinations")).getAuditTrail()) == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (auditLogDestinations == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " setting up no audit log destinations.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated list of audit log destinations.")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
            } else if (auditLogDestinations != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig();
                repositoryServicesConfig.setAuditLogConnections(auditLogDestinations);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setAuditLogDestinations", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setAuditLogDestinations", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionListResponse getAuditLogDestinations(String userId, String serverName) {
        String methodName = "getAuditLogDestinations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAuditLogDestinations");
        ConnectionListResponse response = new ConnectionListResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getAuditLogDestinations");
            this.errorHandler.validateUserId(userId, serverName, "getAuditLogDestinations");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getAuditLogDestinations");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                response.setConnections(repositoryServicesConfig.getAuditLogConnections());
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getAuditLogDestinations", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAuditLogDestinations(String userId, String serverName) {
        return this.setAuditLogDestinations(userId, serverName, null);
    }

    public VoidResponse setOpenMetadataArchives(String userId, String serverName, List<Connection> openMetadataArchives) {
        String methodName = "setOpenMetadataArchives";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setOpenMetadataArchives");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOpenMetadataArchives");
            this.errorHandler.validateUserId(userId, serverName, "setOpenMetadataArchives");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setOpenMetadataArchives");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (openMetadataArchives == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " clearing open metadata archives.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated list of open metadata archives loaded at server start up.")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setOpenMetadataArchiveConnections(openMetadataArchives);
            } else if (openMetadataArchives != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig();
                repositoryServicesConfig.setOpenMetadataArchiveConnections(openMetadataArchives);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setOpenMetadataArchives", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setOpenMetadataArchives", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionListResponse getOpenMetadataArchives(String userId, String serverName) {
        String methodName = "getOpenMetadataArchives";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOpenMetadataArchives");
        ConnectionListResponse response = new ConnectionListResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getOpenMetadataArchives");
            this.errorHandler.validateUserId(userId, serverName, "getOpenMetadataArchives");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getOpenMetadataArchives");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                response.setConnections(repositoryServicesConfig.getOpenMetadataArchiveConnections());
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getOpenMetadataArchives", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearOpenMetadataArchives(String userId, String serverName) {
        return this.setOpenMetadataArchives(userId, serverName, null);
    }

    public VoidResponse setLocalRepositoryConfig(String userId, String serverName, LocalRepositoryConfig localRepositoryConfig) {
        String methodName = "setLocalRepositoryConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocalRepositoryConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryConfig");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalRepositoryConfig");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (localRepositoryConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " setting up a null local repository.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for the local repository.")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                String existingMetadataCollectionId;
                LocalRepositoryConfig existingLocalRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
                if (localRepositoryConfig != null && existingLocalRepositoryConfig != null && (existingMetadataCollectionId = existingLocalRepositoryConfig.getMetadataCollectionId()) != null) {
                    configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " preserving local metadata collection id " + existingMetadataCollectionId + ".")));
                    localRepositoryConfig.setMetadataCollectionId(existingMetadataCollectionId);
                }
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            } else if (localRepositoryConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig();
                repositoryServicesConfig.setLocalRepositoryConfig(localRepositoryConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setLocalRepositoryConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setLocalRepositoryConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocalRepositoryConfigResponse getLocalRepositoryConfig(String userId, String serverName) {
        String methodName = "setLocalRepositoryConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocalRepositoryConfig");
        LocalRepositoryConfigResponse response = new LocalRepositoryConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setLocalRepositoryConfig");
            this.errorHandler.validateUserId(userId, serverName, "setLocalRepositoryConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalRepositoryConfig");
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                response.setConfig(repositoryServicesConfig.getLocalRepositoryConfig());
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setLocalRepositoryConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLocalRepositoryConfig(String userId, String serverName) {
        String methodName = "clearLocalRepositoryConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLocalRepositoryConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearLocalRepositoryConfig");
            this.errorHandler.validateUserId(userId, serverName, "clearLocalRepositoryConfig");
            this.setLocalRepositoryConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearLocalRepositoryConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setCohortConfig(String userId, String serverName, String cohortName, CohortConfig cohortConfig) {
        String methodName = "setCohortConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setCohortConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setCohortConfig");
            this.errorHandler.validateUserId(userId, serverName, "setCohortConfig");
            this.errorHandler.validateCohortName(cohortName, serverName, "setCohortConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setCohortConfig");
            OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            List existingCohortConfigs = null;
            ArrayList<CohortConfig> newCohortConfigs = new ArrayList<CohortConfig>();
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (cohortConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for cohort " + cohortName + ".")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for cohort " + cohortName + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            if (repositoryServicesConfig != null) {
                existingCohortConfigs = repositoryServicesConfig.getCohortConfigList();
            }
            if (existingCohortConfigs != null) {
                for (CohortConfig existingCohort : existingCohortConfigs) {
                    String existingCohortName;
                    if (existingCohort == null || cohortName.equals(existingCohortName = existingCohort.getCohortName())) continue;
                    newCohortConfigs.add(existingCohort);
                }
            }
            if (cohortConfig != null) {
                newCohortConfigs.add(cohortConfig);
            }
            if (newCohortConfigs.isEmpty()) {
                newCohortConfigs = null;
            }
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            } else if (newCohortConfigs != null) {
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig();
                repositoryServicesConfig.setCohortConfigList(newCohortConfigs);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setCohortConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setCohortConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CohortConfigResponse getCohortConfig(String userId, String serverName, String cohortName) {
        String methodName = "getCohortConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCohortConfig");
        CohortConfigResponse response = new CohortConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getCohortConfig");
            this.errorHandler.validateUserId(userId, serverName, "getCohortConfig");
            this.errorHandler.validateCohortName(cohortName, serverName, "getCohortConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getCohortConfig");
            if (serverConfig != null) {
                response.setConfig(this.errorHandler.validateCohortIsSet(serverName, serverConfig, cohortName, "getCohortConfig"));
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getCohortConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCohortConfig(String userId, String serverName, String cohortName) {
        String methodName = "clearCohortRegistration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCohortRegistration");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearCohortRegistration");
            this.errorHandler.validateUserId(userId, serverName, "clearCohortRegistration");
            this.errorHandler.validateCohortName(cohortName, serverName, "clearCohortRegistration");
            this.setCohortConfig(userId, serverName, cohortName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearCohortRegistration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setOMAGServerConfig(String userId, String serverName, OMAGServerConfig omagServerConfig) {
        String methodName = "setOMAGServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setOMAGServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOMAGServerConfig");
            this.errorHandler.validateUserId(userId, serverName, "setOMAGServerConfig");
            if (omagServerConfig == null) {
                throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_SERVER_CONFIG.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), "setOMAGServerConfig");
            }
            ArrayList<CallSite> configAuditTrail = omagServerConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " deployed configuration for server.")));
            omagServerConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "setOMAGServerConfig", omagServerConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setOMAGServerConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deployOMAGServerConfig(String userId, String serverName, URLRequestBody destinationPlatform) {
        String methodName = "deployOMAGServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deployOMAGServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deployOMAGServerConfig");
            this.errorHandler.validateUserId(userId, serverName, "deployOMAGServerConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "deployOMAGServerConfig");
            String serverURLRoot = serverConfig.getLocalServerURL();
            if (destinationPlatform != null && destinationPlatform.getUrlRoot() != null) {
                serverURLRoot = destinationPlatform.getUrlRoot();
            }
            ConfigurationManagementClient client = new ConfigurationManagementClient(serverName, serverURLRoot);
            client.setOMAGServerConfig(userId, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "deployOMAGServerConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OMAGServerConfigResponse getStoredConfiguration(String userId, String serverName) {
        String methodName = "getStoredConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStoredConfiguration");
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getStoredConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getStoredConfiguration");
            response.setOMAGServerConfig(this.configStore.getServerConfig(userId, serverName, "getStoredConfiguration"));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getStoredConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OMAGServerConfigsResponse retrieveAllServerConfigs(String userId) {
        String methodName = "retrieveAllServerConfigs";
        RESTCallToken token = restCallLogger.logRESTCall("", userId, "retrieveAllServerConfigs");
        OMAGServerConfigsResponse response = new OMAGServerConfigsResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsInvestigatorForPlatform((String)userId);
            response.setOMAGServerConfigs(this.configStore.retrieveAllServerConfigs(userId, "retrieveAllServerConfigs"));
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("retrieveAllServerConfigs", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearOMAGServerConfig(String userId, String serverName) {
        String methodName = "clearOMAGServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearOMAGServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearOMAGServerConfig");
            this.errorHandler.validateUserId(userId, serverName, "clearOMAGServerConfig");
            this.configStore.saveServerConfig(serverName, "clearOMAGServerConfig", null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearOMAGServerConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

