/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.OMAGOperationalServicesInstance;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.OMAGServerOperationalInstanceHandler;
import org.odpi.openmetadata.adminservices.classifier.ServerTypeClassifier;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.properties.ServerActiveStatus;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.gaf.admin.GAFMetadataOperationalServices;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.admin.OCFMetadataOperationalServices;
import org.odpi.openmetadata.conformance.server.ConformanceSuiteOperationalServices;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.dataengineproxy.admin.DataEngineProxyOperationalServices;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostOperationalServices;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonOperationalServices;
import org.odpi.openmetadata.governanceservers.openlineage.admin.OpenLineageServerOperationalServices;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.admin.OMRSOperationalServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.LoggerFactory;

public class OMAGServerOperationalServices {
    private OMAGServerOperationalInstanceHandler instanceHandler = new OMAGServerOperationalInstanceHandler(CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerOperationalServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());

    public SuccessMessageResponse activateServerListWithStoredConfig(String userId, List<String> serverNames) {
        Object startUpMessage = null;
        SuccessMessageResponse response = new SuccessMessageResponse();
        response.setRelatedHTTPCode(200);
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                response = this.activateWithStoredConfig(userId, serverName.trim());
                if (response.getRelatedHTTPCode() == 200) {
                    String serverStartUpMessage = "OMAG Server '" + serverName + "' successful start , with message: " + response.getSuccessMessage() + System.lineSeparator();
                    if (startUpMessage == null) {
                        startUpMessage = serverStartUpMessage;
                        continue;
                    }
                    startUpMessage = (String)startUpMessage + serverStartUpMessage;
                    continue;
                }
                break;
            }
        } else {
            startUpMessage = "No OMAG servers listed in startup configuration";
        }
        if (response.getRelatedHTTPCode() == 200) {
            response.setSuccessMessage(new Date().toString() + " " + (String)startUpMessage);
        }
        return response;
    }

    public SuccessMessageResponse activateWithStoredConfig(String userId, String serverName) {
        String methodName = "activateWithStoredConfig";
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithStoredConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithStoredConfig");
            response = this.activateWithSuppliedConfig(userId, serverName, this.configStore.getServerConfig(userId, serverName, false, "activateWithStoredConfig"));
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "activateWithStoredConfig", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public SuccessMessageResponse activateWithSuppliedConfig(String userId, String serverName, OMAGServerConfig configuration) {
        String methodName = "activateWithSuppliedConfig";
        String actionDescription = "Initialize OMAG Server subsystems";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "activateWithSuppliedConfig");
        ArrayList<String> activatedServiceList = new ArrayList<String>();
        OMAGOperationalServicesInstance instance = null;
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithSuppliedConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithSuppliedConfig");
            ServerTypeClassifier serverTypeClassifier = new ServerTypeClassifier(serverName, configuration);
            ServerTypeClassification serverTypeClassification = serverTypeClassifier.getServerType();
            if (configuration.getLocalServerType() == null) {
                configuration.setLocalServerType(serverTypeClassification.getServerTypeName());
            }
            this.configStore.saveServerConfig(serverName, "activateWithSuppliedConfig", configuration);
            if (this.instanceHandler.isServerActive(userId, serverName)) {
                this.deactivateTemporarily(userId, serverName);
            }
            instance = new OMAGOperationalServicesInstance(serverName, serverTypeClassification, CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName(), configuration.getMaxPageSize());
            instance.setServerActiveStatus(ServerActiveStatus.STARTING);
            instance.setOperationalConfiguration(configuration);
            instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            OMRSOperationalServices operationalRepositoryServices = new OMRSOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getLocalServerURL(), configuration.getMaxPageSize());
            activatedServiceList.add(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName());
            operationalRepositoryServices.initializeAuditLog(configuration.getRepositoryServicesConfig(), serverTypeClassification.getServerTypeName());
            OMRSAuditLog auditLog = operationalRepositoryServices.getAuditLog(CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceCode(), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceDevelopmentStatus(), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName(), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceDescription(), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceWiki());
            instance.setAuditLog(auditLog);
            this.validateMaxPageSize(configuration.getMaxPageSize(), serverName, auditLog, "activateWithSuppliedConfig");
            instance.setOperationalRepositoryServices(operationalRepositoryServices);
            if (ServerTypeClassification.METADATA_SERVER.equals((Object)serverTypeClassification) || ServerTypeClassification.METADATA_ACCESS_POINT.equals((Object)serverTypeClassification) || ServerTypeClassification.REPOSITORY_PROXY.equals((Object)serverTypeClassification) || ServerTypeClassification.CONFORMANCE_SERVER.equals((Object)serverTypeClassification)) {
                operationalRepositoryServices.initializeCohortMember(configuration.getRepositoryServicesConfig());
                OpenMetadataServerSecurityVerifier securityVerifier = this.platformInstanceMap.startUpServerInstance(configuration.getLocalServerUserId(), serverName, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceCode(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDevelopmentStatus(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceName(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDescription(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceWiki()), configuration.getServerSecurityConnection());
                operationalRepositoryServices.setSecurityVerifier(securityVerifier);
                instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
                OMRSRepositoryConnector enterpriseRepositoryConnector = operationalRepositoryServices.getEnterpriseOMRSRepositoryConnector(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName());
                if (enterpriseRepositoryConnector != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STARTING);
                    OCFMetadataOperationalServices operationalOCFMetadataServices = new OCFMetadataOperationalServices(configuration.getLocalServerName(), enterpriseRepositoryConnector, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceCode(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceDevelopmentStatus(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceDescription(), CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceWiki()), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                    instance.setOperationalOCFMetadataServices(operationalOCFMetadataServices);
                    activatedServiceList.add(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName());
                    instance.setServerServiceActiveStatus(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STARTING);
                    GAFMetadataOperationalServices operationalGAFMetadataServices = new GAFMetadataOperationalServices(configuration.getLocalServerName(), enterpriseRepositoryConnector, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceCode(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceDevelopmentStatus(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceDescription(), CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceWiki()), configuration.getLocalServerUserId(), configuration.getMaxPageSize());
                    instance.setOperationalGAFMetadataServices(operationalGAFMetadataServices);
                    activatedServiceList.add(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName());
                }
                OMRSTopicConnector enterpriseTopicConnector = operationalRepositoryServices.getEnterpriseOMRSTopicConnector();
                this.initializeAccessServices(instance, configuration.getAccessServicesConfig(), operationalRepositoryServices, enterpriseTopicConnector, configuration.getLocalServerUserId(), serverName, activatedServiceList, auditLog);
                if (ServerTypeClassification.CONFORMANCE_SERVER.equals((Object)serverTypeClassification)) {
                    ConformanceSuiteOperationalServices operationalConformanceSuiteServices = new ConformanceSuiteOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
                    instance.setOperationalConformanceSuiteServices(operationalConformanceSuiteServices);
                    operationalConformanceSuiteServices.initialize(configuration.getConformanceSuiteConfig(), enterpriseTopicConnector, operationalRepositoryServices.getEnterpriseConnectorManager(), operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceCode(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceDescription(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceWiki()));
                    activatedServiceList.add(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName());
                }
                if (enterpriseTopicConnector != null) {
                    try {
                        enterpriseTopicConnector.start();
                    }
                    catch (Exception error) {
                        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.ENTERPRISE_TOPIC_START_FAILED.getMessageDefinition(new String[]{serverName, "in memory", error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "activateWithSuppliedConfig");
                    }
                }
            } else if (ServerTypeClassification.VIEW_SERVER.equals((Object)serverTypeClassification)) {
                operationalRepositoryServices.initializeViewServer(configuration.getRepositoryServicesConfig());
                instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
                this.platformInstanceMap.startUpServerInstance(configuration.getLocalServerUserId(), serverName, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceCode(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDevelopmentStatus(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceName(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDescription(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceWiki()), configuration.getServerSecurityConnection());
                this.initializeViewServices(instance, configuration.getViewServicesConfig(), operationalRepositoryServices, configuration.getLocalServerUserId(), serverName, activatedServiceList, configuration.getMaxPageSize(), auditLog);
            } else {
                operationalRepositoryServices.initializeGovernanceServer(configuration.getRepositoryServicesConfig());
                instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
                this.platformInstanceMap.startUpServerInstance(configuration.getLocalServerUserId(), serverName, (AuditLog)operationalRepositoryServices.getAuditLog(CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceCode(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDevelopmentStatus(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceName(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceDescription(), CommonServicesDescription.OPEN_METADATA_SECURITY.getServiceWiki()), configuration.getServerSecurityConnection());
                try {
                    auditLog.logMessage("Initialize OMAG Server subsystems", OMAGAdminAuditCode.STARTING_GOVERNANCE_SERVICES.getMessageDefinition(new String[]{serverTypeClassifier.getServerType().getServerTypeName(), serverName}));
                    this.initializeGovernanceServices(instance, configuration, serverTypeClassification, operationalRepositoryServices, activatedServiceList);
                    auditLog.logMessage("Initialize OMAG Server subsystems", OMAGAdminAuditCode.GOVERNANCE_SERVICES_STARTED.getMessageDefinition(new String[]{serverTypeClassifier.getServerType().getServerTypeName(), serverName}));
                }
                catch (OMAGConfigurationErrorException error) {
                    auditLog.logException("Initialize OMAG Server subsystems", OMAGAdminAuditCode.GOVERNANCE_SERVICE_FAILURE.getMessageDefinition(new String[]{((Object)((Object)error)).getClass().getName(), serverTypeClassifier.getServerType().getServerTypeName(), serverName, error.getReportedErrorMessage()}), (Throwable)error);
                    throw error;
                }
                catch (Exception error) {
                    auditLog.logException("Initialize OMAG Server subsystems", OMAGAdminAuditCode.GOVERNANCE_SERVICE_FAILURE.getMessageDefinition(new String[]{error.getClass().getName(), serverTypeClassifier.getServerType().getServerTypeName(), serverName, error.getMessage()}), (Throwable)error);
                    throw error;
                }
            }
            instance.setServerActiveStatus(ServerActiveStatus.RUNNING);
            String successMessage = new Date().toString() + " " + serverName + " is running the following services: " + ((Object)activatedServiceList).toString();
            auditLog.logMessage("Initialize OMAG Server subsystems", OMAGAdminAuditCode.SERVER_STARTUP_SUCCESS.getMessageDefinition(new String[]{serverName, ((Object)activatedServiceList).toString()}));
            response.setSuccessMessage(successMessage);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, "activateWithSuppliedConfig", instance);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, "activateWithSuppliedConfig", instance);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, "activateWithSuppliedConfig", instance);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, "activateWithSuppliedConfig", instance);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "activateWithSuppliedConfig", (FFDCResponseBase)response, error);
            this.cleanUpRunningServiceInstances(userId, serverName, "activateWithSuppliedConfig", instance);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private void validateMaxPageSize(int maxPageSize, String serverName, OMRSAuditLog auditLog, String methodName) throws OMAGConfigurationErrorException {
        String actionDescription = "Validating max page size during server initialization";
        if (maxPageSize > 0) {
            auditLog.logMessage("Validating max page size during server initialization", OMAGAdminAuditCode.MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName, Integer.toString(maxPageSize)}));
        } else if (maxPageSize == 0) {
            auditLog.logMessage("Validating max page size during server initialization", OMAGAdminAuditCode.UNLIMITED_MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName}));
        } else {
            auditLog.logMessage("Validating max page size during server initialization", OMAGAdminAuditCode.INVALID_MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName, Integer.toString(maxPageSize)}));
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_MAX_PAGE_SIZE.getMessageDefinition(new String[]{serverName, Integer.toString(maxPageSize)}), this.getClass().getName(), methodName);
        }
    }

    private void initializeAccessServices(OMAGOperationalServicesInstance instance, List<AccessServiceConfig> accessServiceConfigList, OMRSOperationalServices operationalRepositoryServices, OMRSTopicConnector enterpriseTopicConnector, String localServerUserId, String serverName, List<String> activatedServiceList, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "initializeAccessServices";
        String actionDescription = "Initialize Access Services";
        List<AccessServiceAdmin> operationalAccessServiceAdminList = instance.getOperationalAccessServiceAdminList();
        if (accessServiceConfigList != null) {
            auditLog.logMessage("Initialize Access Services", OMAGAdminAuditCode.STARTING_ACCESS_SERVICES.getMessageDefinition());
            int configuredAccessServiceCount = 0;
            int enabledAccessServiceCount = 0;
            for (AccessServiceConfig accessServiceConfig : accessServiceConfigList) {
                if (accessServiceConfig == null) continue;
                ++configuredAccessServiceCount;
                if (ServiceOperationalStatus.ENABLED.equals((Object)accessServiceConfig.getAccessServiceOperationalStatus())) {
                    ++enabledAccessServiceCount;
                    instance.setServerServiceActiveStatus(accessServiceConfig.getAccessServiceFullName(), ServerActiveStatus.STARTING);
                    try {
                        AccessServiceAdmin accessServiceAdmin = this.getAccessServiceAdminClass(accessServiceConfig, auditLog, serverName);
                        accessServiceAdmin.setFullServiceName(accessServiceConfig.getAccessServiceFullName());
                        OMRSAuditLog accessServicesAuditLog = operationalRepositoryServices.getAuditLog(accessServiceConfig.getAccessServiceId(), accessServiceConfig.getAccessServiceDevelopmentStatus(), accessServiceConfig.getAccessServiceFullName(), accessServiceConfig.getAccessServiceDescription(), accessServiceConfig.getAccessServiceWiki());
                        accessServiceAdmin.initialize(accessServiceConfig, enterpriseTopicConnector, operationalRepositoryServices.getEnterpriseOMRSRepositoryConnector(accessServiceConfig.getAccessServiceFullName()), accessServicesAuditLog, localServerUserId);
                        operationalAccessServiceAdminList.add(accessServiceAdmin);
                        activatedServiceList.add(accessServiceConfig.getAccessServiceFullName());
                        instance.setServerServiceActiveStatus(accessServiceAdmin.getFullServiceName(), ServerActiveStatus.RUNNING);
                        continue;
                    }
                    catch (OMAGConfigurationErrorException error) {
                        auditLog.logException("initializeAccessServices", OMAGAdminAuditCode.ACCESS_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{accessServiceConfig.getAccessServiceName(), error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
                        throw error;
                    }
                    catch (Exception error) {
                        auditLog.logException("initializeAccessServices", OMAGAdminAuditCode.ACCESS_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage(), accessServiceConfig.getAccessServiceName(), error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
                        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{serverName, accessServiceConfig.getAccessServiceName(), error.getMessage()}), this.getClass().getName(), "initializeAccessServices", (Throwable)error);
                    }
                }
                auditLog.logMessage("Initialize Access Services", OMAGAdminAuditCode.SKIPPING_ACCESS_SERVICE.getMessageDefinition(new String[]{accessServiceConfig.getAccessServiceFullName(), serverName}));
            }
            auditLog.logMessage("Initialize Access Services", OMAGAdminAuditCode.ALL_ACCESS_SERVICES_STARTED.getMessageDefinition(new String[]{Integer.toString(enabledAccessServiceCount), Integer.toString(configuredAccessServiceCount)}));
        }
        instance.setOperationalAccessServiceAdminList(operationalAccessServiceAdminList);
    }

    private void initializeViewServices(OMAGOperationalServicesInstance instance, List<ViewServiceConfig> viewServiceConfigList, OMRSOperationalServices operationalRepositoryServices, String localServerUserId, String serverName, List<String> activatedServiceList, int maxPageSize, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "initializeViewServices";
        String actionDescription = "Initialize View Services";
        List<ViewServiceAdmin> operationalViewServiceAdminList = instance.getOperationalViewServiceAdminList();
        if (viewServiceConfigList != null) {
            auditLog.logMessage("Initialize View Services", OMAGAdminAuditCode.STARTING_VIEW_SERVICES.getMessageDefinition());
            int configuredViewServiceCount = 0;
            int enabledViewServiceCount = 0;
            for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                ++configuredViewServiceCount;
                if (ServiceOperationalStatus.ENABLED.equals((Object)viewServiceConfig.getViewServiceOperationalStatus())) {
                    ++enabledViewServiceCount;
                    instance.setServerServiceActiveStatus(viewServiceConfig.getViewServiceFullName(), ServerActiveStatus.STARTING);
                    try {
                        ViewServiceAdmin viewServiceAdmin = this.getViewServiceAdminClass(viewServiceConfig, auditLog, serverName);
                        OMRSAuditLog viewServicesAuditLog = operationalRepositoryServices.getAuditLog(viewServiceConfig.getViewServiceId(), viewServiceConfig.getViewServiceDevelopmentStatus(), viewServiceConfig.getViewServiceFullName(), viewServiceConfig.getViewServiceDescription(), viewServiceConfig.getViewServiceWiki());
                        viewServiceAdmin.initialize(serverName, viewServiceConfig, (AuditLog)viewServicesAuditLog, localServerUserId, maxPageSize);
                        operationalViewServiceAdminList.add(viewServiceAdmin);
                        activatedServiceList.add(viewServiceConfig.getViewServiceFullName());
                        instance.setServerServiceActiveStatus(viewServiceConfig.getViewServiceFullName(), ServerActiveStatus.RUNNING);
                        continue;
                    }
                    catch (OMAGConfigurationErrorException error) {
                        auditLog.logException("initializeViewServices", OMAGAdminAuditCode.VIEW_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{viewServiceConfig.getViewServiceName(), error.getMessage()}), viewServiceConfig.toString(), (Throwable)error);
                        throw error;
                    }
                    catch (Exception error) {
                        auditLog.logException("initializeViewServices", OMAGAdminAuditCode.VIEW_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage(), viewServiceConfig.getViewServiceName(), error.getMessage()}), viewServiceConfig.toString(), (Throwable)error);
                        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{serverName, viewServiceConfig.getViewServiceName(), error.getMessage()}), this.getClass().getName(), "initializeViewServices", (Throwable)error);
                    }
                }
                auditLog.logMessage("Initialize View Services", OMAGAdminAuditCode.SKIPPING_VIEW_SERVICE.getMessageDefinition(new String[]{viewServiceConfig.getViewServiceFullName(), serverName}));
            }
            auditLog.logMessage("Initialize View Services", OMAGAdminAuditCode.ALL_VIEW_SERVICES_STARTED.getMessageDefinition(new String[]{Integer.toString(enabledViewServiceCount), Integer.toString(configuredViewServiceCount)}));
        }
        instance.setOperationalViewServiceAdminList(operationalViewServiceAdminList);
    }

    private AccessServiceAdmin getAccessServiceAdminClass(AccessServiceConfig accessServiceConfig, OMRSAuditLog auditLog, String serverName) throws OMAGConfigurationErrorException {
        String methodName = "getAccessServiceAdminClass";
        String accessServiceAdminClassName = accessServiceConfig.getAccessServiceAdminClass();
        if (accessServiceAdminClassName != null) {
            try {
                return (AccessServiceAdmin)Class.forName(accessServiceAdminClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception error) {
                auditLog.logException("getAccessServiceAdminClass", OMAGAdminAuditCode.BAD_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{accessServiceConfig.getAccessServiceName(), accessServiceAdminClassName, error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, accessServiceAdminClassName, accessServiceConfig.getAccessServiceName()}), this.getClass().getName(), "getAccessServiceAdminClass", (Throwable)error);
            }
        }
        auditLog.logMessage("getAccessServiceAdminClass", OMAGAdminAuditCode.NULL_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, accessServiceConfig.getAccessServiceFullName()}), accessServiceConfig.toString());
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.NULL_ACCESS_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, accessServiceConfig.getAccessServiceName()}), this.getClass().getName(), "getAccessServiceAdminClass");
    }

    private ViewServiceAdmin getViewServiceAdminClass(ViewServiceConfig viewServiceConfig, OMRSAuditLog auditLog, String serverName) throws OMAGConfigurationErrorException {
        String methodName = "getViewServiceAdminClass";
        String viewServiceAdminClassName = viewServiceConfig.getViewServiceAdminClass();
        if (viewServiceAdminClassName != null) {
            try {
                return (ViewServiceAdmin)Class.forName(viewServiceAdminClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception error) {
                auditLog.logException("getViewServiceAdminClass", OMAGAdminAuditCode.BAD_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{viewServiceConfig.getViewServiceName(), viewServiceAdminClassName, error.getMessage()}), viewServiceConfig.toString(), (Throwable)error);
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, viewServiceAdminClassName, viewServiceConfig.getViewServiceName()}), this.getClass().getName(), "getViewServiceAdminClass", (Throwable)error);
            }
        }
        auditLog.logMessage("getViewServiceAdminClass", OMAGAdminAuditCode.NULL_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, viewServiceConfig.getViewServiceFullName()}), viewServiceConfig.toString());
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.NULL_VIEW_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{serverName, viewServiceConfig.getViewServiceName()}), this.getClass().getName(), "getViewServiceAdminClass");
    }

    private void initializeGovernanceServices(OMAGOperationalServicesInstance instance, OMAGServerConfig configuration, ServerTypeClassification serverTypeClassification, OMRSOperationalServices operationalRepositoryServices, List<String> activatedServiceList) throws OMAGConfigurationErrorException {
        if (ServerTypeClassification.DATA_ENGINE_PROXY.equals((Object)serverTypeClassification)) {
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            DataEngineProxyOperationalServices operationalDataEngineProxyServices = new DataEngineProxyOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerId(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword());
            instance.setOperationalDataEngineProxyServices(operationalDataEngineProxyServices);
            operationalDataEngineProxyServices.initialize(configuration.getDataEngineProxyConfig(), operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceCode(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceDescription(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceWiki()));
            activatedServiceList.add(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName());
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
        } else if (ServerTypeClassification.ENGINE_HOST.equals((Object)serverTypeClassification)) {
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            EngineHostOperationalServices engineHostOperationalServices = new EngineHostOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerId(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
            instance.setOperationalEngineHost(engineHostOperationalServices);
            List engineServices = engineHostOperationalServices.initialize(configuration.getEngineHostServicesConfig(), (AuditLog)operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceCode(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceDescription(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceWiki()));
            activatedServiceList.addAll(engineServices);
            activatedServiceList.add(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName());
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
        } else if (ServerTypeClassification.INTEGRATION_DAEMON.equals((Object)serverTypeClassification)) {
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            IntegrationDaemonOperationalServices integrationDaemonOperationalServices = new IntegrationDaemonOperationalServices(configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
            instance.setOperationalIntegrationDaemon(integrationDaemonOperationalServices);
            List integrationServices = integrationDaemonOperationalServices.initialize(configuration.getIntegrationServicesConfig(), (AuditLog)operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceCode(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceDescription(), GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceWiki()));
            activatedServiceList.addAll(integrationServices);
            activatedServiceList.add(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName());
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
        } else if (ServerTypeClassification.OPEN_LINEAGE_SERVER.equals((Object)serverTypeClassification)) {
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), ServerActiveStatus.STARTING);
            OpenLineageServerOperationalServices operationalOpenLineageServer = new OpenLineageServerOperationalServices(configuration.getLocalServerId(), configuration.getLocalServerName(), configuration.getLocalServerUserId(), configuration.getLocalServerPassword(), configuration.getMaxPageSize());
            instance.setOpenLineageOperationalServices(operationalOpenLineageServer);
            operationalOpenLineageServer.initialize(configuration.getOpenLineageServerConfig(), operationalRepositoryServices.getAuditLog(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceCode(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceDevelopmentStatus(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceDescription(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceWiki()));
            activatedServiceList.add(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName());
            instance.setServerServiceActiveStatus(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), ServerActiveStatus.RUNNING);
        }
    }

    private void cleanUpRunningServiceInstances(String userId, String serverName, String methodName, OMAGOperationalServicesInstance instance) {
        try {
            this.deactivateRunningServiceInstances(userId, serverName, methodName, instance, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deactivateRunningServiceInstances(String userId, String serverName, String methodName, OMAGOperationalServicesInstance instance, boolean permanentDeactivation) throws InvalidParameterException, PropertyServerException {
        String actionDescription = "Shutdown server";
        if (instance != null) {
            OMRSAuditLog auditLog = instance.getAuditLog();
            if (auditLog != null) {
                auditLog.logMessage("Shutdown server", OMAGAdminAuditCode.SERVER_SHUTDOWN_STARTED.getMessageDefinition(new String[]{serverName}), Boolean.toString(permanentDeactivation));
            }
            try {
                if (instance.getOperationalDataEngineProxyServices() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalDataEngineProxyServices().disconnect();
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalAccessServiceAdminList() != null) {
                    for (AccessServiceAdmin accessServiceAdmin : instance.getOperationalAccessServiceAdminList()) {
                        if (accessServiceAdmin == null) continue;
                        instance.setServerServiceActiveStatus(accessServiceAdmin.getFullServiceName(), ServerActiveStatus.STOPPING);
                        accessServiceAdmin.shutdown();
                        instance.setServerServiceActiveStatus(accessServiceAdmin.getFullServiceName(), ServerActiveStatus.INACTIVE);
                    }
                }
                if (instance.getOperationalViewServiceAdminList() != null) {
                    for (ViewServiceAdmin viewServiceAdmin : instance.getOperationalViewServiceAdminList()) {
                        if (viewServiceAdmin == null) continue;
                        instance.setServerServiceActiveStatus(viewServiceAdmin.getFullServiceName(), ServerActiveStatus.STOPPING);
                        viewServiceAdmin.shutdown();
                        instance.setServerServiceActiveStatus(viewServiceAdmin.getFullServiceName(), ServerActiveStatus.INACTIVE);
                    }
                }
                if (instance.getOperationalOCFMetadataServices() != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalOCFMetadataServices().shutdown();
                    instance.setServerServiceActiveStatus(CommonServicesDescription.OCF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalGAFMetadataServices() != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalGAFMetadataServices().shutdown();
                    instance.setServerServiceActiveStatus(CommonServicesDescription.GAF_METADATA_MANAGEMENT.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalEngineHost() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalEngineHost().terminate();
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalIntegrationDaemon() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalIntegrationDaemon().terminate();
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOpenLineageOperationalServices() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOpenLineageOperationalServices().shutdown();
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalConformanceSuiteServices() != null) {
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalConformanceSuiteServices().terminate(permanentDeactivation);
                    instance.setServerServiceActiveStatus(GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                if (instance.getOperationalRepositoryServices() != null) {
                    instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.STOPPING);
                    instance.getOperationalRepositoryServices().disconnect(permanentDeactivation);
                    instance.setServerServiceActiveStatus(CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), ServerActiveStatus.INACTIVE);
                }
                instance.setServerActiveStatus(ServerActiveStatus.INACTIVE);
                this.instanceHandler.removeServerServiceInstance(serverName);
                if (auditLog != null) {
                    auditLog.logMessage("Shutdown server", OMAGAdminAuditCode.SERVER_SHUTDOWN_SUCCESS.getMessageDefinition(new String[]{serverName}), Boolean.toString(permanentDeactivation));
                }
            }
            catch (Exception error) {
                if (auditLog != null) {
                    auditLog.logException("Shutdown server", OMAGAdminAuditCode.SERVER_SHUTDOWN_ERROR.getMessageDefinition(new String[]{serverName, error.getClass().getName(), error.getMessage()}), Boolean.toString(permanentDeactivation), (Throwable)error);
                }
                throw error;
            }
            this.platformInstanceMap.shutdownServerInstance(userId, serverName, methodName);
        }
    }

    public void deactivateTemporarilyServerList(String userId, List<String> serverNames) {
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                this.deactivateTemporarily(userId, serverName);
            }
        }
    }

    public VoidResponse deactivateTemporarily(String userId, String serverName) {
        String methodName = "deactivateTemporarily";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deactivateTemporarily");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deactivateTemporarily");
            this.errorHandler.validateUserId(userId, serverName, "deactivateTemporarily");
            this.deactivateRunningServiceInstances(userId, serverName, "deactivateTemporarily", this.instanceHandler.getServerServiceInstance(userId, serverName, "deactivateTemporarily"), false);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "deactivateTemporarily", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deactivatePermanently(String userId, String serverName) {
        String methodName = "deactivatePermanently";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deactivatePermanently");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deactivatePermanently");
            this.errorHandler.validateUserId(userId, serverName, "deactivatePermanently");
            this.deactivateRunningServiceInstances(userId, serverName, "deactivatePermanently", this.instanceHandler.getServerServiceInstance(userId, serverName, "deactivatePermanently"), true);
            this.configStore.saveServerConfig(serverName, "deactivatePermanently", null);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((FFDCResponse)response, (org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException)error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "deactivatePermanently", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OMAGServerConfigResponse getActiveConfiguration(String userId, String serverName) {
        String methodName = "getActiveConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveConfiguration");
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "getActiveConfiguration");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "getActiveConfiguration");
            response.setOMAGServerConfig(instance.getOperationalConfiguration());
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getActiveConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OMAGServerStatusResponse getActiveServerStatus(String userId, String serverName) {
        String methodName = "getActiveServerStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveServerStatus");
        OMAGServerStatusResponse response = new OMAGServerStatusResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "getActiveServerStatus");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "getActiveServerStatus");
            response.setServerStatus(instance.getServerStatus());
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getActiveServerStatus", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOpenMetadataArchiveFile(String userId, String serverName, String fileName) {
        String methodName = "addOpenMetadataArchiveFile";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addOpenMetadataArchiveFile");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateUserId(userId, serverName, "addOpenMetadataArchiveFile");
            this.errorHandler.validateFileName(fileName, serverName, "addOpenMetadataArchiveFile");
            ConnectorConfigurationFactory configurationFactory = new ConnectorConfigurationFactory();
            Connection newOpenMetadataArchive = configurationFactory.getOpenMetadataArchiveFileConnection(fileName);
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "addOpenMetadataArchiveFile");
            OMRSOperationalServices repositoryServicesInstance = instance.getOperationalRepositoryServices();
            repositoryServicesInstance.addOpenMetadataArchive(newOpenMetadataArchive, fileName);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addOpenMetadataArchiveFile", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOpenMetadataArchive(String userId, String serverName, Connection connection) {
        String methodName = "addOpenMetadataArchive";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addOpenMetadataArchive");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addOpenMetadataArchive");
            this.errorHandler.validateUserId(userId, serverName, "addOpenMetadataArchive");
            this.errorHandler.validateServerConnection(connection, serverName, "addOpenMetadataArchive");
            OMAGOperationalServicesInstance instance = this.instanceHandler.getServerServiceInstance(userId, serverName, "addOpenMetadataArchive");
            OMRSOperationalServices repositoryServicesInstance = instance.getOperationalRepositoryServices();
            repositoryServicesInstance.addOpenMetadataArchive(connection, "addOpenMetadataArchive");
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addOpenMetadataArchive", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

