/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.OMAGViewServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SolutionViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistration;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ViewServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForViewServices {
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForViewServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public RegisteredOMAGServicesResponse getConfiguredViewServices(String userId, String serverName) {
        String methodName = "getConfiguredViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfiguredViewServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getConfiguredViewServices");
            this.errorHandler.validateUserId(userId, serverName, "getConfiguredViewServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getConfiguredViewServices");
            List viewServiceConfigList = serverConfig.getViewServicesConfig();
            if (viewServiceConfigList != null && !viewServiceConfigList.isEmpty()) {
                ArrayList<RegisteredOMAGService> services = new ArrayList<RegisteredOMAGService>();
                for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                    if (viewServiceConfig == null || viewServiceConfig.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceId(viewServiceConfig.getViewServiceId());
                    service.setServiceName(viewServiceConfig.getViewServiceFullName());
                    service.setServiceDevelopmentStatus(viewServiceConfig.getViewServiceDevelopmentStatus());
                    service.setServiceDescription(viewServiceConfig.getViewServiceDescription());
                    service.setServiceURLMarker(viewServiceConfig.getViewServiceURLMarker());
                    service.setServiceWiki(viewServiceConfig.getViewServiceWiki());
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getConfiguredViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ViewServicesResponse getViewServicesConfiguration(String userId, String serverName) {
        String methodName = "getViewServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getViewServicesConfiguration");
        ViewServicesResponse response = new ViewServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getViewServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getViewServicesConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getViewServicesConfiguration");
            List viewServiceConfigList = serverConfig.getViewServicesConfig();
            if (viewServiceConfigList != null && !viewServiceConfigList.isEmpty()) {
                ArrayList<ViewServiceConfig> services = new ArrayList<ViewServiceConfig>();
                for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                    if (viewServiceConfig == null || viewServiceConfig.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    services.add(viewServiceConfig);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getViewServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ViewServiceConfigResponse getViewServiceConfig(String userId, String serverName, String serviceURLMarker) {
        String methodName = "getViewServiceConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getViewServiceConfig");
        ViewServiceConfigResponse response = new ViewServiceConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getViewServiceConfig");
            this.errorHandler.validateUserId(userId, serverName, "getViewServiceConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getViewServiceConfig");
            List currentList = serverConfig.getViewServicesConfig();
            if (currentList != null) {
                for (ViewServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || !serviceURLMarker.equals(existingConfig.getViewServiceURLMarker())) continue;
                    response.setConfig(existingConfig);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getViewServiceConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureViewService(String userId, String serverName, String serviceURLMarker, ViewServiceConfig requestedViewServiceConfig) {
        String methodName = "configureViewService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureViewService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureViewService");
            this.errorHandler.validateUserId(userId, serverName, "configureViewService");
            if (!(requestedViewServiceConfig instanceof IntegrationViewServiceConfig)) {
                this.errorHandler.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)requestedViewServiceConfig, "configureViewService");
            }
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureViewService");
            List<ViewServiceConfig> viewServiceConfigList = serverConfig.getViewServicesConfig();
            ViewServiceRegistration viewServiceRegistration = OMAGViewServiceRegistration.getViewServiceRegistration((String)serviceURLMarker);
            this.errorHandler.validateViewServiceIsRegistered(viewServiceRegistration, serviceURLMarker, serverName, "configureViewService");
            viewServiceConfigList = this.updateViewServiceConfig(this.createViewServiceConfig(viewServiceRegistration, requestedViewServiceConfig), viewServiceConfigList);
            this.storeViewServicesConfig(userId, serverName, serviceURLMarker, viewServiceConfigList, "configureViewService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureViewService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAllViewServices(String userId, String serverName, ViewServiceConfig requestedViewServiceConfig) {
        String methodName = "configureViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureViewServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureViewServices");
            this.errorHandler.validateUserId(userId, serverName, "configureViewServices");
            this.errorHandler.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)requestedViewServiceConfig, "configureViewServices");
            ArrayList<ViewServiceConfig> viewServiceConfigList = new ArrayList<ViewServiceConfig>();
            List viewServiceRegistrationList = OMAGViewServiceRegistration.getViewServiceRegistrationList();
            if (viewServiceRegistrationList != null && !viewServiceRegistrationList.isEmpty()) {
                for (ViewServiceRegistration registration : viewServiceRegistrationList) {
                    if (registration == null || registration.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    viewServiceConfigList.add(this.createViewServiceConfig(registration, requestedViewServiceConfig));
                }
            }
            if (viewServiceConfigList.isEmpty()) {
                viewServiceConfigList = null;
            }
            this.storeViewServicesConfig(userId, serverName, null, viewServiceConfigList, "configureViewServices");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private ViewServiceConfig createViewServiceConfig(ViewServiceRegistration registration, ViewServiceConfig requestedViewServiceConfig) {
        IntegrationViewServiceConfig viewServiceConfig;
        if (requestedViewServiceConfig instanceof IntegrationViewServiceConfig) {
            IntegrationViewServiceConfig requestedIntegrationViewServiceConfig = (IntegrationViewServiceConfig)requestedViewServiceConfig;
            IntegrationViewServiceConfig createdViewServiceConfig = new IntegrationViewServiceConfig(registration);
            createdViewServiceConfig.setResourceEndpoints(requestedIntegrationViewServiceConfig.getResourceEndpoints());
            viewServiceConfig = createdViewServiceConfig;
            createdViewServiceConfig.setOMAGServerPlatformRootURL(requestedViewServiceConfig.getOMAGServerPlatformRootURL());
        } else if (requestedViewServiceConfig instanceof SolutionViewServiceConfig) {
            SolutionViewServiceConfig requestedSolutionViewServiceConfig = (SolutionViewServiceConfig)requestedViewServiceConfig;
            SolutionViewServiceConfig createdViewServiceConfig = new SolutionViewServiceConfig(registration);
            createdViewServiceConfig.setOMAGServerPlatformRootURL(requestedSolutionViewServiceConfig.getOMAGServerPlatformRootURL());
            createdViewServiceConfig.setOMAGServerName(requestedSolutionViewServiceConfig.getOMAGServerName());
            viewServiceConfig = createdViewServiceConfig;
        } else {
            ViewServiceConfig createdViewServiceConfig = new ViewServiceConfig(registration);
            createdViewServiceConfig.setOMAGServerPlatformRootURL(requestedViewServiceConfig.getOMAGServerPlatformRootURL());
            createdViewServiceConfig.setOMAGServerName(requestedViewServiceConfig.getOMAGServerName());
            viewServiceConfig = createdViewServiceConfig;
        }
        Map viewOptions = requestedViewServiceConfig.getViewServiceOptions();
        viewServiceConfig.setViewServiceOptions(viewOptions);
        return viewServiceConfig;
    }

    private List<ViewServiceConfig> updateViewServiceConfig(ViewServiceConfig viewServiceConfig, List<ViewServiceConfig> currentList) {
        if (viewServiceConfig == null) {
            return currentList;
        }
        ArrayList<ViewServiceConfig> newList = new ArrayList<ViewServiceConfig>();
        if (currentList != null) {
            for (ViewServiceConfig existingConfig : currentList) {
                if (existingConfig == null || viewServiceConfig.getViewServiceId() == existingConfig.getViewServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(viewServiceConfig);
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    public VoidResponse clearViewService(String userId, String serverName, String serviceURLMarker) {
        String methodName = "clearViewService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearViewService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearViewService");
            this.errorHandler.validateUserId(userId, serverName, "clearViewService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearViewService");
            List currentList = serverConfig.getViewServicesConfig();
            ArrayList<ViewServiceConfig> newList = new ArrayList<ViewServiceConfig>();
            if (currentList != null) {
                for (ViewServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || serviceURLMarker.equals(existingConfig.getViewServiceURLMarker())) continue;
                    newList.add(existingConfig);
                }
                serverConfig.setViewServicesConfig(newList);
                this.configStore.saveServerConfig(serverName, "clearViewService", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearViewService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAllViewServices(String userId, String serverName) {
        String methodName = "clearAllViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllViewServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearAllViewServices");
            this.errorHandler.validateUserId(userId, serverName, "clearAllViewServices");
            this.storeViewServicesConfig(userId, serverName, null, null, "clearAllViewServices");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearAllViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setViewServicesConfig(String userId, String serverName, List<ViewServiceConfig> viewServicesConfig) {
        String methodName = "setViewServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setViewServicesConfig");
        VoidResponse response = this.storeViewServicesConfig(userId, serverName, null, viewServicesConfig, "setViewServicesConfig");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private VoidResponse storeViewServicesConfig(String userId, String serverName, String serviceURLMarker, List<ViewServiceConfig> viewServicesConfig, String methodName) {
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (viewServicesConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for view services.")));
            } else if (serviceURLMarker == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for view services.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for view service " + serviceURLMarker + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setViewServicesConfig(viewServicesConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }
}

