/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.adminservices.configuration.properties.OLSSimplifiedAccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

public class OMAGServerConfigOpenLineage {
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private static final String serviceName = GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName();
    private static final String defaultInTopicName = "inTopic";
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setOpenLineageConfig(String userId, String serverName, OpenLineageServerConfig openLineageServerConfig) {
        String methodName = "setOpenLineageConfig";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            this.errorHandler.validatePropertyNotNull(openLineageServerConfig.getLineageGraphConnection(), "lineageGraphConnection", serverName, methodName);
            OLSSimplifiedAccessServiceConfig accessServiceConfig = openLineageServerConfig.getAccessServiceConfig();
            this.errorHandler.validatePropertyNotNull(accessServiceConfig, "accessServiceConfig", serverName, methodName);
            this.errorHandler.validatePropertyNotNull(accessServiceConfig.getServerName(), "accessServiceConfig.serverName", serverName, methodName);
            this.errorHandler.validatePropertyNotNull(accessServiceConfig.getServerPlatformUrlRoot(), "accessServiceConfig.serverPlatformUrlRoot", serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            this.errorHandler.validateEventBusIsSet(serverName, serverConfig, methodName);
            serverConfig.setOpenLineageServerConfig(openLineageServerConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for open lineage services.")));
            serverConfig.setAuditTrail(configAuditTrail);
        }
        catch (OMAGInvalidParameterException e) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (Exception e) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, e);
        }
        return response;
    }

    public VoidResponse removeOpenLineageConfig(String userId, String serverName) {
        String methodName = "shutdown";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "shutdown");
            this.errorHandler.validateUserId(userId, serverName, "shutdown");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "shutdown");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for " + serviceName + ".")));
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setOpenLineageServerConfig(null);
            this.configStore.saveServerConfig(serverName, "shutdown", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "shutdown", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

