/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGServerExceptionHandler
extends RESTExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RESTExceptionHandler.class);

    public void capturePlatformRuntimeException(String serverName, String methodName, FFDCResponseBase response, Throwable runtimeException) {
        log.error("Unexpected exception", runtimeException);
        OMAGConfigurationErrorException error = new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{serverName, methodName, runtimeException.getClass().getName(), runtimeException.getMessage()}), ((Object)((Object)this)).getClass().getName(), methodName, runtimeException);
        log.error("Returning sanitized exception", (Throwable)error);
        this.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    public void capturePlatformRuntimeException(String methodName, FFDCResponseBase response, Throwable runtimeException) {
        log.error("Unexpected platform exception", runtimeException);
        OMAGConfigurationErrorException error = new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNEXPECTED_PLATFORM_EXCEPTION.getMessageDefinition(new String[]{methodName, runtimeException.getClass().getName(), runtimeException.getMessage()}), ((Object)((Object)this)).getClass().getName(), methodName, runtimeException);
        log.error("Returning sanitized platform exception", (Throwable)error);
        this.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    void captureConfigurationErrorException(FFDCResponseBase response, OMAGConfigurationErrorException error) {
        log.error("Configuration error returned", (Throwable)error);
        this.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    void captureInvalidParameterException(FFDCResponseBase response, OMAGInvalidParameterException error) {
        log.error("Invalid parameter error returned", (Throwable)error);
        this.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    public void captureNotAuthorizedException(FFDCResponseBase response, OMAGNotAuthorizedException error) {
        log.error("(OMAG) User not authorized error returned", (Throwable)error);
        this.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    void captureNotAuthorizedException(FFDCResponseBase response, UserNotAuthorizedException error) {
        log.error("User not authorized error returned", (Throwable)error);
        this.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }
}

