/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.IntegrationServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForIntegrationServices {
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForIntegrationServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public RegisteredOMAGServicesResponse getRegisteredIntegrationServices(String userId, String serverName) {
        String methodName = "getRegisteredIntegrationServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getRegisteredIntegrationServices");
            this.errorHandler.validateUserId(userId, serverName, "getRegisteredIntegrationServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getRegisteredIntegrationServices");
            List integrationServiceConfigs = serverConfig.getIntegrationServicesConfig();
            if (integrationServiceConfigs != null && !integrationServiceConfigs.isEmpty()) {
                ArrayList<RegisteredOMAGService> services = new ArrayList<RegisteredOMAGService>();
                for (IntegrationServiceConfig integrationServiceConfig : integrationServiceConfigs) {
                    if (integrationServiceConfig == null || integrationServiceConfig.getIntegrationServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceId(integrationServiceConfig.getIntegrationServiceId());
                    service.setServiceName(integrationServiceConfig.getIntegrationServiceFullName());
                    service.setServiceDevelopmentStatus(integrationServiceConfig.getIntegrationServiceDevelopmentStatus());
                    service.setServiceDescription(integrationServiceConfig.getIntegrationServiceDescription());
                    service.setServiceURLMarker(integrationServiceConfig.getIntegrationServiceURLMarker());
                    service.setServiceWiki(integrationServiceConfig.getIntegrationServiceWiki());
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getRegisteredIntegrationServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationServicesResponse getIntegrationServicesConfiguration(String userId, String serverName) {
        String methodName = "getIntegrationServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationServicesConfiguration");
        IntegrationServicesResponse response = new IntegrationServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getIntegrationServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getIntegrationServicesConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getIntegrationServicesConfiguration");
            response.setServices(serverConfig.getIntegrationServicesConfig());
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getIntegrationServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationServiceConfigResponse getIntegrationServiceConfiguration(String userId, String serverName, String serviceURLMarker) {
        String methodName = "getIntegrationServiceConfiguration";
        String serviceURLMarkerParameterName = "serviceURLMarker";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationServiceConfiguration");
        IntegrationServiceConfigResponse response = new IntegrationServiceConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getIntegrationServiceConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getIntegrationServiceConfiguration");
            this.errorHandler.validatePropertyNotNull(serviceURLMarker, "serviceURLMarker", serverName, "getIntegrationServiceConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getIntegrationServiceConfiguration");
            List currentList = serverConfig.getIntegrationServicesConfig();
            if (currentList != null) {
                for (IntegrationServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || !serviceURLMarker.equals(existingConfig.getIntegrationServiceURLMarker())) continue;
                    response.setConfig(existingConfig);
                }
            }
            if (response.getConfig() == null) {
                response.setConfig(IntegrationServiceRegistry.getIntegrationServiceConfig((String)serviceURLMarker, (String)serverName, (String)"getIntegrationServiceConfiguration"));
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getIntegrationServiceConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureIntegrationService(String userId, String serverName, String serviceURLMarker, IntegrationServiceRequestBody requestBody) {
        String methodName = "configureIntegrationService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureIntegrationService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureIntegrationService");
            this.errorHandler.validateUserId(userId, serverName, "configureIntegrationService");
            this.errorHandler.validateIntegrationServiceConfig(serverName, requestBody, "configureIntegrationService");
            IntegrationServiceConfig serviceConfig = IntegrationServiceRegistry.getIntegrationServiceConfig((String)serviceURLMarker, (String)serverName, (String)"configureIntegrationService");
            serviceConfig.setIntegrationServiceOperationalStatus(ServiceOperationalStatus.ENABLED);
            serviceConfig.setOMAGServerPlatformRootURL(requestBody.getOMAGServerPlatformRootURL());
            serviceConfig.setOMAGServerName(requestBody.getOMAGServerName());
            serviceConfig.setIntegrationConnectorConfigs(requestBody.getIntegrationConnectorConfigs());
            serviceConfig.setIntegrationServiceOptions(requestBody.getIntegrationServiceOptions());
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureIntegrationService");
            List integrationServiceConfigList = serverConfig.getIntegrationServicesConfig();
            response = this.storeIntegrationServicesConfig(userId, serverName, serviceURLMarker, this.updateIntegrationServiceConfig(serviceConfig, integrationServiceConfigList), "configureIntegrationService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureIntegrationService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureIntegrationService(String userId, String serverName, IntegrationServiceConfig serviceConfig) {
        String methodName = "configureIntegrationService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureIntegrationService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureIntegrationService");
            this.errorHandler.validateUserId(userId, serverName, "configureIntegrationService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureIntegrationService");
            List integrationServiceConfigList = serverConfig.getIntegrationServicesConfig();
            response = this.storeIntegrationServicesConfig(userId, serverName, serviceConfig.getIntegrationServiceURLMarker(), this.updateIntegrationServiceConfig(serviceConfig, integrationServiceConfigList), "configureIntegrationService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureIntegrationService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<IntegrationServiceConfig> updateIntegrationServiceConfig(IntegrationServiceConfig integrationServiceConfig, List<IntegrationServiceConfig> currentList) {
        if (integrationServiceConfig == null) {
            return currentList;
        }
        ArrayList<IntegrationServiceConfig> newList = new ArrayList<IntegrationServiceConfig>();
        if (currentList != null) {
            for (IntegrationServiceConfig existingConfig : currentList) {
                if (existingConfig == null || integrationServiceConfig.getIntegrationServiceId() == existingConfig.getIntegrationServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(integrationServiceConfig);
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    public VoidResponse setIntegrationServicesConfig(String userId, String serverName, List<IntegrationServiceConfig> integrationServicesConfig) {
        String methodName = "setIntegrationServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setIntegrationServicesConfig");
        VoidResponse response = this.storeIntegrationServicesConfig(userId, serverName, null, integrationServicesConfig, "setIntegrationServicesConfig");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAllIntegrationServices(String userId, String serverName) {
        String methodName = "clearAllIntegrationServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllIntegrationServices");
        VoidResponse response = this.storeIntegrationServicesConfig(userId, serverName, null, null, "clearAllIntegrationServices");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearIntegrationService(String userId, String serverName, String serviceURLMarker) {
        String methodName = "clearIntegrationService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearIntegrationService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearIntegrationService");
            this.errorHandler.validateUserId(userId, serverName, "clearIntegrationService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearIntegrationService");
            List currentList = serverConfig.getIntegrationServicesConfig();
            ArrayList<IntegrationServiceConfig> newList = new ArrayList<IntegrationServiceConfig>();
            if (currentList != null) {
                for (IntegrationServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || serviceURLMarker.equals(existingConfig.getIntegrationServiceURLMarker())) continue;
                    newList.add(existingConfig);
                }
                response = this.storeIntegrationServicesConfig(userId, serverName, serviceURLMarker, newList, "clearIntegrationService");
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearIntegrationService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private VoidResponse storeIntegrationServicesConfig(String userId, String serverName, String serviceURLMarker, List<IntegrationServiceConfig> integrationServicesConfig, String methodName) {
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (integrationServicesConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for integration services.")));
            } else if (serviceURLMarker == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for integration services.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for integration service " + serviceURLMarker + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setIntegrationServicesConfig(integrationServicesConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }
}

