/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.classifier;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.ConformanceSuiteConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryMode;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;

public class ServerTypeClassifier {
    private static final String ACCESS_SERVICES_NAME = "Open Metadata Access Services (OMAS)";
    private static final String INTEGRATION_SERVICES_NAME = "Open Metadata Integration Services (OMIS)";
    private static final String VIEW_SERVICES_NAME = "Open Metadata View Services (OMVS)";
    private final OMAGServerConfig configurationDocument;
    private final String serverName;

    public ServerTypeClassifier(String serverName, OMAGServerConfig configurationDocument) {
        this.configurationDocument = configurationDocument;
        this.serverName = serverName;
    }

    public ServerTypeClassification getServerType() throws OMAGInvalidParameterException, OMAGConfigurationErrorException {
        LocalRepositoryMode localRepositoryMode;
        String methodName = "getServerType";
        ServerTypeClassification serverTypeClassification = null;
        this.validateConfigurationDocumentNotNull(this.serverName, this.configurationDocument, "getServerType");
        RepositoryServicesConfig repositoryServicesConfig = this.configurationDocument.getRepositoryServicesConfig();
        List accessServiceConfigList = this.configurationDocument.getAccessServicesConfig();
        List integrationServiceConfigList = this.configurationDocument.getIntegrationServicesConfig();
        List dynamicIntegrationGroupConfigList = this.configurationDocument.getDynamicIntegrationGroupsConfig();
        List viewServiceConfigList = this.configurationDocument.getViewServicesConfig();
        ConformanceSuiteConfig conformanceSuiteConfig = this.configurationDocument.getConformanceSuiteConfig();
        EngineHostServicesConfig engineHostServicesConfig = this.configurationDocument.getEngineHostServicesConfig();
        OpenLineageServerConfig openLineageServerConfig = this.configurationDocument.getOpenLineageServerConfig();
        DataEngineProxyConfig dataEngineProxyConfig = this.configurationDocument.getDataEngineProxyConfig();
        if (repositoryServicesConfig == null && accessServiceConfigList == null && engineHostServicesConfig == null && integrationServiceConfigList == null && dynamicIntegrationGroupConfigList == null && viewServiceConfigList == null && conformanceSuiteConfig == null && openLineageServerConfig == null && dataEngineProxyConfig == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.EMPTY_CONFIGURATION.getMessageDefinition(new String[]{this.serverName}), this.getClass().getName(), "getServerType");
        }
        if (repositoryServicesConfig == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.NULL_REPOSITORY_CONFIG.getMessageDefinition(new String[]{this.serverName}), this.getClass().getName(), "getServerType");
        }
        if (accessServiceConfigList != null) {
            localRepositoryMode = this.detectLocalRepository(repositoryServicesConfig);
            serverTypeClassification = localRepositoryMode == LocalRepositoryMode.METADATA_CACHE ? ServerTypeClassification.METADATA_SERVER : (localRepositoryMode == LocalRepositoryMode.OPEN_METADATA_NATIVE ? ServerTypeClassification.METADATA_SERVER : (localRepositoryMode == LocalRepositoryMode.PLUGIN_REPOSITORY ? ServerTypeClassification.METADATA_SERVER : (localRepositoryMode == LocalRepositoryMode.REPOSITORY_PROXY ? ServerTypeClassification.REPOSITORY_PROXY : ServerTypeClassification.METADATA_ACCESS_POINT)));
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), engineHostServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), INTEGRATION_SERVICES_NAME, integrationServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
        }
        if (conformanceSuiteConfig != null) {
            serverTypeClassification = ServerTypeClassification.CONFORMANCE_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), engineHostServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), INTEGRATION_SERVICES_NAME, integrationServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
        }
        if (dataEngineProxyConfig != null) {
            serverTypeClassification = ServerTypeClassification.DATA_ENGINE_PROXY;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), engineHostServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), INTEGRATION_SERVICES_NAME, integrationServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
        }
        if (engineHostServicesConfig != null) {
            serverTypeClassification = ServerTypeClassification.ENGINE_HOST;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), INTEGRATION_SERVICES_NAME, integrationServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, integrationServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
        }
        if (integrationServiceConfigList != null || dynamicIntegrationGroupConfigList != null) {
            serverTypeClassification = ServerTypeClassification.INTEGRATION_DAEMON;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), engineHostServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
        }
        if (openLineageServerConfig != null) {
            serverTypeClassification = ServerTypeClassification.OPEN_LINEAGE_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), engineHostServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), INTEGRATION_SERVICES_NAME, integrationServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), VIEW_SERVICES_NAME, viewServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
        }
        if (viewServiceConfigList != null) {
            serverTypeClassification = ServerTypeClassification.VIEW_SERVER;
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), ACCESS_SERVICES_NAME, accessServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), engineHostServicesConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), INTEGRATION_SERVICES_NAME, integrationServiceConfigList);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.CONFORMANCE_SUITE_SERVICES.getServiceName(), conformanceSuiteConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), dataEngineProxyConfig);
            this.validateSubsystemNotConfigured(this.serverName, serverTypeClassification.getServerTypeName(), GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), openLineageServerConfig);
        }
        if (serverTypeClassification == null) {
            localRepositoryMode = this.detectLocalRepository(repositoryServicesConfig);
            if (localRepositoryMode == LocalRepositoryMode.METADATA_CACHE) {
                serverTypeClassification = ServerTypeClassification.METADATA_SERVER;
            } else if (localRepositoryMode == LocalRepositoryMode.OPEN_METADATA_NATIVE) {
                serverTypeClassification = ServerTypeClassification.METADATA_SERVER;
            } else if (localRepositoryMode == LocalRepositoryMode.PLUGIN_REPOSITORY) {
                serverTypeClassification = ServerTypeClassification.METADATA_SERVER;
            } else if (localRepositoryMode == LocalRepositoryMode.REPOSITORY_PROXY) {
                serverTypeClassification = ServerTypeClassification.REPOSITORY_PROXY;
            }
        }
        this.validateServerClassificationNotNull(this.serverName, serverTypeClassification, "getServerType");
        return serverTypeClassification;
    }

    private void validateConfigurationDocumentNotNull(String serverName, OMAGServerConfig configurationDocument, String methodName) throws OMAGInvalidParameterException {
        if (configurationDocument == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_SERVER_CONFIG.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    private void validateServerClassificationNotNull(String serverName, ServerTypeClassification serverTypeClassification, String methodName) throws OMAGInvalidParameterException {
        if (serverTypeClassification == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.UNCLASSIFIABLE_SERVER.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    private LocalRepositoryMode detectLocalRepository(RepositoryServicesConfig repositoryServicesConfig) {
        LocalRepositoryConfig localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
        if (localRepositoryConfig == null) {
            return LocalRepositoryMode.NO_REPOSITORY;
        }
        LocalRepositoryMode localRepositoryMode = localRepositoryConfig.getLocalRepositoryMode();
        if (localRepositoryMode == null) {
            if (localRepositoryConfig.getLocalRepositoryLocalConnection() != null) {
                return LocalRepositoryMode.REPOSITORY_PROXY;
            }
            return LocalRepositoryMode.NO_REPOSITORY;
        }
        return localRepositoryMode;
    }

    private void validateSubsystemNotConfigured(String serverName, String serverTypeName, String subsystemName, Object subsystemConfig) throws OMAGConfigurationErrorException {
        String methodName = "validateSubsystemNotConfigured";
        if (subsystemConfig != null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.INCOMPATIBLE_SUBSYSTEMS.getMessageDefinition(new String[]{serverName, serverTypeName, subsystemName}), this.getClass().getName(), "validateSubsystemNotConfigured");
        }
    }
}

