/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.properties.OMAGServerServiceStatus;
import org.odpi.openmetadata.adminservices.properties.ServerActiveStatus;
import org.odpi.openmetadata.adminservices.properties.ServerServicesStatus;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.registration.ViewServiceAdmin;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstance;
import org.odpi.openmetadata.conformance.server.ConformanceSuiteOperationalServices;
import org.odpi.openmetadata.frameworkservices.gaf.admin.GAFMetadataOperationalServices;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.admin.OCFMetadataOperationalServices;
import org.odpi.openmetadata.frameworkservices.oif.admin.OIFMetadataOperationalServices;
import org.odpi.openmetadata.governanceservers.dataengineproxy.admin.DataEngineProxyOperationalServices;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostOperationalServices;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonOperationalServices;
import org.odpi.openmetadata.governanceservers.openlineage.admin.OpenLineageServerOperationalServices;
import org.odpi.openmetadata.repositoryservices.admin.OMRSOperationalServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

class OMAGOperationalServicesInstance
extends OMAGServerServiceInstance {
    private ServerActiveStatus serverActiveStatus = ServerActiveStatus.INACTIVE;
    private final Map<String, ServerActiveStatus> serviceStatusMap = new HashMap<String, ServerActiveStatus>();
    private final ServerTypeClassification serverTypeClassification;
    private OMAGServerConfig operationalConfiguration = null;
    private OMRSOperationalServices operationalRepositoryServices = null;
    private OCFMetadataOperationalServices operationalOCFMetadataServices = null;
    private GAFMetadataOperationalServices operationalGAFMetadataServices = null;
    private OIFMetadataOperationalServices operationalOIFMetadataServices = null;
    private List<AccessServiceAdmin> operationalAccessServiceAdminList = new ArrayList<AccessServiceAdmin>();
    private List<ViewServiceAdmin> operationalViewServiceAdminList = new ArrayList<ViewServiceAdmin>();
    private ConformanceSuiteOperationalServices operationalConformanceSuiteServices = null;
    private EngineHostOperationalServices operationalEngineHost = null;
    private IntegrationDaemonOperationalServices operationalIntegrationDaemon = null;
    private OpenLineageServerOperationalServices openLineageOperationalServices = null;
    private DataEngineProxyOperationalServices operationalDataEngineProxyServices = null;
    private OMRSAuditLog auditLog = null;

    OMAGOperationalServicesInstance(String serverName, ServerTypeClassification serverTypeClassification, String serviceName, int maxPageSize) {
        super(serverName, serverTypeClassification.getServerTypeName(), serviceName, maxPageSize);
        this.serverTypeClassification = serverTypeClassification;
    }

    public synchronized void setServerActiveStatus(ServerActiveStatus serverActiveStatus) {
        this.serverActiveStatus = serverActiveStatus;
    }

    public synchronized void setServerServiceActiveStatus(String serviceName, ServerActiveStatus activeStatus) {
        this.serviceStatusMap.put(serviceName, activeStatus);
    }

    public synchronized ServerServicesStatus getServerStatus() {
        List engineServices;
        List integrationServices;
        ServerServicesStatus serverServicesStatus = new ServerServicesStatus();
        serverServicesStatus.setServerName(this.serverName);
        serverServicesStatus.setServerType(this.serverTypeClassification.getServerTypeName());
        serverServicesStatus.setServerActiveStatus(this.serverActiveStatus);
        ArrayList<OMAGServerServiceStatus> serviceStatuses = new ArrayList<OMAGServerServiceStatus>();
        for (String serviceName : this.serviceStatusMap.keySet()) {
            OMAGServerServiceStatus serviceStatus = new OMAGServerServiceStatus();
            serviceStatus.setServiceName(serviceName);
            serviceStatus.setServiceStatus(this.serviceStatusMap.get(serviceName));
            serviceStatuses.add(serviceStatus);
        }
        if (this.operationalIntegrationDaemon != null && (integrationServices = this.operationalIntegrationDaemon.getServiceStatuses()) != null) {
            serviceStatuses.addAll(integrationServices);
        }
        if (this.operationalEngineHost != null && (engineServices = this.operationalEngineHost.getServiceStatuses()) != null) {
            serviceStatuses.addAll(engineServices);
        }
        serverServicesStatus.setServices(serviceStatuses);
        return serverServicesStatus;
    }

    OMAGServerConfig getOperationalConfiguration() {
        return this.operationalConfiguration;
    }

    void setOperationalConfiguration(OMAGServerConfig operationalConfiguration) {
        this.operationalConfiguration = operationalConfiguration;
    }

    OMRSOperationalServices getOperationalRepositoryServices() {
        return this.operationalRepositoryServices;
    }

    void setOperationalRepositoryServices(OMRSOperationalServices operationalRepositoryServices) {
        this.operationalRepositoryServices = operationalRepositoryServices;
    }

    OCFMetadataOperationalServices getOperationalOCFMetadataServices() {
        return this.operationalOCFMetadataServices;
    }

    void setOperationalOCFMetadataServices(OCFMetadataOperationalServices operationalOCFMetadataServices) {
        this.operationalOCFMetadataServices = operationalOCFMetadataServices;
    }

    OIFMetadataOperationalServices getOperationalOIFMetadataServices() {
        return this.operationalOIFMetadataServices;
    }

    void setOperationalOIFMetadataServices(OIFMetadataOperationalServices operationalOIFMetadataServices) {
        this.operationalOIFMetadataServices = operationalOIFMetadataServices;
    }

    GAFMetadataOperationalServices getOperationalGAFMetadataServices() {
        return this.operationalGAFMetadataServices;
    }

    void setOperationalGAFMetadataServices(GAFMetadataOperationalServices operationalGAFMetadataServices) {
        this.operationalGAFMetadataServices = operationalGAFMetadataServices;
    }

    List<AccessServiceAdmin> getOperationalAccessServiceAdminList() {
        return this.operationalAccessServiceAdminList;
    }

    void setOperationalAccessServiceAdminList(List<AccessServiceAdmin> operationalAccessServiceAdminList) {
        this.operationalAccessServiceAdminList = operationalAccessServiceAdminList;
    }

    List<ViewServiceAdmin> getOperationalViewServiceAdminList() {
        return this.operationalViewServiceAdminList;
    }

    void setOperationalViewServiceAdminList(List<ViewServiceAdmin> operationalViewServiceAdminList) {
        this.operationalViewServiceAdminList = operationalViewServiceAdminList;
    }

    ConformanceSuiteOperationalServices getOperationalConformanceSuiteServices() {
        return this.operationalConformanceSuiteServices;
    }

    void setOperationalConformanceSuiteServices(ConformanceSuiteOperationalServices operationalConformanceSuiteServices) {
        this.operationalConformanceSuiteServices = operationalConformanceSuiteServices;
    }

    EngineHostOperationalServices getOperationalEngineHost() {
        return this.operationalEngineHost;
    }

    void setOperationalEngineHost(EngineHostOperationalServices operationalEngineHost) {
        this.operationalEngineHost = operationalEngineHost;
    }

    IntegrationDaemonOperationalServices getOperationalIntegrationDaemon() {
        return this.operationalIntegrationDaemon;
    }

    void setOperationalIntegrationDaemon(IntegrationDaemonOperationalServices operationalIntegrationDaemon) {
        this.operationalIntegrationDaemon = operationalIntegrationDaemon;
    }

    void setOpenLineageOperationalServices(OpenLineageServerOperationalServices openLineageOperationalServices) {
        this.openLineageOperationalServices = openLineageOperationalServices;
    }

    OpenLineageServerOperationalServices getOpenLineageOperationalServices() {
        return this.openLineageOperationalServices;
    }

    DataEngineProxyOperationalServices getOperationalDataEngineProxyServices() {
        return this.operationalDataEngineProxyServices;
    }

    void setOperationalDataEngineProxyServices(DataEngineProxyOperationalServices operationalDataEngineProxyServices) {
        this.operationalDataEngineProxyServices = operationalDataEngineProxyServices;
    }

    OMRSAuditLog getAuditLog() {
        return this.auditLog;
    }

    void setAuditLog(OMRSAuditLog auditLog) {
        this.auditLog = auditLog;
    }
}

