/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationGroupConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.IntegrationGroupsResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForIntegrationGroups {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForIntegrationGroups.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public IntegrationGroupsResponse getIntegrationGroupsConfiguration(String userId, String serverName) {
        String methodName = "getIntegrationGroupsConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupsConfiguration");
        IntegrationGroupsResponse response = new IntegrationGroupsResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getIntegrationGroupsConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getIntegrationGroupsConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getIntegrationGroupsConfiguration");
            response.setGroups(serverConfig.getDynamicIntegrationGroupsConfig());
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getIntegrationGroupsConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureIntegrationGroup(String userId, String serverName, IntegrationGroupConfig requestBody) {
        String methodName = "configureIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureIntegrationGroup");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureIntegrationGroup");
            this.errorHandler.validateUserId(userId, serverName, "configureIntegrationGroup");
            this.errorHandler.validateIntegrationGroupConfig(serverName, requestBody, "configureIntegrationGroup");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureIntegrationGroup");
            List integrationGroupsConfig = serverConfig.getDynamicIntegrationGroupsConfig();
            response = this.storeIntegrationGroupsConfig(userId, serverName, requestBody.getIntegrationGroupQualifiedName(), this.updateIntegrationGroupConfig(requestBody, integrationGroupsConfig), "configureIntegrationGroup");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureIntegrationGroup", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<IntegrationGroupConfig> updateIntegrationGroupConfig(IntegrationGroupConfig integrationGroupConfig, List<IntegrationGroupConfig> currentList) {
        if (integrationGroupConfig == null) {
            return currentList;
        }
        ArrayList<IntegrationGroupConfig> newList = new ArrayList<IntegrationGroupConfig>();
        if (currentList != null) {
            for (IntegrationGroupConfig existingConfig : currentList) {
                if (existingConfig == null || !existingConfig.getIntegrationGroupQualifiedName().equals(integrationGroupConfig.getIntegrationGroupQualifiedName())) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(integrationGroupConfig);
        return newList;
    }

    public VoidResponse setIntegrationGroupsConfig(String userId, String serverName, List<IntegrationGroupConfig> integrationGroupsConfig) {
        String methodName = "setIntegrationGroupsConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setIntegrationGroupsConfig");
        VoidResponse response = this.storeIntegrationGroupsConfig(userId, serverName, null, integrationGroupsConfig, "setIntegrationGroupsConfig");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAllIntegrationGroups(String userId, String serverName) {
        String methodName = "clearAllIntegrationGroups";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllIntegrationGroups");
        VoidResponse response = this.storeIntegrationGroupsConfig(userId, serverName, null, null, "clearAllIntegrationGroups");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearIntegrationGroup(String userId, String serverName, String groupId) {
        String methodName = "clearIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearIntegrationGroup");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearIntegrationGroup");
            this.errorHandler.validateUserId(userId, serverName, "clearIntegrationGroup");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearIntegrationGroup");
            List currentList = serverConfig.getDynamicIntegrationGroupsConfig();
            ArrayList<IntegrationGroupConfig> newList = new ArrayList<IntegrationGroupConfig>();
            if (currentList != null) {
                for (IntegrationGroupConfig existingConfig : currentList) {
                    if (existingConfig == null || groupId.equals(existingConfig.getIntegrationGroupQualifiedName())) continue;
                    newList.add(existingConfig);
                }
                response = this.storeIntegrationGroupsConfig(userId, serverName, groupId, newList, "clearIntegrationGroup");
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearIntegrationGroup", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private VoidResponse storeIntegrationGroupsConfig(String userId, String serverName, String groupQualifiedName, List<IntegrationGroupConfig> integrationGroupsConfig, String methodName) {
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (integrationGroupsConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed configuration for integration groups.")));
            } else if (groupQualifiedName == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for integration groups.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for integration group " + groupQualifiedName + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setDynamicIntegrationGroupsConfig(integrationGroupsConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }
}

