/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.util.HashSet;
import java.util.Set;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStore;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStoreRetrieveAll;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminStoreServices {
    private static Connection configurationStoreConnection = null;
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminStoreServices.class), CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();

    public synchronized VoidResponse setConfigurationStoreConnection(String userId, Connection connection) {
        String methodName = "setConfigurationStoreConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "setConfigurationStoreConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            this.errorHandler.validatePlatformConnection(connection, "setConfigurationStoreConnection");
            configurationStoreConnection = connection;
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("setConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized ConnectionResponse getConfigurationStoreConnection(String userId) {
        String methodName = "getConfigurationStoreConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "getConfigurationStoreConnection");
        ConnectionResponse response = new ConnectionResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            response.setConnection(configurationStoreConnection);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("getConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearConfigurationStoreConnection(String userId) {
        String methodName = "clearConfigurationStoreConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "clearConfigurationStoreConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            configurationStoreConnection = null;
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private synchronized Connection getConnection(String serverName) {
        if (configurationStoreConnection == null) {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            return connectorConfigurationFactory.getServerConfigConnection(serverName);
        }
        return configurationStoreConnection;
    }

    private synchronized Connection getConnectionForRetrieveAll() {
        if (configurationStoreConnection == null) {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            return connectorConfigurationFactory.getServerConfigConnectionForRetrieveAll();
        }
        return configurationStoreConnection;
    }

    private OMAGServerConfigStore getServerConfigStore(String serverName, String methodName) throws OMAGInvalidParameterException {
        Connection connection = this.getConnection(serverName);
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            OMAGServerConfigStore serverConfigStore = (OMAGServerConfigStore)connector;
            serverConfigStore.setServerName(serverName);
            connector.start();
            return serverConfigStore;
        }
        catch (Exception error) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.BAD_CONFIG_FILE.getMessageDefinition(new String[]{serverName, methodName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private OMAGServerConfigStoreRetrieveAll getServerConfigStoreForRetrieveAll() throws OMAGConfigurationErrorException {
        String methodName = "getServerConfigStoreForRetrieveAll";
        Connection connection = this.getConnectionForRetrieveAll();
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            OMAGServerConfigStore serverConfigStore = (OMAGServerConfigStore)connector;
            connector.start();
            return this.getOMAGServerConfigStoreRetrieveAll(serverConfigStore, "getServerConfigStoreForRetrieveAll");
        }
        catch (Exception error) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNABLE_TO_OBTAIN_SERVER_CONFIG_STORE.getMessageDefinition(new String[]{"getServerConfigStoreForRetrieveAll", error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "getServerConfigStoreForRetrieveAll", (Throwable)error);
        }
    }

    OMAGServerConfigStoreRetrieveAll getOMAGServerConfigStoreRetrieveAll(OMAGServerConfigStore serverConfigStore, String methodName) throws OMAGConfigurationErrorException {
        if (!(serverConfigStore instanceof OMAGServerConfigStoreRetrieveAll)) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.RETRIEVE_ALL_CONFIGS_NOT_SUPPORTED.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        OMAGServerConfigStoreRetrieveAll omagServerConfigStoreRetrieveAll = (OMAGServerConfigStoreRetrieveAll)serverConfigStore;
        return omagServerConfigStoreRetrieveAll;
    }

    OMAGServerConfig getServerConfig(String userId, String serverName, String methodName) throws OMAGInvalidParameterException, OMAGNotAuthorizedException {
        return this.getServerConfig(userId, serverName, true, methodName);
    }

    OMAGServerConfig getServerConfig(String userId, String serverName, boolean adminCall, String methodName) throws OMAGInvalidParameterException, OMAGNotAuthorizedException {
        EngineHostServicesConfig engineHostServicesConfig;
        AccessServiceDescription description;
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        OMAGServerConfig serverConfig = null;
        if (serverConfigStore != null) {
            serverConfig = serverConfigStore.retrieveServerConfig();
        }
        if (serverConfig == null) {
            try {
                OpenMetadataPlatformSecurityVerifier.validateUserForNewServer((String)userId);
            }
            catch (UserNotAuthorizedException error) {
                throw new OMAGNotAuthorizedException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
            serverConfig = new OMAGServerConfig();
            serverConfig.setVersionId("V2.0");
            serverConfig.setLocalServerType("Open Metadata and Governance Server");
        } else {
            Object versionId = serverConfig.getVersionId();
            boolean isCompatibleVersion = false;
            if (versionId == null) {
                versionId = "V1.0";
            }
            for (String compatibleVersion : OMAGServerConfig.COMPATIBLE_VERSIONS) {
                if (!compatibleVersion.equals(versionId)) continue;
                isCompatibleVersion = true;
                break;
            }
            if (!isCompatibleVersion) {
                throw new OMAGInvalidParameterException(OMAGAdminErrorCode.INCOMPATIBLE_CONFIG_FILE.getMessageDefinition(new String[]{serverName, versionId, OMAGServerConfig.COMPATIBLE_VERSIONS.toString()}), this.getClass().getName(), methodName);
            }
            this.validateConfigServerName(serverName, serverConfig.getLocalServerName(), methodName);
            try {
                OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
                securityVerifier.registerSecurityValidator(serverConfig.getLocalServerUserId(), serverName, null, serverConfig.getServerSecurityConnection());
                if (adminCall) {
                    securityVerifier.validateUserAsServerAdmin(userId);
                } else {
                    securityVerifier.validateUserAsServerOperator(userId);
                }
            }
            catch (InvalidParameterException error) {
                throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
            catch (UserNotAuthorizedException error) {
                throw new OMAGNotAuthorizedException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
        }
        serverConfig.setLocalServerName(serverName);
        if (serverConfig.getAccessServicesConfig() != null) {
            for (AccessServiceConfig accessServiceConfig : serverConfig.getAccessServicesConfig()) {
                if (accessServiceConfig == null || (description = AccessServiceDescription.getAccessServiceDefinition((int)accessServiceConfig.getAccessServiceId())) == null) continue;
                accessServiceConfig.setAccessServiceName(description.getAccessServiceName());
                accessServiceConfig.setAccessServiceDevelopmentStatus(description.getAccessServiceDevelopmentStatus());
                accessServiceConfig.setAccessServiceFullName(description.getAccessServiceFullName());
                accessServiceConfig.setAccessServiceDescription(description.getAccessServiceDescription());
                accessServiceConfig.setAccessServiceURLMarker(description.getAccessServiceURLMarker());
                accessServiceConfig.setAccessServiceWiki(description.getAccessServiceWiki());
            }
        }
        if (serverConfig.getEngineHostServicesConfig() != null && (engineHostServicesConfig = serverConfig.getEngineHostServicesConfig()).getEngineServiceConfigs() != null) {
            for (EngineServiceConfig engineServiceConfig : engineHostServicesConfig.getEngineServiceConfigs()) {
                EngineServiceDescription description2;
                if (engineServiceConfig == null || (description2 = EngineServiceDescription.getEngineServiceDefinition((int)engineServiceConfig.getEngineServiceId())) == null) continue;
                engineServiceConfig.setEngineServiceName(description2.getEngineServiceName());
                engineServiceConfig.setEngineServiceDevelopmentStatus(description2.getEngineServiceDevelopmentStatus());
                engineServiceConfig.setEngineServiceFullName(description2.getEngineServiceFullName());
                engineServiceConfig.setEngineServiceDescription(description2.getEngineServiceDescription());
                engineServiceConfig.setEngineServiceURLMarker(description2.getEngineServiceURLMarker());
                engineServiceConfig.setEngineServiceWiki(description2.getEngineServiceWiki());
            }
        }
        if (serverConfig.getIntegrationServicesConfig() != null) {
            for (IntegrationServiceConfig integrationServiceConfig : serverConfig.getIntegrationServicesConfig()) {
                if (integrationServiceConfig == null || (description = IntegrationServiceDescription.getIntegrationServiceDefinition((int)integrationServiceConfig.getIntegrationServiceId())) == null) continue;
                integrationServiceConfig.setIntegrationServiceName(description.getIntegrationServiceName());
                integrationServiceConfig.setIntegrationServiceDevelopmentStatus(description.getIntegrationServiceDevelopmentStatus());
                integrationServiceConfig.setIntegrationServiceFullName(description.getIntegrationServiceFullName());
                integrationServiceConfig.setIntegrationServiceDescription(description.getIntegrationServiceDescription());
                integrationServiceConfig.setIntegrationServiceURLMarker(description.getIntegrationServiceURLMarker());
                integrationServiceConfig.setIntegrationServiceWiki(description.getIntegrationServiceWiki());
            }
        }
        if (serverConfig.getViewServicesConfig() != null) {
            for (ViewServiceConfig viewServiceConfig : serverConfig.getViewServicesConfig()) {
                if (viewServiceConfig == null || (description = ViewServiceDescription.getViewServiceDefinition((int)viewServiceConfig.getViewServiceId())) == null) continue;
                viewServiceConfig.setViewServiceName(description.getViewServiceName());
                viewServiceConfig.setViewServiceDevelopmentStatus(description.getViewServiceDevelopmentStatus());
                viewServiceConfig.setViewServiceFullName(description.getViewServiceFullName());
                viewServiceConfig.setViewServiceDescription(description.getViewServiceDescription());
                viewServiceConfig.setViewServiceURLMarker(description.getViewServiceURLMarker());
                viewServiceConfig.setViewServiceWiki(description.getViewServiceWiki());
            }
        }
        return serverConfig;
    }

    void saveServerConfig(String serverName, String methodName, OMAGServerConfig serverConfig) throws OMAGInvalidParameterException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        if (serverConfigStore != null) {
            if (serverConfig != null) {
                this.validateConfigServerName(serverName, serverConfig.getLocalServerName(), methodName);
                serverConfigStore.saveServerConfig(serverConfig);
            } else {
                serverConfigStore.removeServerConfig();
            }
        }
    }

    Set<OMAGServerConfig> retrieveAllServerConfigs(String userId) throws OMAGConfigurationErrorException {
        String methodName = "retrieveAllServerConfigs";
        OMAGServerConfigStoreRetrieveAll serverConfigStore = this.getServerConfigStoreForRetrieveAll();
        Set configuredServers = serverConfigStore.retrieveAllServerConfigs();
        if (configuredServers != null) {
            HashSet<OMAGServerConfig> validatedServers = new HashSet<OMAGServerConfig>();
            for (OMAGServerConfig serverConfig : configuredServers) {
                if (serverConfig == null) continue;
                try {
                    OMAGServerConfig validatedConfig = this.getServerConfig(userId, serverConfig.getLocalServerName(), false, "retrieveAllServerConfigs");
                    if (validatedConfig == null) continue;
                    validatedServers.add(validatedConfig);
                }
                catch (Exception exception) {}
            }
            return validatedServers;
        }
        return null;
    }

    private void validateConfigServerName(String serverName, String configServerName, String methodName) throws OMAGInvalidParameterException {
        if (!serverName.equals(configServerName)) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.INCOMPATIBLE_SERVER_NAMES.getMessageDefinition(new String[]{serverName, configServerName}), this.getClass().getName(), methodName);
        }
    }
}

