/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationGroupConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class OMAGServerErrorHandler {
    void validateUserId(String userId, String serverName, String methodName) throws OMAGNotAuthorizedException {
        if (userId == null || userId.length() == 0) {
            throw new OMAGNotAuthorizedException(OMAGAdminErrorCode.NULL_USER_NAME.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    void validateServerName(String serverName, String methodName) throws OMAGInvalidParameterException {
        if (serverName == null || serverName.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_LOCAL_SERVER_NAME.getMessageDefinition(), this.getClass().getName(), methodName);
        }
    }

    void validateOMAGServerClientConfig(String serverName, OMAGServerClientConfig clientConfig, String methodName) throws OMAGInvalidParameterException {
        if (clientConfig == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_CLIENT_CONFIG.getMessageDefinition(new String[]{serverName, methodName}), this.getClass().getName(), methodName);
        }
        this.validateServerName(serverName, methodName);
        this.validateOMAGServerServiceRootURL(clientConfig.getOMAGServerPlatformRootURL(), serverName, methodName);
        this.validateOMAGServerName(clientConfig.getOMAGServerPlatformRootURL(), serverName, methodName);
    }

    void validateIntegrationServiceConfig(String serverName, IntegrationServiceRequestBody integrationServiceConfig, String methodName) throws OMAGInvalidParameterException {
        String connectorConfigPropertyName = "integrationServerConfig.connectorConfig";
        String connectorNamePropertyName = "integrationServerConfig.connectorConfig.connectorName";
        this.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)integrationServiceConfig, methodName);
        for (IntegrationConnectorConfig connectorConfig : integrationServiceConfig.getIntegrationConnectorConfigs()) {
            this.validatePropertyNotNull(connectorConfig, "integrationServerConfig.connectorConfig", serverName, methodName);
            this.validatePropertyNotNull(connectorConfig.getConnectorName(), "integrationServerConfig.connectorConfig.connectorName", serverName, methodName);
            this.validateServerConnection(connectorConfig.getConnection(), serverName, methodName);
        }
    }

    void validateIntegrationGroupConfig(String serverName, IntegrationGroupConfig integrationGroupConfig, String methodName) throws OMAGInvalidParameterException {
        String qualifiedNamePropertyName = "integrationGroupConfig.integrationGroupQualifiedName";
        this.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)integrationGroupConfig, methodName);
        this.validatePropertyNotNull(integrationGroupConfig.getIntegrationGroupQualifiedName(), "integrationGroupConfig.integrationGroupQualifiedName", serverName, methodName);
    }

    EventBusConfig validateEventBusIsSet(String serverName, OMAGServerConfig serverConfig, String methodName) throws OMAGConfigurationErrorException {
        EventBusConfig eventBusConfig = null;
        if (serverConfig != null) {
            eventBusConfig = serverConfig.getEventBusConfig();
        }
        if (eventBusConfig == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.NO_EVENT_BUS_SET.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
        return eventBusConfig;
    }

    void validateAccessServiceIsRegistered(AccessServiceRegistrationEntry registration, String serviceURLMarker, String serverName, String methodName) throws OMAGConfigurationErrorException {
        if (registration == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.ACCESS_SERVICE_NOT_RECOGNIZED.getMessageDefinition(new String[]{serverName, serviceURLMarker}), this.getClass().getName(), methodName);
        }
        if (registration.getAccessServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.ACCESS_SERVICE_NOT_ENABLED.getMessageDefinition(new String[]{serverName, serviceURLMarker}), this.getClass().getName(), methodName);
        }
    }

    void validateViewServiceIsRegistered(ViewServiceRegistrationEntry registration, String serviceURLMarker, String serverName, String methodName) throws OMAGConfigurationErrorException {
        if (registration == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.VIEW_SERVICE_NOT_RECOGNIZED.getMessageDefinition(new String[]{serverName, serviceURLMarker}), this.getClass().getName(), methodName);
        }
        if (registration.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.VIEW_SERVICE_NOT_ENABLED.getMessageDefinition(new String[]{serverName, serviceURLMarker}), this.getClass().getName(), methodName);
        }
    }

    void validateEngineServiceIsRegistered(EngineServiceRegistrationEntry registration, String serviceURLMarker, String serverName, String methodName) throws OMAGConfigurationErrorException {
        if (registration == null) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.ENGINE_SERVICE_NOT_RECOGNIZED.getMessageDefinition(new String[]{serverName, serviceURLMarker}), this.getClass().getName(), methodName);
        }
        if (registration.getEngineServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.ENGINE_SERVICE_NOT_ENABLED.getMessageDefinition(new String[]{serverName, serviceURLMarker}), this.getClass().getName(), methodName);
        }
    }

    void validateAccessServiceRootURL(String accessServiceRootURL, String accessServiceName, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (accessServiceRootURL == null || accessServiceRootURL.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_ACCESS_SERVICE_ROOT_URL.getMessageDefinition(new String[]{serverService, serverName, accessServiceName}), this.getClass().getName(), serverService);
        }
    }

    void validateAccessServiceServerName(String accessServiceServerName, String accessServiceName, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (accessServiceServerName == null || accessServiceServerName.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_ACCESS_SERVICE_SERVER_NAME.getMessageDefinition(new String[]{serverService, serverName, accessServiceName}), this.getClass().getName(), serverService);
        }
    }

    void validateCohortName(String cohortName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (cohortName == null || cohortName.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_COHORT_NAME.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    CohortConfig validateCohortIsSet(String serverName, OMAGServerConfig serverConfig, String cohortName, String methodName) throws OMAGInvalidParameterException {
        List cohortConfigs;
        RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
        if (repositoryServicesConfig != null && (cohortConfigs = repositoryServicesConfig.getCohortConfigList()) != null) {
            for (CohortConfig cohortConfig : cohortConfigs) {
                if (cohortConfig == null || !cohortName.equals(cohortConfig.getCohortName())) continue;
                return cohortConfig;
            }
        }
        throw new OMAGInvalidParameterException(OMAGAdminErrorCode.COHORT_NOT_KNOWN.getMessageDefinition(new String[]{serverName, cohortName}), this.getClass().getName(), methodName);
    }

    void logNoCohortTopicChange(String cohortName, String serverName, String methodName) throws OMAGConfigurationErrorException {
        throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.COHORT_TOPIC_STRANGE.getMessageDefinition(new String[]{serverName, cohortName}), this.getClass().getName(), methodName);
    }

    void validateFileName(String fileName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (fileName == null || fileName.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_FILE_NAME.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    void validateMetadataCollectionName(String name, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (name == null || name.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_METADATA_COLLECTION_NAME.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
    }

    void validateServerConnection(Connection connection, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (connection == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_CONNECTION.getMessageDefinition(new String[]{serverName, methodName}), this.getClass().getName(), methodName);
        }
        this.tryConnection(connection, methodName);
    }

    void validatePlatformConnection(Connection connection, String methodName) throws OMAGInvalidParameterException {
        if (connection == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_PLATFORM_CONNECTION.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        this.tryConnection(connection, methodName);
    }

    private void tryConnection(Connection connection, String methodName) throws OMAGInvalidParameterException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            connectorBroker.getConnector(connection);
        }
        catch (ConnectionCheckedException | ConnectorCheckedException error) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.BAD_CONNECTION.getMessageDefinition(new String[]{methodName, connection.toString(), error.getClass().getName(), error.getMessage(), error.getReportedSystemAction(), error.getReportedUserAction()}), this.getClass().getName(), methodName, error);
        }
    }

    void validatePropertyNotNull(Object property, String propertyName, String serverName, String methodName) throws OMAGInvalidParameterException {
        if (property == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.MISSING_CONFIGURATION_PROPERTY.getMessageDefinition(new String[]{serverName, propertyName}), this.getClass().getName(), methodName);
        }
    }

    void validateOMAGServerServiceRootURL(String omagServerServiceRootURL, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (omagServerServiceRootURL == null || omagServerServiceRootURL.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_OMAG_SERVER_ROOT_URL.getMessageDefinition(new String[]{serverService, serverName}), this.getClass().getName(), serverService);
        }
    }

    public void validateOMAGServerName(String omagServerName, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (omagServerName == null || omagServerName.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_OMAG_SERVER_NAME.getMessageDefinition(new String[]{serverService, serverName}), this.getClass().getName(), serverService);
        }
    }

    public void validateServiceURLMarker(String serviceURLMarker, String serverName, String serverService) throws OMAGInvalidParameterException {
        if (serviceURLMarker == null || serviceURLMarker.length() == 0) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_SERVICE_URL_MARKER.getMessageDefinition(new String[]{serverService, serverName}), this.getClass().getName(), serverService);
        }
    }
}

