/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.registration.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.rest.AccessServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.AccessServicesResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForAccessServices {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForAccessServices.class), CommonServicesDescription.ADMINISTRATION_SERVICES.getServiceName());
    private static final String defaultInTopicName = "InTopic";
    private static final String defaultOutTopicName = "OutTopic";
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public RegisteredOMAGServicesResponse getConfiguredAccessServices(String userId, String serverName) {
        String methodName = "getConfiguredAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfiguredAccessServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getConfiguredAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "getConfiguredAccessServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getConfiguredAccessServices");
            List accessServiceConfigList = serverConfig.getAccessServicesConfig();
            if (accessServiceConfigList != null && !accessServiceConfigList.isEmpty()) {
                ArrayList<RegisteredOMAGService> services = new ArrayList<RegisteredOMAGService>();
                for (AccessServiceConfig accessServiceConfig : accessServiceConfigList) {
                    if (accessServiceConfig == null) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceId(accessServiceConfig.getAccessServiceId());
                    service.setServiceName(accessServiceConfig.getAccessServiceFullName());
                    service.setServiceDevelopmentStatus(accessServiceConfig.getAccessServiceDevelopmentStatus());
                    service.setServiceDescription(accessServiceConfig.getAccessServiceDescription());
                    service.setServiceURLMarker(accessServiceConfig.getAccessServiceURLMarker());
                    service.setServiceWiki(accessServiceConfig.getAccessServiceWiki());
                    service.setServerType(ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName());
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getConfiguredAccessServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AccessServicesResponse getAccessServicesConfiguration(String userId, String serverName) {
        String methodName = "getAccessServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAccessServicesConfiguration");
        AccessServicesResponse response = new AccessServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getAccessServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getAccessServicesConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getAccessServicesConfiguration");
            response.setServices(serverConfig.getAccessServicesConfig());
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getAccessServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAccessService(String userId, String serverName, String serviceURLMarker, Map<String, Object> accessServiceOptions) {
        String methodName = "configureAccessService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAccessService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAccessService");
            this.errorHandler.validateUserId(userId, serverName, "configureAccessService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureAccessService");
            EventBusConfig eventBusConfig = serverConfig.getEventBusConfig();
            List<AccessServiceConfig> accessServiceConfigList = serverConfig.getAccessServicesConfig();
            EnterpriseAccessConfig enterpriseAccessConfig = this.getEnterpriseAccessConfig(serverConfig);
            AccessServiceRegistrationEntry accessServiceRegistration = OMAGAccessServiceRegistration.getAccessServiceRegistration((String)serviceURLMarker);
            this.errorHandler.validateAccessServiceIsRegistered(accessServiceRegistration, serviceURLMarker, serverName, "configureAccessService");
            accessServiceConfigList = this.updateAccessServiceConfig(this.createAccessServiceConfig(accessServiceRegistration, accessServiceOptions, eventBusConfig, serverName, serverConfig.getLocalServerId()), accessServiceConfigList);
            if (enterpriseAccessConfig == null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureAccessService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAllAccessServices(String userId, String serverName, Map<String, Object> accessServiceOptions) {
        String methodName = "configureAllAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAllAccessServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAllAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "configureAllAccessServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureAllAccessServices");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "configureAllAccessServices");
            ArrayList<AccessServiceConfig> accessServiceConfigList = new ArrayList<AccessServiceConfig>();
            EnterpriseAccessConfig enterpriseAccessConfig = null;
            List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
            if (accessServiceRegistrationList != null && !accessServiceRegistrationList.isEmpty()) {
                for (AccessServiceRegistrationEntry registration : accessServiceRegistrationList) {
                    if (registration == null || registration.getAccessServiceDevelopmentStatus() == ComponentDevelopmentStatus.DEPRECATED) continue;
                    accessServiceConfigList.add(this.createAccessServiceConfig(registration, accessServiceOptions, eventBusConfig, serverName, serverConfig.getLocalServerId()));
                }
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            if (accessServiceConfigList.isEmpty()) {
                accessServiceConfigList = null;
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureAllAccessServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAccessServiceNoTopics(String userId, String serverName, String serviceURLMarker, Map<String, Object> accessServiceOptions) {
        String methodName = "configureAccessServiceNoTopics";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAccessServiceNoTopics");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAccessServiceNoTopics");
            this.errorHandler.validateUserId(userId, serverName, "configureAccessServiceNoTopics");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureAccessServiceNoTopics");
            List<AccessServiceConfig> accessServiceConfigList = serverConfig.getAccessServicesConfig();
            EnterpriseAccessConfig enterpriseAccessConfig = this.getEnterpriseAccessConfig(serverConfig);
            AccessServiceRegistrationEntry accessServiceRegistration = OMAGAccessServiceRegistration.getAccessServiceRegistration((String)serviceURLMarker);
            this.errorHandler.validateAccessServiceIsRegistered(accessServiceRegistration, serviceURLMarker, serverName, "configureAccessServiceNoTopics");
            accessServiceConfigList = this.updateAccessServiceConfig(this.createAccessServiceConfig(accessServiceRegistration, accessServiceOptions, null, serverName, serverConfig.getLocalServerId()), accessServiceConfigList);
            if (enterpriseAccessConfig == null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureAccessServiceNoTopics", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAllAccessServicesNoTopics(String userId, String serverName, Map<String, Object> accessServiceOptions) {
        String methodName = "configureAllAccessServicesNoTopics";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAllAccessServicesNoTopics");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAllAccessServicesNoTopics");
            this.errorHandler.validateUserId(userId, serverName, "configureAllAccessServicesNoTopics");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureAllAccessServicesNoTopics");
            ArrayList<AccessServiceConfig> accessServiceConfigList = new ArrayList<AccessServiceConfig>();
            EnterpriseAccessConfig enterpriseAccessConfig = null;
            List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
            if (accessServiceRegistrationList != null && !accessServiceRegistrationList.isEmpty()) {
                for (AccessServiceRegistrationEntry registration : accessServiceRegistrationList) {
                    if (registration == null || registration.getAccessServiceDevelopmentStatus() == ComponentDevelopmentStatus.DEPRECATED) continue;
                    accessServiceConfigList.add(this.createAccessServiceConfig(registration, accessServiceOptions, null, serverName, serverConfig.getLocalServerId()));
                }
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            if (accessServiceConfigList.isEmpty()) {
                accessServiceConfigList = null;
            }
            this.setAccessServicesConfig(userId, serverName, accessServiceConfigList);
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureAllAccessServicesNoTopics", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private AccessServiceConfig createAccessServiceConfig(AccessServiceRegistrationEntry registration, Map<String, Object> accessServiceOptions, EventBusConfig eventBusConfig, String serverName, String localServerId) {
        ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
        AccessServiceConfig accessServiceConfig = new AccessServiceConfig(registration);
        accessServiceConfig.setAccessServiceOptions(accessServiceOptions);
        if (eventBusConfig != null) {
            accessServiceConfig.setAccessServiceInTopic(connectorConfigurationFactory.getDefaultEventBusConnection(eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, registration.getAccessServiceInTopic(), localServerId, null, eventBusConfig.getConfigurationProperties()));
            accessServiceConfig.setAccessServiceOutTopic(connectorConfigurationFactory.getDefaultEventBusConnection(eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot() + ".server." + serverName, registration.getAccessServiceOutTopic(), localServerId, null, eventBusConfig.getConfigurationProperties()));
        }
        return accessServiceConfig;
    }

    private List<AccessServiceConfig> updateAccessServiceConfig(AccessServiceConfig accessServiceConfig, List<AccessServiceConfig> currentList) {
        if (accessServiceConfig == null) {
            return currentList;
        }
        ArrayList<AccessServiceConfig> newList = new ArrayList<AccessServiceConfig>();
        if (currentList != null) {
            for (AccessServiceConfig existingConfig : currentList) {
                if (existingConfig == null || accessServiceConfig.getAccessServiceId() == existingConfig.getAccessServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(accessServiceConfig);
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    public VoidResponse clearAllAccessServices(String userId, String serverName) {
        String methodName = "clearAllAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllAccessServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearAllAccessServices");
            this.errorHandler.validateUserId(userId, serverName, "clearAllAccessServices");
            this.setAccessServicesConfig(userId, serverName, null);
            this.setEnterpriseAccessConfig(userId, serverName, null);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearAllAccessServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AccessServiceConfigResponse getAccessServiceConfig(String userId, String serverName, String serviceURLMarker) {
        String methodName = "getAccessServiceConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAccessServiceConfig");
        AccessServiceConfigResponse response = new AccessServiceConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getAccessServiceConfig");
            this.errorHandler.validateUserId(userId, serverName, "getAccessServiceConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getAccessServiceConfig");
            List currentList = serverConfig.getAccessServicesConfig();
            if (currentList != null) {
                for (AccessServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || !serviceURLMarker.equals(existingConfig.getAccessServiceURLMarker())) continue;
                    response.setConfig(existingConfig);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getAccessServiceConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAccessService(String userId, String serverName, String serviceURLMarker) {
        String methodName = "clearAccessService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAccessService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearAccessService");
            this.errorHandler.validateUserId(userId, serverName, "clearAccessService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearAccessService");
            List currentList = serverConfig.getAccessServicesConfig();
            ArrayList<AccessServiceConfig> newList = new ArrayList<AccessServiceConfig>();
            if (currentList != null) {
                for (AccessServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || serviceURLMarker.equals(existingConfig.getAccessServiceURLMarker())) continue;
                    newList.add(existingConfig);
                }
                serverConfig.setAccessServicesConfig(newList);
                this.configStore.saveServerConfig(serverName, "clearAccessService", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearAccessService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StringMapResponse getAccessServiceTopicNames(String userId, String serverName, String serviceURLMarker) {
        String methodName = "getAccessServiceTopicNames";
        String propertyName = "serviceURLMarker";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAccessServiceTopicNames");
        StringMapResponse response = new StringMapResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getAccessServiceTopicNames");
            this.errorHandler.validateUserId(userId, serverName, "getAccessServiceTopicNames");
            this.errorHandler.validatePropertyNotNull(serviceURLMarker, "serviceURLMarker", serverName, "getAccessServiceTopicNames");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getAccessServiceTopicNames");
            List configuredAccessServices = serverConfig.getAccessServicesConfig();
            if (configuredAccessServices != null) {
                for (AccessServiceConfig accessServiceConfig : configuredAccessServices) {
                    if (accessServiceConfig == null || !serviceURLMarker.equals(accessServiceConfig.getAccessServiceURLMarker())) continue;
                    HashMap<CallSite, String> topicNames = new HashMap<CallSite, String>();
                    if (accessServiceConfig.getAccessServiceInTopic() != null && accessServiceConfig.getAccessServiceInTopic().getEndpoint() != null) {
                        topicNames.put((CallSite)((Object)(accessServiceConfig.getAccessServiceFullName() + " InTopic")), accessServiceConfig.getAccessServiceInTopic().getEndpoint().getAddress());
                    }
                    if (accessServiceConfig.getAccessServiceOutTopic() != null && accessServiceConfig.getAccessServiceOutTopic().getEndpoint() != null) {
                        topicNames.put((CallSite)((Object)(accessServiceConfig.getAccessServiceFullName() + " OutTopic")), accessServiceConfig.getAccessServiceOutTopic().getEndpoint().getAddress());
                    }
                    response.setStringMap(topicNames);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getAccessServiceTopicNames", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StringMapResponse getAllAccessServiceTopicNames(String userId, String serverName) {
        String methodName = "getAccessServiceTopicNames";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAccessServiceTopicNames");
        StringMapResponse response = new StringMapResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getAccessServiceTopicNames");
            this.errorHandler.validateUserId(userId, serverName, "getAccessServiceTopicNames");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getAccessServiceTopicNames");
            List configuredAccessServices = serverConfig.getAccessServicesConfig();
            if (configuredAccessServices != null) {
                HashMap<CallSite, String> topicNames = new HashMap<CallSite, String>();
                for (AccessServiceConfig accessServiceConfig : configuredAccessServices) {
                    if (accessServiceConfig == null) continue;
                    if (accessServiceConfig.getAccessServiceInTopic() != null && accessServiceConfig.getAccessServiceInTopic().getEndpoint() != null) {
                        topicNames.put((CallSite)((Object)(accessServiceConfig.getAccessServiceFullName() + " InTopic")), accessServiceConfig.getAccessServiceInTopic().getEndpoint().getAddress());
                    }
                    if (accessServiceConfig.getAccessServiceOutTopic() == null || accessServiceConfig.getAccessServiceOutTopic().getEndpoint() == null) continue;
                    topicNames.put((CallSite)((Object)(accessServiceConfig.getAccessServiceFullName() + " OutTopic")), accessServiceConfig.getAccessServiceOutTopic().getEndpoint().getAddress());
                }
                response.setStringMap(topicNames);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getAccessServiceTopicNames", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse overrideAccessServiceInTopicName(String userId, String serverName, String serviceURLMarker, String topicName) {
        String methodName = "overrideAccessServiceInTopicName";
        String serviceURLMarkerPropertyName = "serviceURLMarker";
        String topicPropertyName = "topicName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "overrideAccessServiceInTopicName");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "overrideAccessServiceInTopicName");
            this.errorHandler.validateUserId(userId, serverName, "overrideAccessServiceInTopicName");
            this.errorHandler.validatePropertyNotNull(topicName, "topicName", serverName, "overrideAccessServiceInTopicName");
            this.errorHandler.validatePropertyNotNull(serviceURLMarker, "serviceURLMarker", serverName, "overrideAccessServiceInTopicName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "overrideAccessServiceInTopicName");
            List configuredAccessServices = serverConfig.getAccessServicesConfig();
            if (configuredAccessServices != null) {
                for (AccessServiceConfig accessServiceConfig : configuredAccessServices) {
                    Endpoint endpoint;
                    Connection connection;
                    if (accessServiceConfig == null || !serviceURLMarker.equals(accessServiceConfig.getAccessServiceURLMarker()) || (connection = accessServiceConfig.getAccessServiceInTopic()) == null || (endpoint = connection.getEndpoint()) == null) continue;
                    endpoint.setAddress(topicName);
                    connection.setEndpoint(endpoint);
                    accessServiceConfig.setAccessServiceInTopic(connection);
                    this.setAccessServicesConfig(userId, serverName, configuredAccessServices);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "overrideAccessServiceInTopicName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse overrideAccessServiceOutTopicName(String userId, String serverName, String serviceURLMarker, String topicName) {
        String methodName = "overrideAccessServiceOutTopicName";
        String serviceURLMarkerPropertyName = "serviceURLMarker";
        String topicPropertyName = "topicName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "overrideAccessServiceOutTopicName");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "overrideAccessServiceOutTopicName");
            this.errorHandler.validateUserId(userId, serverName, "overrideAccessServiceOutTopicName");
            this.errorHandler.validatePropertyNotNull(topicName, "topicName", serverName, "overrideAccessServiceOutTopicName");
            this.errorHandler.validatePropertyNotNull(serviceURLMarker, "serviceURLMarker", serverName, "overrideAccessServiceOutTopicName");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "overrideAccessServiceOutTopicName");
            List configuredAccessServices = serverConfig.getAccessServicesConfig();
            if (configuredAccessServices != null) {
                for (AccessServiceConfig accessServiceConfig : configuredAccessServices) {
                    Endpoint endpoint;
                    Connection connection;
                    if (accessServiceConfig == null || !serviceURLMarker.equals(accessServiceConfig.getAccessServiceURLMarker()) || (connection = accessServiceConfig.getAccessServiceOutTopic()) == null || (endpoint = connection.getEndpoint()) == null) continue;
                    endpoint.setAddress(topicName);
                    connection.setEndpoint(endpoint);
                    accessServiceConfig.setAccessServiceOutTopic(connection);
                    this.setAccessServicesConfig(userId, serverName, configuredAccessServices);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "overrideAccessServiceOutTopicName", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setAccessServicesConfig(String userId, String serverName, List<AccessServiceConfig> accessServicesConfig) {
        String methodName = "setAccessServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setAccessServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setAccessServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "setAccessServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setAccessServicesConfig");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (accessServicesConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for access services.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " updated configuration for access services.")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setAccessServicesConfig(accessServicesConfig);
            this.configStore.saveServerConfig(serverName, "setAccessServicesConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setAccessServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private EnterpriseAccessConfig getEnterpriseAccessConfig(OMAGServerConfig serverConfig) {
        RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
        if (repositoryServicesConfig != null) {
            return repositoryServicesConfig.getEnterpriseAccessConfig();
        }
        return null;
    }

    public VoidResponse addRemoteEnterpriseTopic(String userId, String serverName, Map<String, Object> configurationProperties) {
        String methodName = "addRemoteEnterpriseTopic";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addRemoteEnterpriseTopic");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addRemoteEnterpriseTopic");
            this.errorHandler.validateUserId(userId, serverName, "addRemoteEnterpriseTopic");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addRemoteEnterpriseTopic");
            EventBusConfig eventBusConfig = this.errorHandler.validateEventBusIsSet(serverName, serverConfig, "addRemoteEnterpriseTopic");
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            EnterpriseAccessConfig enterpriseAccessConfig = this.getEnterpriseAccessConfig(serverConfig);
            if (enterpriseAccessConfig == null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                enterpriseAccessConfig = configurationFactory.getDefaultEnterpriseAccessConfig(serverConfig.getLocalServerName(), serverConfig.getLocalServerId());
            }
            enterpriseAccessConfig.setRemoteEnterpriseOMRSTopicConnection(connectorConfigurationFactory.getDefaultRemoteEnterpriseOMRSTopicConnection(serverName, configurationProperties, eventBusConfig.getConnectorProvider(), eventBusConfig.getTopicURLRoot(), serverConfig.getLocalServerId(), eventBusConfig.getConfigurationProperties()));
            this.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addRemoteEnterpriseTopic", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setEnterpriseAccessConfig(String userId, String serverName, EnterpriseAccessConfig enterpriseAccessConfig) {
        String methodName = "setEnterpriseAccessConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEnterpriseAccessConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEnterpriseAccessConfig");
            this.errorHandler.validateUserId(userId, serverName, "setEnterpriseAccessConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setEnterpriseAccessConfig");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (enterpriseAccessConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed configuration for enterprise repository services (used by access services).")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for enterprise repository services (used by access services).")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            RepositoryServicesConfig repositoryServicesConfig = serverConfig.getRepositoryServicesConfig();
            if (repositoryServicesConfig != null) {
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            } else if (enterpriseAccessConfig != null) {
                OMRSConfigurationFactory configurationFactory = new OMRSConfigurationFactory();
                repositoryServicesConfig = configurationFactory.getDefaultRepositoryServicesConfig();
                repositoryServicesConfig.setEnterpriseAccessConfig(enterpriseAccessConfig);
            }
            serverConfig.setRepositoryServicesConfig(repositoryServicesConfig);
            this.configStore.saveServerConfig(serverName, "setEnterpriseAccessConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setEnterpriseAccessConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

