/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.EngineHostServicesResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceRequestBody;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.OMAGEngineServiceRegistration;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForEngineHostServices {
    private static final String serviceName = GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName();
    private static final String accessService = AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceName();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForEngineHostServices.class), CommonServicesDescription.ADMINISTRATION_SERVICES.getServiceName());
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setEngineDefinitionsClientConfig(String userId, String serverName, OMAGServerClientConfig clientConfig) {
        String methodName = "setEngineDefinitionsClientConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEngineDefinitionsClientConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEngineDefinitionsClientConfig");
            this.errorHandler.validateUserId(userId, serverName, "setEngineDefinitionsClientConfig");
            String accessServiceRootURL = null;
            String accessServiceServerName = null;
            if (clientConfig != null) {
                accessServiceRootURL = clientConfig.getOMAGServerPlatformRootURL();
                accessServiceServerName = clientConfig.getOMAGServerName();
            }
            this.errorHandler.validateAccessServiceRootURL(accessServiceRootURL, accessService, serverName, serviceName);
            this.errorHandler.validateAccessServiceServerName(accessServiceServerName, accessService, serverName, serviceName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setEngineDefinitionsClientConfig");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (accessServiceRootURL == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed configuration for " + serviceName + " access service root url.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for " + serviceName + " access service root url to " + accessServiceRootURL + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineHostServicesConfig == null) {
                engineHostServicesConfig = new EngineHostServicesConfig();
                if (serverConfig.getRepositoryServicesConfig() == null) {
                    OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                    serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
                }
            }
            engineHostServicesConfig.setOMAGServerPlatformRootURL(accessServiceRootURL);
            engineHostServicesConfig.setOMAGServerName(accessServiceServerName);
            serverConfig.setEngineHostServicesConfig(engineHostServicesConfig);
            this.configStore.saveServerConfig(serverName, "setEngineDefinitionsClientConfig", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setEngineDefinitionsClientConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEngineDefinitionsClientConfig(String userId, String serverName) {
        String methodName = "clearEngineDefinitionsClientConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEngineDefinitionsClientConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearEngineDefinitionsClientConfig");
            this.errorHandler.validateUserId(userId, serverName, "clearEngineDefinitionsClientConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearEngineDefinitionsClientConfig");
            if (serverConfig != null) {
                EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
                if (engineHostServicesConfig != null) {
                    engineHostServicesConfig.setOMAGServerPlatformRootURL(null);
                    engineHostServicesConfig.setOMAGServerName(null);
                }
                serverConfig.setEngineHostServicesConfig(engineHostServicesConfig);
                this.configStore.saveServerConfig(serverName, "clearEngineDefinitionsClientConfig", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearEngineDefinitionsClientConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setEngineList(String userId, String serverName, List<EngineConfig> engines) {
        String methodName = "setEngineList";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEngineList");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEngineList");
            this.errorHandler.validateUserId(userId, serverName, "setEngineList");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setEngineList");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (engines == null || engines.isEmpty()) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed engine list.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated engine list.")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineHostServicesConfig == null) {
                engineHostServicesConfig = new EngineHostServicesConfig();
                if (serverConfig.getRepositoryServicesConfig() == null) {
                    OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                    serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
                }
            }
            engineHostServicesConfig.setEngineList(engines);
            serverConfig.setEngineHostServicesConfig(engineHostServicesConfig);
            this.configStore.saveServerConfig(serverName, "setEngineList", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setEngineList", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addEngine(String userId, String serverName, EngineConfig engine) {
        String methodName = "addEngine";
        String engineParameterName = "engine";
        String engineNameParameterName = "engine.qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addEngine");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "addEngine");
            this.errorHandler.validateUserId(userId, serverName, "addEngine");
            this.errorHandler.validatePropertyNotNull(engine, "engine", serverName, "addEngine");
            this.errorHandler.validatePropertyNotNull(engine.getEngineQualifiedName(), "engine.qualifiedName", serverName, "addEngine");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "addEngine");
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " add new engine " + engine.getEngineQualifiedName() + " to list.")));
            serverConfig.setAuditTrail(configAuditTrail);
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineHostServicesConfig == null) {
                engineHostServicesConfig = new EngineHostServicesConfig();
                if (serverConfig.getRepositoryServicesConfig() == null) {
                    OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                    serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
                }
            }
            HashMap<String, EngineConfig> engines = new HashMap<String, EngineConfig>();
            if (engineHostServicesConfig.getEngineList() != null) {
                for (EngineConfig engineConfig : engineHostServicesConfig.getEngineList()) {
                    if (engineConfig == null || engineConfig.getEngineQualifiedName() == null || engineConfig.getEngineQualifiedName().isBlank()) continue;
                    engines.put(engineConfig.getEngineQualifiedName(), engineConfig);
                }
            }
            engines.put(engine.getEngineQualifiedName(), engine);
            engineHostServicesConfig.setEngineList(new ArrayList(engines.values()));
            serverConfig.setEngineHostServicesConfig(engineHostServicesConfig);
            this.configStore.saveServerConfig(serverName, "addEngine", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "addEngine", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEngineList(String userId, String serverName) {
        String methodName = "clearEngineList";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEngineList");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearEngineList");
            this.errorHandler.validateUserId(userId, serverName, "clearEngineList");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearEngineList");
            if (serverConfig != null) {
                EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
                if (engineHostServicesConfig != null) {
                    engineHostServicesConfig.setEngineList(null);
                }
                serverConfig.setEngineHostServicesConfig(engineHostServicesConfig);
                this.configStore.saveServerConfig(serverName, "clearEngineList", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearEngineList", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineServiceConfigResponse getEngineServiceConfiguration(String userId, String serverName, String serviceURLMarker) {
        String methodName = "getEngineServiceConfiguration";
        String serviceURLMarkerParameterName = "serviceURLMarker";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEngineServiceConfiguration");
        EngineServiceConfigResponse response = new EngineServiceConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getEngineServiceConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getEngineServiceConfiguration");
            this.errorHandler.validatePropertyNotNull(serviceURLMarker, "serviceURLMarker", serverName, "getEngineServiceConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getEngineServiceConfiguration");
            List currentList = null;
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineHostServicesConfig != null) {
                currentList = engineHostServicesConfig.getEngineServiceConfigs();
            }
            if (currentList != null) {
                for (EngineServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || !serviceURLMarker.equals(existingConfig.getEngineServiceURLMarker())) continue;
                    response.setConfig(existingConfig);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getEngineServiceConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getConfiguredEngineServices(String userId, String serverName) {
        String methodName = "getConfiguredEngineServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfiguredEngineServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getConfiguredEngineServices");
            this.errorHandler.validateUserId(userId, serverName, "getConfiguredEngineServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getConfiguredEngineServices");
            List engineServiceConfigs = null;
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineHostServicesConfig != null) {
                engineServiceConfigs = engineHostServicesConfig.getEngineServiceConfigs();
            }
            if (engineServiceConfigs != null && !engineServiceConfigs.isEmpty()) {
                ArrayList<RegisteredOMAGService> services = new ArrayList<RegisteredOMAGService>();
                for (EngineServiceConfig engineServiceConfig : engineServiceConfigs) {
                    if (engineServiceConfig == null) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceId(engineServiceConfig.getEngineServiceId());
                    service.setServiceName(engineServiceConfig.getEngineServiceFullName());
                    service.setServiceDevelopmentStatus(engineServiceConfig.getEngineServiceDevelopmentStatus());
                    service.setServiceDescription(engineServiceConfig.getEngineServiceDescription());
                    service.setServiceURLMarker(engineServiceConfig.getEngineServiceURLMarker());
                    service.setServiceWiki(engineServiceConfig.getEngineServiceWiki());
                    service.setServerType(ServerTypeClassification.ENGINE_HOST.getServerTypeName());
                    service.setPartnerServiceName(engineServiceConfig.getEngineServicePartnerOMAS());
                    service.setPartnerServerType(ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName());
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getConfiguredEngineServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureEngineService(String userId, String serverName, String serviceURLMarker, EngineServiceRequestBody requestBody) {
        String methodName = "configureEngineService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureEngineService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureEngineService");
            this.errorHandler.validateUserId(userId, serverName, "configureEngineService");
            this.errorHandler.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)requestBody, "configureEngineService");
            EngineServiceRegistrationEntry registration = OMAGEngineServiceRegistration.getEngineServiceRegistration((String)serviceURLMarker);
            this.errorHandler.validateEngineServiceIsRegistered(registration, serviceURLMarker, serverName, "configureEngineService");
            EngineServiceConfig newEngineServiceConfig = new EngineServiceConfig(registration);
            newEngineServiceConfig.setOMAGServerPlatformRootURL(requestBody.getOMAGServerPlatformRootURL());
            newEngineServiceConfig.setOMAGServerName(requestBody.getOMAGServerName());
            newEngineServiceConfig.setEngines(requestBody.getEngines());
            newEngineServiceConfig.setEngineServiceOptions(requestBody.getEngineServiceOptions());
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureEngineService");
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            List existingEngineServices = null;
            if (engineHostServicesConfig != null) {
                existingEngineServices = engineHostServicesConfig.getEngineServiceConfigs();
            }
            response = this.storeEngineServicesConfig(userId, serverName, serviceURLMarker, this.updateEngineServiceConfig(newEngineServiceConfig, existingEngineServices), "configureEngineService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureEngineService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAllEngineServices(String userId, String serverName, EngineServiceRequestBody requestBody) {
        String methodName = "configureAllEngineService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAllEngineService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAllEngineService");
            this.errorHandler.validateUserId(userId, serverName, "configureAllEngineService");
            this.errorHandler.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)requestBody, "configureAllEngineService");
            ArrayList<EngineServiceConfig> engineServiceConfigs = new ArrayList<EngineServiceConfig>();
            List engineServiceRegistrationList = OMAGEngineServiceRegistration.getEngineServiceRegistrationList();
            if (engineServiceRegistrationList != null && !engineServiceRegistrationList.isEmpty()) {
                for (EngineServiceRegistrationEntry registration : engineServiceRegistrationList) {
                    if (registration == null || registration.getEngineServiceDevelopmentStatus() == ComponentDevelopmentStatus.DEPRECATED) continue;
                    EngineServiceConfig newEngineServiceConfig = new EngineServiceConfig(registration);
                    newEngineServiceConfig.setOMAGServerPlatformRootURL(requestBody.getOMAGServerPlatformRootURL());
                    newEngineServiceConfig.setOMAGServerName(requestBody.getOMAGServerName());
                    newEngineServiceConfig.setEngines(requestBody.getEngines());
                    newEngineServiceConfig.setEngineServiceOptions(requestBody.getEngineServiceOptions());
                    engineServiceConfigs.add(newEngineServiceConfig);
                }
            }
            if (engineServiceConfigs.isEmpty()) {
                engineServiceConfigs = null;
            }
            return this.storeEngineServicesConfig(userId, serverName, null, engineServiceConfigs, "configureAllEngineService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureAllEngineService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureEngineService(String userId, String serverName, EngineServiceConfig serviceConfig) {
        String methodName = "configureEngineService";
        String serviceConfigParameterName = "serviceConfig";
        String serviceURLMarkerParameterName = "serviceConfig.serviceURLMarker";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureEngineService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureEngineService");
            this.errorHandler.validateUserId(userId, serverName, "configureEngineService");
            this.errorHandler.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)serviceConfig, "configureEngineService");
            this.errorHandler.validatePropertyNotNull(serviceConfig, "serviceConfig", serverName, "configureEngineService");
            this.errorHandler.validatePropertyNotNull(serviceConfig.getEngineServiceURLMarker(), "serviceConfig.serviceURLMarker", serverName, "configureEngineService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureEngineService");
            EngineServiceRegistrationEntry registration = OMAGEngineServiceRegistration.getEngineServiceRegistration((String)serviceConfig.getEngineServiceURLMarker());
            this.errorHandler.validateEngineServiceIsRegistered(registration, serviceConfig.getEngineServiceURLMarker(), serverName, "configureEngineService");
            List existingEngineServices = null;
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineHostServicesConfig != null) {
                existingEngineServices = engineHostServicesConfig.getEngineServiceConfigs();
            }
            response = this.storeEngineServicesConfig(userId, serverName, serviceConfig.getEngineServiceURLMarker(), this.updateEngineServiceConfig(serviceConfig, existingEngineServices), "configureEngineService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureEngineService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<EngineServiceConfig> updateEngineServiceConfig(EngineServiceConfig newEngineServiceConfig, List<EngineServiceConfig> currentList) {
        if (newEngineServiceConfig == null) {
            return currentList;
        }
        ArrayList<EngineServiceConfig> newList = new ArrayList<EngineServiceConfig>();
        if (currentList != null) {
            for (EngineServiceConfig existingConfig : currentList) {
                if (existingConfig == null || newEngineServiceConfig.getEngineServiceId() == existingConfig.getEngineServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(newEngineServiceConfig);
        return newList;
    }

    public VoidResponse setEngineServicesConfig(String userId, String serverName, List<EngineServiceConfig> engineServicesConfig) {
        String methodName = "setEngineHostServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEngineHostServicesConfig");
        VoidResponse response = this.storeEngineServicesConfig(userId, serverName, null, engineServicesConfig, "setEngineHostServicesConfig");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAllEngineServices(String userId, String serverName) {
        String methodName = "clearAllEngineServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllEngineServices");
        VoidResponse response = this.storeEngineServicesConfig(userId, serverName, null, null, "clearAllEngineServices");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEngineService(String userId, String serverName, String serviceURLMarker) {
        String methodName = "clearEngineService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEngineService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearEngineService");
            this.errorHandler.validateUserId(userId, serverName, "clearEngineService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearEngineService");
            List currentList = null;
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineHostServicesConfig != null) {
                currentList = engineHostServicesConfig.getEngineServiceConfigs();
            }
            ArrayList<EngineServiceConfig> newList = new ArrayList<EngineServiceConfig>();
            if (currentList != null) {
                for (EngineServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || serviceURLMarker.equals(existingConfig.getEngineServiceURLMarker())) continue;
                    newList.add(existingConfig);
                }
                response = this.storeEngineServicesConfig(userId, serverName, serviceURLMarker, newList, "clearEngineService");
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearEngineService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private VoidResponse storeEngineServicesConfig(String userId, String serverName, String serviceURLMarker, List<EngineServiceConfig> engineServicesConfig, String methodName) {
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<CallSite> configAuditTrail;
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            if (serverConfig.getRepositoryServicesConfig() == null) {
                OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
            }
            if ((configAuditTrail = serverConfig.getAuditTrail()) == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (engineServicesConfig == null || engineServicesConfig.isEmpty()) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed configuration for engine services.")));
            } else if (serviceURLMarker == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for engine services.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for engine service " + serviceURLMarker + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            EngineHostServicesConfig engineHostServicesConfig = serverConfig.getEngineHostServicesConfig();
            if (engineServicesConfig == null || engineServicesConfig.isEmpty()) {
                if (engineHostServicesConfig != null) {
                    if (engineHostServicesConfig.getOMAGServerPlatformRootURL() == null && engineHostServicesConfig.getOMAGServerName() == null) {
                        serverConfig.setEngineHostServicesConfig(null);
                    } else {
                        engineHostServicesConfig.setEngineServiceConfigs(null);
                        serverConfig.setEngineHostServicesConfig(engineHostServicesConfig);
                    }
                }
            } else {
                if (engineHostServicesConfig == null) {
                    engineHostServicesConfig = new EngineHostServicesConfig();
                }
                engineHostServicesConfig.setEngineServiceConfigs(engineServicesConfig);
                serverConfig.setEngineHostServicesConfig(engineHostServicesConfig);
            }
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }

    public EngineHostServicesResponse getEngineHostServicesConfiguration(String userId, String serverName) {
        String methodName = "getEngineHostServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEngineHostServicesConfiguration");
        EngineHostServicesResponse response = new EngineHostServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getEngineHostServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getEngineHostServicesConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getEngineHostServicesConfiguration");
            response.setServices(serverConfig.getEngineHostServicesConfig());
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getEngineHostServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setEngineHostServicesConfig(String userId, String serverName, EngineHostServicesConfig servicesConfig) {
        String methodName = "setEngineHostServicesConfig";
        String serviceConfigParameterName = "servicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setEngineHostServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setEngineHostServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "setEngineHostServicesConfig");
            this.errorHandler.validatePropertyNotNull(servicesConfig, "servicesConfig", serverName, "setEngineHostServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setEngineHostServicesConfig");
            if (serverConfig != null) {
                if (serverConfig.getRepositoryServicesConfig() == null) {
                    OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                    serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
                }
                serverConfig.setEngineHostServicesConfig(servicesConfig);
                this.configStore.saveServerConfig(serverName, "setEngineHostServicesConfig", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setEngineHostServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEngineHostServicesConfig(String userId, String serverName) {
        String methodName = "clearEngineHostServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEngineHostServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearEngineHostServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "clearEngineHostServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearEngineHostServicesConfig");
            if (serverConfig != null) {
                serverConfig.setEngineHostServicesConfig(null);
                this.configStore.saveServerConfig(serverName, "clearEngineHostServicesConfig", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearEngineHostServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

