/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.registration.OMAGViewServiceRegistration;
import org.odpi.openmetadata.adminservices.rest.ViewServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForViewServices {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForViewServices.class), CommonServicesDescription.ADMINISTRATION_SERVICES.getServiceName());
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public RegisteredOMAGServicesResponse getConfiguredViewServices(String userId, String serverName) {
        String methodName = "getConfiguredViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfiguredViewServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getConfiguredViewServices");
            this.errorHandler.validateUserId(userId, serverName, "getConfiguredViewServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getConfiguredViewServices");
            List viewServiceConfigList = serverConfig.getViewServicesConfig();
            if (viewServiceConfigList != null && !viewServiceConfigList.isEmpty()) {
                ArrayList<RegisteredOMAGService> services = new ArrayList<RegisteredOMAGService>();
                for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                    if (viewServiceConfig == null || viewServiceConfig.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceId(viewServiceConfig.getViewServiceId());
                    service.setServiceName(viewServiceConfig.getViewServiceFullName());
                    service.setServiceDevelopmentStatus(viewServiceConfig.getViewServiceDevelopmentStatus());
                    service.setServiceDescription(viewServiceConfig.getViewServiceDescription());
                    service.setServiceURLMarker(viewServiceConfig.getViewServiceURLMarker());
                    service.setServiceWiki(viewServiceConfig.getViewServiceWiki());
                    service.setServerType(ServerTypeClassification.VIEW_SERVER.getServerTypeName());
                    service.setPartnerServiceName(viewServiceConfig.getViewServicePartnerService());
                    service.setPartnerServerType(ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName());
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getConfiguredViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ViewServicesResponse getViewServicesConfiguration(String userId, String serverName) {
        String methodName = "getViewServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getViewServicesConfiguration");
        ViewServicesResponse response = new ViewServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getViewServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getViewServicesConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getViewServicesConfiguration");
            List viewServiceConfigList = serverConfig.getViewServicesConfig();
            if (viewServiceConfigList != null && !viewServiceConfigList.isEmpty()) {
                ArrayList<ViewServiceConfig> services = new ArrayList<ViewServiceConfig>();
                for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                    if (viewServiceConfig == null || viewServiceConfig.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                    services.add(viewServiceConfig);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getViewServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setViewServicesConfiguration(String userId, String serverName, List<ViewServiceConfig> viewServiceConfigs) {
        String methodName = "setViewServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setViewServicesConfiguration");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setViewServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "setViewServicesConfiguration");
            return this.storeViewServicesConfig(userId, serverName, null, viewServiceConfigs, "setViewServicesConfiguration");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setViewServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ViewServiceConfigResponse getViewServiceConfig(String userId, String serverName, String serviceURLMarker) {
        String methodName = "getViewServiceConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getViewServiceConfig");
        ViewServiceConfigResponse response = new ViewServiceConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getViewServiceConfig");
            this.errorHandler.validateUserId(userId, serverName, "getViewServiceConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getViewServiceConfig");
            List currentList = serverConfig.getViewServicesConfig();
            if (currentList != null) {
                for (ViewServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || !serviceURLMarker.equals(existingConfig.getViewServiceURLMarker())) continue;
                    response.setConfig(existingConfig);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getViewServiceConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureViewService(String userId, String serverName, String serviceURLMarker, ViewServiceRequestBody requestBody) {
        String methodName = "configureViewService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureViewService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureViewService");
            this.errorHandler.validateUserId(userId, serverName, "configureViewService");
            this.errorHandler.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)requestBody, "configureViewService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureViewService");
            List<ViewServiceConfig> viewServiceConfigList = serverConfig.getViewServicesConfig();
            ViewServiceRegistrationEntry viewServiceRegistration = OMAGViewServiceRegistration.getViewServiceRegistration((String)serviceURLMarker);
            this.errorHandler.validateViewServiceIsRegistered(viewServiceRegistration, serviceURLMarker, serverName, "configureViewService");
            viewServiceConfigList = this.updateViewServiceConfig(this.createViewServiceConfig(viewServiceRegistration, requestBody), viewServiceConfigList);
            return this.storeViewServicesConfig(userId, serverName, serviceURLMarker, viewServiceConfigList, "configureViewService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureViewService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAllViewServices(String userId, String serverName, ViewServiceRequestBody requestBody) {
        String methodName = "configureAllViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAllViewServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAllViewServices");
            this.errorHandler.validateUserId(userId, serverName, "configureAllViewServices");
            this.errorHandler.validateOMAGServerClientConfig(serverName, (OMAGServerClientConfig)requestBody, "configureAllViewServices");
            ArrayList<ViewServiceConfig> viewServiceConfigList = new ArrayList<ViewServiceConfig>();
            List viewServiceRegistrationList = OMAGViewServiceRegistration.getViewServiceRegistrationList();
            if (viewServiceRegistrationList != null && !viewServiceRegistrationList.isEmpty()) {
                for (ViewServiceRegistrationEntry registration : viewServiceRegistrationList) {
                    if (registration == null || registration.getViewServiceDevelopmentStatus() == ComponentDevelopmentStatus.DEPRECATED) continue;
                    viewServiceConfigList.add(this.createViewServiceConfig(registration, requestBody));
                }
            }
            if (viewServiceConfigList.isEmpty()) {
                viewServiceConfigList = null;
            }
            return this.storeViewServicesConfig(userId, serverName, null, viewServiceConfigList, "configureAllViewServices");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureAllViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private ViewServiceConfig createViewServiceConfig(ViewServiceRegistrationEntry registration, ViewServiceRequestBody requestBody) {
        ViewServiceConfig viewServiceConfig = new ViewServiceConfig(registration);
        viewServiceConfig.setOMAGServerPlatformRootURL(requestBody.getOMAGServerPlatformRootURL());
        viewServiceConfig.setOMAGServerName(requestBody.getOMAGServerName());
        viewServiceConfig.setViewServiceOptions(requestBody.getViewServiceOptions());
        return viewServiceConfig;
    }

    private List<ViewServiceConfig> updateViewServiceConfig(ViewServiceConfig viewServiceConfig, List<ViewServiceConfig> currentList) {
        if (viewServiceConfig == null) {
            return currentList;
        }
        ArrayList<ViewServiceConfig> newList = new ArrayList<ViewServiceConfig>();
        if (currentList != null) {
            for (ViewServiceConfig existingConfig : currentList) {
                if (existingConfig == null || viewServiceConfig.getViewServiceId() == existingConfig.getViewServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(viewServiceConfig);
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    public VoidResponse clearViewService(String userId, String serverName, String serviceURLMarker) {
        String methodName = "clearViewService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearViewService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearViewService");
            this.errorHandler.validateUserId(userId, serverName, "clearViewService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearViewService");
            List currentList = serverConfig.getViewServicesConfig();
            ArrayList<ViewServiceConfig> newList = new ArrayList<ViewServiceConfig>();
            if (currentList != null) {
                for (ViewServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || serviceURLMarker.equals(existingConfig.getViewServiceURLMarker())) continue;
                    newList.add(existingConfig);
                }
                serverConfig.setViewServicesConfig(newList);
                this.configStore.saveServerConfig(serverName, "clearViewService", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearViewService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAllViewServices(String userId, String serverName) {
        String methodName = "clearAllViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllViewServices");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearAllViewServices");
            this.errorHandler.validateUserId(userId, serverName, "clearAllViewServices");
            return this.storeViewServicesConfig(userId, serverName, null, null, "clearAllViewServices");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearAllViewServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private VoidResponse storeViewServicesConfig(String userId, String serverName, String serviceURLMarker, List<ViewServiceConfig> viewServicesConfig, String methodName) {
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<CallSite> configAuditTrail;
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            if (serverConfig.getRepositoryServicesConfig() == null) {
                OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
            }
            if ((configAuditTrail = serverConfig.getAuditTrail()) == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (viewServicesConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed configuration for view services.")));
            } else if (serviceURLMarker == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for view services.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for view service " + serviceURLMarker + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setViewServicesConfig(viewServicesConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }
}

